/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class FlamingoUtilities {
    public static final String TASKBAR_PROJECTION = "radiance.flamingo.internal.ribbon.taskbarProjection";
    public static final String TASKBAR_COMMAND = "radiance.flamingo.internal.ribbon.taskbarCommand";

    public static int getHLayoutGap(JCommandButton commandButton) {
        Font font = commandButton.getFont();
        return (int)Math.ceil(commandButton.getHGapScaleFactor() * (double)(font.getSize() - 4) / 4.0);
    }

    public static int getVLayoutGap(JCommandButton commandButton) {
        Font font = commandButton.getFont();
        return (int)Math.ceil(commandButton.getVGapScaleFactor() * (double)(font.getSize() - 4) / 4.0);
    }

    public static boolean hasPopupAction(JCommandButton commandButton) {
        return commandButton.getCommandButtonKind().hasPopup();
    }

    public static boolean isShowingMinimizedRibbonInPopup(JRibbon ribbon) {
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        if (popups.size() == 0) {
            return false;
        }
        for (PopupPanelManager.PopupInfo popup : popups) {
            JComponent originator = popup.getPopupOriginator();
            if (!(originator instanceof JRibbonTaskToggleButton)) continue;
            return ribbon == SwingUtilities.getAncestorOfClass(JRibbon.class, originator);
        }
        return false;
    }

    public static void checkResizePoliciesConsistency(AbstractRibbonBand ribbonBand) {
        Insets ins = ribbonBand.getInsets();
        AbstractBandControlPanel controlPanel = ribbonBand.getControlPanel();
        if (controlPanel == null) {
            return;
        }
        int height = controlPanel.getPreferredSize().height + ribbonBand.getUI().getBandTitleHeight() + ins.top + ins.bottom;
        List<RibbonBandResizePolicy> resizePolicies = ribbonBand.getResizePolicies();
        FlamingoUtilities.checkResizePoliciesConsistencyBase(ribbonBand);
        for (int i = 0; i < resizePolicies.size() - 1; ++i) {
            int width2;
            RibbonBandResizePolicy policy1 = resizePolicies.get(i);
            RibbonBandResizePolicy policy2 = resizePolicies.get(i + 1);
            int width1 = policy1.getPreferredWidth(height, 4);
            if (width1 >= (width2 = policy2.getPreferredWidth(height, 4))) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("Inconsistent preferred widths\n");
            builder.append("Ribbon band '" + ribbonBand.getTitle() + "' has the following resize policies\n");
            for (int j = 0; j < resizePolicies.size(); ++j) {
                RibbonBandResizePolicy policy = resizePolicies.get(j);
                int width = policy.getPreferredWidth(height, 4);
                builder.append("\t" + policy.getClass().getName() + " with preferred width " + width + "\n");
            }
            builder.append(policy1.getClass().getName() + " with pref width " + width1 + " is followed by resize policy " + policy2.getClass().getName() + " with larger pref width\n");
            throw new IllegalStateException(builder.toString());
        }
    }

    private static void checkResizePoliciesConsistencyBase(AbstractRibbonBand ribbonBand) {
        List<RibbonBandResizePolicy> resizePolicies = ribbonBand.getResizePolicies();
        if (resizePolicies.size() == 0) {
            throw new IllegalStateException("Must have at least one resize policy");
        }
        if (resizePolicies.size() == 1 && resizePolicies.get(0) instanceof CoreRibbonResizePolicies.IconRibbonBandResizePolicy) {
            throw new IllegalStateException("When icon resize policy is present, must have at least one another resize policy.");
        }
        for (int i = 0; i < resizePolicies.size(); ++i) {
            RibbonBandResizePolicy policy = resizePolicies.get(i);
            boolean isIcon = policy instanceof CoreRibbonResizePolicies.IconRibbonBandResizePolicy;
            if (!isIcon || i >= resizePolicies.size() - 1) continue;
            throw new IllegalStateException("Icon resize policy must be the last in the list");
        }
    }

    public static int getScaledSize(int baseSize, int componentFontSize, double scaleFactor, int stepQuantizationSize) {
        int fontDelta = Math.max(0, componentFontSize - 16);
        int stepCount = fontDelta / stepQuantizationSize;
        return baseSize + (int)(scaleFactor * (double)stepCount * (double)stepQuantizationSize);
    }

    public static int getCommandButtonSmallIconSize(int fontSize) {
        return FlamingoUtilities.getScaledSize(16, fontSize, 1.0, 4);
    }

    public static int getTaskToggleButtonHeight(JRibbon ribbon) {
        FontUIResource titleFont = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getWindowTitleFont();
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics((double)NeonCortex.getScaleFactor((Component)ribbon), (Font)titleFont);
        int fontHeight = fm.getHeight();
        fontHeight += 7;
        int iconHeight = 0;
        if (ribbon.getRootPane().getWindowDecorationStyle() == 1) {
            iconHeight = SubstanceSizeUtils.getTitlePaneIconSize();
        }
        return Math.max(fontHeight, iconHeight) - 2;
    }

    public static boolean existsInMenu(Command command, CommandMenuContentModel menuContentModel) {
        for (CommandGroup group : menuContentModel.getCommandGroups()) {
            for (Command secondary : group.getCommands()) {
                if (secondary == command) {
                    return true;
                }
                CommandMenuContentModel secondaryMenuContentModel = secondary.getSecondaryContentModel();
                if (secondaryMenuContentModel == null || !FlamingoUtilities.existsInMenu(command, secondaryMenuContentModel)) continue;
                return true;
            }
        }
        return false;
    }
}

