/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandStripPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.projection.CommandStripProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.model.RibbonGalleryContentModel;
import org.pushingpixels.flamingo.api.ribbon.model.RibbonGalleryPresentationModel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonGalleryUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.substance.api.SubstanceCortex;

public abstract class BasicRibbonGalleryUI
extends RibbonGalleryUI {
    protected JRibbonGallery ribbonGallery;
    private int firstVisibleButtonIndex;
    private int visibleButtonsInEachRow;
    private int visibleButtonRowNumber;
    private Command scrollDownCommand;
    private Command scrollUpCommand;
    private Command expandCommand;
    private CommandGroup galleryScrollerCommands;
    private JComponent buttonStrip;
    private RibbonGalleryContentModel.GalleryCommandAction galleryCommandSelectionListener;
    private ChangeListener galleryModelChangeListener;
    protected Insets margin;

    @Override
    public void installUI(JComponent c) {
        this.ribbonGallery = (JRibbonGallery)c;
        this.firstVisibleButtonIndex = 0;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    protected void installComponents() {
        this.scrollUpCommand = ((Command.Builder)Command.builder().setAction(commandActionEvent -> {
            this.scrollOneRowUp();
            this.ribbonGallery.revalidate();
        })).build();
        this.scrollDownCommand = ((Command.Builder)Command.builder().setAction(commandActionEvent -> {
            this.scrollOneRowDown();
            this.ribbonGallery.revalidate();
        })).build();
        this.expandCommand = ((Command.Builder)Command.builder().setAction(commandActionEvent -> {
            PopupPanelManager.defaultManager().hidePopups(this.ribbonGallery);
            SwingUtilities.invokeLater(() -> {
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                JCommandPopupMenu popupMenu = (JCommandPopupMenu)JRibbonGallery.getExpandPopupMenu(this.ribbonGallery.getProjection(), this.ribbonGallery.getComponentOrientation()).buildComponent();
                Point loc = this.ribbonGallery.getLocationOnScreen();
                popupMenu.setCustomizer(() -> {
                    Rectangle scrBounds = this.ribbonGallery.getGraphicsConfiguration().getBounds();
                    boolean ltr = popupMenu.getComponentOrientation().isLeftToRight();
                    Dimension pref = popupMenu.getPreferredSize();
                    int width = Math.max(pref.width, this.ribbonGallery.getWidth());
                    int height = pref.height;
                    int x = ltr ? loc.x : loc.x + width - pref.width;
                    int y = loc.y;
                    if (x + width > scrBounds.x + scrBounds.width) {
                        x = scrBounds.x + scrBounds.width - width;
                    }
                    if (y + height > scrBounds.y + scrBounds.height) {
                        y = scrBounds.y + scrBounds.height - height;
                    }
                    return new Rectangle(x, y, width, height);
                });
                Dimension pref = popupMenu.getPreferredSize();
                int width = Math.max(pref.width, this.ribbonGallery.getWidth());
                boolean ltr = this.ribbonGallery.getComponentOrientation().isLeftToRight();
                int x = ltr ? loc.x : loc.x + this.ribbonGallery.getWidth() - width;
                Popup popup = popupFactory.getPopup(this.ribbonGallery, popupMenu, x, loc.y);
                PopupPanelManager.defaultManager().addPopup(this.ribbonGallery, popup, popupMenu);
            });
        })).build();
        HashMap<Command, CommandButtonPresentationModel.Overlay> galleryScrollerOverlays = new HashMap<Command, CommandButtonPresentationModel.Overlay>();
        galleryScrollerOverlays.put(this.scrollUpCommand, CommandButtonPresentationModel.overlay().setAutoRepeatAction(true).setAutoRepeatActionIntervals(200, 50));
        galleryScrollerOverlays.put(this.scrollDownCommand, CommandButtonPresentationModel.overlay().setAutoRepeatAction(true).setAutoRepeatActionIntervals(200, 50));
        galleryScrollerOverlays.put(this.expandCommand, CommandButtonPresentationModel.overlay().setActionKeyTip(((RibbonGalleryPresentationModel)this.ribbonGallery.getProjection().getPresentationModel()).getExpandKeyTip()).setFireActionOnPress(true));
        HashMap<Command, Projection.ComponentCustomizer<JCommandButton>> galleryScrollerCustomizers = new HashMap<Command, Projection.ComponentCustomizer<JCommandButton>>();
        galleryScrollerCustomizers.put(this.scrollUpCommand, this::configureScrollUpButton);
        galleryScrollerCustomizers.put(this.scrollDownCommand, this::configureScrollDownButton);
        galleryScrollerCustomizers.put(this.expandCommand, this::configureExpandButton);
        HashMap<Command, Projection.ComponentSupplier<JCommandButton, Command, CommandButtonPresentationModel>> galleryScrollerSuppliers = new HashMap<Command, Projection.ComponentSupplier<JCommandButton, Command, CommandButtonPresentationModel>>();
        galleryScrollerSuppliers.put(this.expandCommand, projection -> ExpandCommandButton::new);
        this.galleryScrollerCommands = new CommandGroup(this.scrollUpCommand, this.scrollDownCommand, this.expandCommand);
        CommandStripProjection projection2 = new CommandStripProjection(this.galleryScrollerCommands, CommandStripPresentationModel.builder().setOrientation(CommandStripPresentationModel.StripOrientation.VERTICAL).setCommandPresentationState(CommandButtonPresentationState.FIT_TO_ICON).setFlat(false).setToDismissPopupsOnActivation(false).build());
        projection2.setCommandComponentSuppliers(galleryScrollerSuppliers);
        projection2.setCommandComponentCustomizers(galleryScrollerCustomizers);
        projection2.setCommandOverlays(galleryScrollerOverlays);
        this.buttonStrip = projection2.buildComponent();
        this.ribbonGallery.add(this.buttonStrip);
    }

    protected void uninstallComponents() {
        this.galleryScrollerCommands.removeAllCommands();
        this.buttonStrip.removeAll();
        this.ribbonGallery.remove(this.buttonStrip);
    }

    protected void installDefaults() {
        this.margin = new Insets(3, 3, 3, 3);
        Border b = this.ribbonGallery.getBorder();
        if (b == null || b instanceof UIResource) {
            this.ribbonGallery.setBorder(new BorderUIResource.EmptyBorderUIResource(2, 2, 2, 2));
        }
        this.ribbonGallery.setOpaque(false);
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.galleryCommandSelectionListener = activated -> SwingUtilities.invokeLater(() -> {
            if (this.ribbonGallery != null) {
                this.scrollToSelected();
                this.ribbonGallery.revalidate();
            }
        });
        ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).addCommandActivationListener(this.galleryCommandSelectionListener);
        this.galleryModelChangeListener = changeEvent -> this.ribbonGallery.revalidate();
        ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).addChangeListener(this.galleryModelChangeListener);
    }

    protected void uninstallListeners() {
        ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).removeCommandActivationListener(this.galleryCommandSelectionListener);
        ((RibbonGalleryContentModel)this.ribbonGallery.getProjection().getContentModel()).removeChangeListener(this.galleryModelChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.ribbonGallery = null;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonGalleryLayout();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintRibbonGalleryBorder(graphics);
        graphics.dispose();
    }

    protected abstract void paintRibbonGalleryBorder(Graphics var1);

    protected int getLayoutGap() {
        return 4;
    }

    public int getPreferredWidth(int buttonCount, int availableHeight) {
        Insets borderInsets = this.ribbonGallery.getInsets();
        int galleryHeight = availableHeight - this.margin.top - this.margin.bottom;
        int buttonHeight = galleryHeight - borderInsets.top - borderInsets.bottom;
        int result = this.margin.left;
        CommandButtonPresentationState galleryButtonPresentationState = ((RibbonGalleryPresentationModel)this.ribbonGallery.getProjection().getPresentationModel()).getCommandPresentationState();
        if (galleryButtonPresentationState == CommandButtonPresentationState.SMALL) {
            result += buttonCount * buttonHeight / 3;
        }
        if (galleryButtonPresentationState == JRibbonBand.BIG_FIXED) {
            result += buttonCount * buttonHeight;
        }
        if (galleryButtonPresentationState == JRibbonBand.BIG_FIXED_LANDSCAPE) {
            result += buttonCount * buttonHeight * 5 / 4;
        }
        result += (buttonCount + 1) * this.getLayoutGap();
        result += this.getScrollerButtonWidth();
        return result += this.margin.right;
    }

    private int getScrollerButtonWidth() {
        return FlamingoUtilities.getScaledSize(15, SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont().getSize(), 1.0, 1);
    }

    private void scrollOneRowDown() {
        this.firstVisibleButtonIndex += this.visibleButtonsInEachRow;
    }

    private void scrollOneRowUp() {
        this.firstVisibleButtonIndex -= this.visibleButtonsInEachRow;
    }

    private void scrollToSelected() {
        JCommandButton selected = this.ribbonGallery.getSelectedButton();
        if (selected == null) {
            return;
        }
        int selIndex = -1;
        for (int i = 0; i < this.ribbonGallery.getCommandCount(); ++i) {
            if (this.ribbonGallery.getButtonAt(i) != selected) continue;
            selIndex = i;
            break;
        }
        if (selIndex < 0) {
            return;
        }
        if (selIndex >= this.firstVisibleButtonIndex && selIndex < this.firstVisibleButtonIndex + this.visibleButtonRowNumber * this.visibleButtonsInEachRow) {
            return;
        }
        if (this.visibleButtonsInEachRow <= 0) {
            return;
        }
        do {
            if (selIndex < this.firstVisibleButtonIndex) {
                this.scrollOneRowUp();
                continue;
            }
            this.scrollOneRowDown();
        } while (selIndex < this.firstVisibleButtonIndex || selIndex >= this.firstVisibleButtonIndex + this.visibleButtonRowNumber * this.visibleButtonsInEachRow);
    }

    protected abstract void configureScrollUpButton(JCommandButton var1);

    protected abstract void configureScrollDownButton(JCommandButton var1);

    protected abstract void configureExpandButton(JCommandButton var1);

    @KeyTipManager.HasNextKeyTipChain
    private static class ExpandCommandButton
    extends JCommandButton {
        public ExpandCommandButton(Projection<JCommandButton, Command, CommandButtonPresentationModel> projection) {
            super(projection);
        }
    }

    private class RibbonGalleryLayout
    implements LayoutManager {
        private RibbonGalleryLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(BasicRibbonGalleryUI.this.ribbonGallery.getPreferredWidth(BasicRibbonGalleryUI.this.ribbonGallery.getPresentationPriority(), c.getHeight()), c.getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            int i;
            int neededSpace;
            int availableButtonsSpace;
            int width = c.getWidth();
            int height = c.getHeight();
            Insets borderInsets = BasicRibbonGalleryUI.this.ribbonGallery.getInsets();
            int galleryHeight = height - BasicRibbonGalleryUI.this.margin.top - BasicRibbonGalleryUI.this.margin.bottom;
            int buttonHeight = galleryHeight - borderInsets.top - borderInsets.bottom;
            BasicRibbonGalleryUI.this.visibleButtonRowNumber = 1;
            CommandButtonPresentationState galleryButtonPresentationState = ((RibbonGalleryPresentationModel)BasicRibbonGalleryUI.this.ribbonGallery.getProjection().getPresentationModel()).getCommandPresentationState();
            if (galleryButtonPresentationState == CommandButtonPresentationState.SMALL) {
                buttonHeight /= 3;
                BasicRibbonGalleryUI.this.visibleButtonRowNumber = 3;
            }
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            int scrollerButtonHeight = galleryHeight / 3;
            int scrollerButtonWidth = BasicRibbonGalleryUI.this.getScrollerButtonWidth();
            int buttonX = ltr ? width - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.right : BasicRibbonGalleryUI.this.margin.left;
            BasicRibbonGalleryUI.this.buttonStrip.getComponent(0).setPreferredSize(new Dimension(scrollerButtonWidth, scrollerButtonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.getComponent(1).setPreferredSize(new Dimension(scrollerButtonWidth, scrollerButtonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.getComponent(2).setPreferredSize(new Dimension(scrollerButtonWidth, galleryHeight - 2 * scrollerButtonHeight));
            BasicRibbonGalleryUI.this.buttonStrip.setBounds(buttonX, BasicRibbonGalleryUI.this.margin.top, scrollerButtonWidth, galleryHeight);
            BasicRibbonGalleryUI.this.buttonStrip.doLayout();
            int maxButtonWidth = buttonHeight;
            if (galleryButtonPresentationState == JRibbonBand.BIG_FIXED_LANDSCAPE) {
                maxButtonWidth = maxButtonWidth * 5 / 4;
            }
            int gap = BasicRibbonGalleryUI.this.getLayoutGap();
            BasicRibbonGalleryUI.this.visibleButtonsInEachRow = 0;
            int n = availableButtonsSpace = ltr ? buttonX - BasicRibbonGalleryUI.this.margin.left : width - buttonX - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.right;
            while (true) {
                if ((neededSpace = BasicRibbonGalleryUI.this.visibleButtonsInEachRow * maxButtonWidth + (BasicRibbonGalleryUI.this.visibleButtonsInEachRow + 1) * gap) > availableButtonsSpace) break;
                BasicRibbonGalleryUI.this.visibleButtonsInEachRow++;
            }
            BasicRibbonGalleryUI.this.visibleButtonsInEachRow--;
            neededSpace = BasicRibbonGalleryUI.this.visibleButtonsInEachRow * maxButtonWidth + (BasicRibbonGalleryUI.this.visibleButtonsInEachRow + 1) * gap;
            int startX = ltr ? BasicRibbonGalleryUI.this.margin.left + gap : width - BasicRibbonGalleryUI.this.margin.right - gap;
            int availableWidth = ltr ? buttonX - BasicRibbonGalleryUI.this.margin.right : width - buttonX - scrollerButtonWidth - BasicRibbonGalleryUI.this.margin.left;
            int toAddToButtonWidth = (availableWidth - neededSpace) / BasicRibbonGalleryUI.this.visibleButtonsInEachRow;
            int lastVisibleButtonIndex = BasicRibbonGalleryUI.this.firstVisibleButtonIndex + BasicRibbonGalleryUI.this.visibleButtonRowNumber * BasicRibbonGalleryUI.this.visibleButtonsInEachRow - 1;
            lastVisibleButtonIndex = Math.min(lastVisibleButtonIndex, BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() - 1);
            int currCountInRow = 0;
            int buttonY = BasicRibbonGalleryUI.this.margin.top + borderInsets.top;
            int singleButtonWidth = maxButtonWidth + toAddToButtonWidth;
            for (i = 0; i < BasicRibbonGalleryUI.this.firstVisibleButtonIndex; ++i) {
                BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i).setVisible(false);
            }
            if (lastVisibleButtonIndex >= 0) {
                for (i = lastVisibleButtonIndex + 1; i < BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount(); ++i) {
                    BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i).setVisible(false);
                }
            }
            for (i = BasicRibbonGalleryUI.this.firstVisibleButtonIndex; i <= lastVisibleButtonIndex; ++i) {
                JCommandButton currButton = BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(i);
                currButton.setVisible(true);
                if (ltr) {
                    currButton.setBounds(startX, buttonY, singleButtonWidth, buttonHeight);
                    startX += singleButtonWidth + gap;
                } else {
                    currButton.setBounds(startX - singleButtonWidth, buttonY, singleButtonWidth, buttonHeight);
                    startX -= singleButtonWidth + gap;
                }
                if (++currCountInRow != BasicRibbonGalleryUI.this.visibleButtonsInEachRow) continue;
                currCountInRow = 0;
                startX = ltr ? BasicRibbonGalleryUI.this.margin.left + gap : width - BasicRibbonGalleryUI.this.margin.right - gap;
                buttonY += buttonHeight;
            }
            if (BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() == 0) {
                BasicRibbonGalleryUI.this.scrollDownCommand.setActionEnabled(false);
                BasicRibbonGalleryUI.this.scrollUpCommand.setActionEnabled(false);
                BasicRibbonGalleryUI.this.expandCommand.setActionEnabled(false);
            } else {
                BasicRibbonGalleryUI.this.scrollDownCommand.setActionEnabled(!BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(BasicRibbonGalleryUI.this.ribbonGallery.getCommandCount() - 1).isVisible());
                BasicRibbonGalleryUI.this.scrollUpCommand.setActionEnabled(!BasicRibbonGalleryUI.this.ribbonGallery.getButtonAt(0).isVisible());
                BasicRibbonGalleryUI.this.expandCommand.setActionEnabled(true);
            }
        }
    }
}

