/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceColorSelectorComponentUI;

public class JColorSelectorComponent
extends JComponent {
    private Color color;
    private List<ColorSelectorPopupMenuContentModel.ColorPreviewListener> colorPreviewListeners;
    private List<ColorSelectorPopupMenuContentModel.ColorActivationListener> colorActivationListeners;
    private boolean isTopOpen;
    private boolean isBottomOpen;
    public static final String uiClassID = "ColorSelectorComponentUI";

    public JColorSelectorComponent(Color color, ColorSelectorPopupMenuContentModel.ColorPreviewListener colorPreviewListener, ColorSelectorPopupMenuContentModel.ColorActivationListener colorActivationListener) {
        this.setOpaque(true);
        this.color = color;
        this.colorPreviewListeners = new ArrayList<ColorSelectorPopupMenuContentModel.ColorPreviewListener>();
        this.colorPreviewListeners.add(colorPreviewListener);
        this.colorActivationListeners = new ArrayList<ColorSelectorPopupMenuContentModel.ColorActivationListener>();
        this.colorActivationListeners.add(colorActivationListener);
        this.setFocusable(true);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceColorSelectorComponentUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public Color getColor() {
        return this.color;
    }

    public synchronized void addColorActivationListener(ColorSelectorPopupMenuContentModel.ColorActivationListener listener) {
        this.colorActivationListeners.add(listener);
    }

    public synchronized void addColorPreviewListener(ColorSelectorPopupMenuContentModel.ColorPreviewListener listener) {
        this.colorPreviewListeners.add(listener);
    }

    public synchronized void onColorActivated(Color color) {
        for (ColorSelectorPopupMenuContentModel.ColorActivationListener listener : this.colorActivationListeners) {
            listener.onColorActivated(color);
        }
    }

    public synchronized void onColorPreviewActivated(Color color) {
        for (ColorSelectorPopupMenuContentModel.ColorPreviewListener listener : this.colorPreviewListeners) {
            listener.onColorPreviewActivated(color);
        }
    }

    public synchronized void onColorPreviewCanceled() {
        for (ColorSelectorPopupMenuContentModel.ColorPreviewListener listener : this.colorPreviewListeners) {
            listener.onColorPreviewCanceled();
        }
    }

    public void setTopOpen(boolean isTopOpen) {
        this.isTopOpen = isTopOpen;
    }

    public void setBottomOpen(boolean isBottomOpen) {
        this.isBottomOpen = isBottomOpen;
    }

    public boolean isTopOpen() {
        return this.isTopOpen;
    }

    public boolean isBottomOpen() {
        return this.isBottomOpen;
    }
}

