/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.internal.substance.common.TransitionAwareResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.flamingo.internal.ui.common.FlamingoInternalButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceInternalButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;

public class SubstanceRibbonBandUI
extends BasicRibbonBandUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceRibbonBandUI();
    }

    private SubstanceRibbonBandUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.ribbonBand, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.CONTROL_PANE);
        Insets insets = SubstanceSizeUtils.getDefaultBorderInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbonBand));
        this.ribbonBand.setBorder(new EmptyBorder(0, insets.left, 0, insets.right));
    }

    @Override
    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.ribbonBand);
        super.uninstallDefaults();
    }

    @Override
    protected void paintBandTrailingSeparator(Graphics graphics, Rectangle toFill) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        if (this.ribbonBand.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            g2d.translate(toFill.width - 2, 0);
        }
        SeparatorPainterUtils.paintSeparator((Component)this.ribbonBand, (Graphics)g2d, (int)0, (int)toFill.height, (int)1, (boolean)true, (int)5);
        g2d.dispose();
    }

    @Override
    protected void paintBandTitle(Graphics graphics, Rectangle titleRectangle, String title) {
        if (titleRectangle.width <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics.create();
        FontUIResource controlFont = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
        g2d.setFont(controlFont.deriveFont(controlFont.getSize2D() - 1.0f));
        FontMetrics fm = graphics.getFontMetrics();
        int currLength = (int)fm.getStringBounds(title, g2d).getWidth();
        Object titleToPaint = title;
        while (currLength > titleRectangle.width) {
            title = title.substring(0, title.length() - 1);
            titleToPaint = title + "...";
            currLength = (int)fm.getStringBounds((String)titleToPaint, g2d).getWidth();
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)this.ribbonBand);
        Color bgFillColor = SubstanceCoreUtilities.getBackgroundFill((SubstanceSkin)skin, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.CONTROL_PANE);
        SubstanceColorScheme bgColorScheme = skin.getBackgroundColorScheme(SubstanceSlices.DecorationAreaType.CONTROL_PANE);
        Color fgColor = bgColorScheme.getForegroundColor();
        fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)0.95f);
        g2d.setColor(fgColor);
        int deltaX = (titleRectangle.width - currLength) / 2;
        int deltaY = (titleRectangle.height - fm.getAscent() - fm.getDescent()) / 2;
        Rectangle smallTitleRectangle = new Rectangle(titleRectangle.x + deltaX, titleRectangle.y + deltaY, titleRectangle.width - 2 * deltaX, titleRectangle.height - 2 * deltaY);
        SubstanceTextUtilities.paintText((Graphics)g2d, (Rectangle)smallTitleRectangle, (String)titleToPaint, (int)-1, (Font)g2d.getFont(), (Color)g2d.getColor(), (Rectangle)g2d.getClipBounds());
        g2d.dispose();
    }

    @Override
    public int getBandTitleHeight() {
        return 1 + SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbonBand), (int)17, (int)1, (int)1, (boolean)false);
    }

    @Override
    protected JCommandButton createExpandButton() {
        CommandButtonProjection<Command> expandCommandProjection = new CommandButtonProjection<Command>(this.expandCommand, CommandButtonPresentationModel.builder().setActionKeyTip(this.ribbonBand.getExpandButtonKeyTip()).build());
        expandCommandProjection.setComponentSupplier(projection -> x$0 -> new RibbonBandExpandButton((Projection)x$0));
        expandCommandProjection.setComponentCustomizer(button -> {
            SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)button, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.CONTROL_PANE);
            SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)this.ribbonBand);
            button.setIcon(this.getExpandButtonIcon(skin, (JCommandButton)button));
            SubstanceCortex.ComponentScope.setButtonStraightSides((JComponent)button, EnumSet.allOf(SubstanceSlices.Side.class));
        });
        return (JCommandButton)expandCommandProjection.buildComponent();
    }

    @Override
    protected Command createExpandCommand() {
        return ((Command.Builder)((Command.Builder)Command.builder().setAction(this.ribbonBand.getExpandCommandListener())).setActionRichTooltip(this.ribbonBand.getExpandButtonRichTooltip())).build();
    }

    private ResizableIcon getExpandButtonIcon(SubstanceSkin skin, JCommandButton button) {
        double scale = NeonCortex.getScaleFactor((Component)button);
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (scheme, width, height) -> {
            Color bgFillColor = SubstanceCoreUtilities.getBackgroundFill((SubstanceSkin)skin, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.CONTROL_PANE);
            return SubstanceImageCreator.getDoubleArrowIcon((double)scale, (float)width, (float)height, (float)SubstanceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.ribbonBand.getComponentOrientation().isLeftToRight() ? 3 : 7), (SubstanceColorScheme)SubstanceColorSchemeUtilities.getShiftedScheme((SubstanceColorScheme)scheme, (Color)bgFillColor, (double)0.0, (Color)bgFillColor, (double)0.3f));
        }, new Dimension(arrowIconHeight, arrowIconWidth));
        return arrowIcon;
    }

    @Override
    protected void syncExpandButtonIcon() {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)this.ribbonBand);
        this.expandCommand.setIconFactory(() -> this.getExpandButtonIcon(skin, this.expandButton));
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.ribbonBand.getFont());
        GhostPaintingUtils.paintGhostImages((Component)c, (Graphics)g2d);
        BackgroundPaintingUtils.update((Graphics)g2d, (JComponent)c, (boolean)false);
        this.paint(g2d, c);
        g2d.dispose();
    }

    @SubstanceInternalButton
    private static class RibbonBandExpandButton
    extends JCommandButton
    implements FlamingoInternalButton {
        private RibbonBandExpandButton(Projection<JCommandButton, Command, CommandButtonPresentationModel> projection) {
            super(projection);
            this.setBorder(new EmptyBorder(3, 2, 3, 2));
        }
    }
}

