/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.ribbon.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.BasicRibbonApplicationMenuPopupPanelUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;

public class SubstanceRibbonApplicationMenuPopupPanelUI
extends BasicRibbonApplicationMenuPopupPanelUI {
    public static ComponentUI createUI(JComponent c) {
        return new SubstanceRibbonApplicationMenuPopupPanelUI();
    }

    private SubstanceRibbonApplicationMenuPopupPanelUI() {
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        BorderUIResource.CompoundBorderUIResource newBorder = new BorderUIResource.CompoundBorderUIResource((Border)new SubstanceBorder(0.0f, new Insets(2, 2, 2, 2)), new Border(){

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(18, 0, 0, 0);
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)c);
                SubstanceColorScheme scheme = skin.getBackgroundColorScheme(DecorationPainterUtils.getDecorationType((Component)c));
                Color backgroundFill = scheme.getAccentedBackgroundFillColor();
                Graphics2D g2d = (Graphics2D)g.create(x, y, width, height);
                g2d.setColor(backgroundFill);
                g2d.fillRect(0, 0, width, height);
                g2d.dispose();
            }
        });
        this.applicationMenuPopupPanel.setBorder(newBorder);
        this.panelScrollerLevel2.setBorder(new BorderUIResource(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                boolean ltr = c.getComponentOrientation().isLeftToRight();
                return new Insets(0, ltr ? 1 : 0, 0, ltr ? 0 : 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth((Component)c) / 2.0f;
                float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth((Component)c);
                Graphics2D g2d = (Graphics2D)g.create();
                SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)SubstanceRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED);
                g2d.setColor(scheme.getMidColor());
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g2d.setStroke(new BasicStroke(borderThickness, 0, 1));
                boolean ltr = SubstanceRibbonApplicationMenuPopupPanelUI.this.applicationMenuPopupPanel.getComponentOrientation().isLeftToRight();
                float lineX = ltr ? borderDelta : (float)c.getWidth() - borderDelta - borderThickness;
                g2d.draw(new Line2D.Float(lineX, borderDelta, lineX, (float)height - borderThickness - 2.0f * borderDelta));
                g2d.dispose();
            }
        }));
        this.panelLevel2.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.setBorder((Border)new SubstanceBorder());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        BackgroundPaintingUtils.update((Graphics)g, (JComponent)c, (boolean)false);
        super.paint(g, c);
    }
}

