/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.internal.substance.common.TransitionAwareResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.flamingo.internal.ui.common.BasicScrollablePanelUI;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceScrollablePanelUI
extends BasicScrollablePanelUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceScrollablePanelUI();
    }

    private SubstanceScrollablePanelUI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Graphics g, JComponent c) {
        if (!c.isShowing()) {
            return;
        }
        JComponent jComponent = c;
        synchronized (jComponent) {
            if (c.isOpaque()) {
                BackgroundPaintingUtils.update((Graphics)g, (JComponent)c, (boolean)false);
                super.paint(g, c);
            } else {
                super.paint(g, c);
            }
        }
    }

    @Override
    protected void configureLeadingScrollerButton(JCommandButton button) {
        double scale = NeonCortex.getScaleFactor((Component)button);
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (scheme, width, height) -> {
            ScaleAwareImageWrapperIcon doubleArrowIcon = SubstanceImageCreator.getDoubleArrowIcon((double)scale, (float)width, (float)height, (float)SubstanceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 7 : 1), (SubstanceColorScheme)scheme);
            return doubleArrowIcon;
        }, new Dimension(arrowIconHeight, arrowIconWidth));
        button.setIcon(arrowIcon);
        SubstanceCortex.ComponentScope.setButtonStraightSides((JComponent)button, this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(SubstanceSlices.Side.RIGHT) : EnumSet.of(SubstanceSlices.Side.BOTTOM));
        button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        button.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    protected void configureTrailingScrollerButton(JCommandButton button) {
        double scale = NeonCortex.getScaleFactor((Component)button);
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (scheme, width, height) -> {
            ScaleAwareImageWrapperIcon doubleArrowIcon = SubstanceImageCreator.getDoubleArrowIcon((double)scale, (float)width, (float)height, (float)SubstanceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 3 : 5), (SubstanceColorScheme)scheme);
            return doubleArrowIcon;
        }, new Dimension(arrowIconHeight, arrowIconWidth));
        button.setIcon(arrowIcon);
        SubstanceCortex.ComponentScope.setButtonStraightSides((JComponent)button, this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? EnumSet.of(SubstanceSlices.Side.LEFT) : EnumSet.of(SubstanceSlices.Side.TOP));
        button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        button.setCursor(Cursor.getPredefinedCursor(12));
    }
}

