/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.internal.substance.common.GlowingResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.TransitionAwareResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.flamingo.internal.substance.utils.CommandButtonBackgroundDelegate;
import org.pushingpixels.flamingo.internal.substance.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.flamingo.internal.substance.utils.SubstanceDisabledResizableIcon;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.KeyTipRenderingUtilities;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.neon.api.icon.ResizableIconUIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostingListener;

public class SubstanceCommandButtonUI
extends BasicCommandButtonUI
implements ActionPopupTransitionAwareUI {
    private PropertyChangeListener substancePropertyListener;
    private GhostingListener substanceModelChangeListener;
    private CommandButtonVisualStateTracker substanceVisualStateTracker;
    private ButtonModel overallRolloverModel = new DefaultButtonModel();
    private RolloverControlListener substanceOverallRolloverListener;
    private MouseListener rolloverMenuMouseListener;
    private StateTransitionTracker overallStateTransitionTracker;
    private GlowingResizableIcon glowingIcon;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceCommandButtonUI((JCommandButton)comp);
    }

    SubstanceCommandButtonUI(JCommandButton button) {
        this.overallRolloverModel.setArmed(false);
        this.overallRolloverModel.setSelected(false);
        this.overallRolloverModel.setPressed(false);
        this.overallRolloverModel.setRollover(false);
        this.overallRolloverModel.setEnabled(button.isEnabled());
        this.overallStateTransitionTracker = new StateTransitionTracker((JComponent)button, this.overallRolloverModel);
        this.substanceVisualStateTracker = new CommandButtonVisualStateTracker();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SubstanceCortex.ComponentScope.setButtonShaper((JComponent)this.commandButton, (SubstanceButtonShaper)ClassicButtonShaper.INSTANCE);
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void updateBorder() {
        Border currBorder = this.commandButton.getBorder();
        if (currBorder == null || currBorder instanceof UIResource) {
            Insets extra = SubstanceSizeUtils.getDefaultBorderInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton));
            double hgapScaleFactor = this.commandButton.getHGapScaleFactor();
            double vgapScaleFactor = this.commandButton.getVGapScaleFactor();
            int top = 1 + (int)(vgapScaleFactor * (double)extra.top);
            int left = 2 + (int)(hgapScaleFactor * (double)(1 + extra.left));
            int bottom = 0 + (int)(vgapScaleFactor * (double)extra.bottom);
            int right = 2 + (int)(hgapScaleFactor * (double)(1 + extra.right));
            this.commandButton.setBorder(new BorderUIResource.EmptyBorderUIResource(top, left, bottom, right));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceVisualStateTracker.installListeners(this.commandButton);
        this.substancePropertyListener = propertyChangeEvent -> {
            if ("actionModel".equals(propertyChangeEvent.getPropertyName())) {
                if (this.substanceModelChangeListener != null) {
                    this.substanceModelChangeListener.unregisterListeners();
                }
                this.substanceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
                this.substanceModelChangeListener.registerListeners();
            }
            if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                this.trackGlowingIcon();
            }
        };
        this.commandButton.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
        this.substanceModelChangeListener.registerListeners();
        this.substanceOverallRolloverListener = new RolloverControlListener((TransitionAwareUI)this, this.overallRolloverModel);
        this.commandButton.addMouseListener((MouseListener)this.substanceOverallRolloverListener);
        this.commandButton.addMouseMotionListener((MouseMotionListener)this.substanceOverallRolloverListener);
        this.overallStateTransitionTracker.registerModelListeners();
        this.rolloverMenuMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SubstanceCommandButtonUI.this.commandButton.isEnabled() && ((CommandButtonPresentationModel)SubstanceCommandButtonUI.this.commandButton.getProjection().getPresentationModel()).isMenu()) {
                    int modifiers = 0;
                    AWTEvent currentEvent = EventQueue.getCurrentEvent();
                    if (currentEvent instanceof InputEvent) {
                        modifiers = ((InputEvent)currentEvent).getModifiersEx();
                    } else if (currentEvent instanceof ActionEvent) {
                        modifiers = ((ActionEvent)currentEvent).getModifiers();
                    }
                    SubstanceCommandButtonUI.this.fireRolloverActionPerformed(new ActionEvent(this, 1001, SubstanceCommandButtonUI.this.commandButton.getActionModel().getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
                    List<PopupPanelManager.PopupInfo> popupInfoList = PopupPanelManager.defaultManager().getShownPath();
                    int popupInfoListSize = popupInfoList.size();
                    if (popupInfoListSize >= 1 && popupInfoList.get(popupInfoListSize - 1).getPopupPanel() instanceof JRibbonFrame.GlobalPopupMenu && popupInfoList.get(popupInfoListSize - 1).getPopupOriginator() == SubstanceCommandButtonUI.this.commandButton) {
                        return;
                    }
                    SubstanceCommandButtonUI.this.processPopupAction();
                }
            }
        };
        this.commandButton.addMouseListener(this.rolloverMenuMouseListener);
        this.trackGlowingIcon();
    }

    @Override
    protected void uninstallListeners() {
        this.substanceVisualStateTracker.uninstallListeners(this.commandButton);
        this.substanceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceModelChangeListener.unregisterListeners();
        this.substanceModelChangeListener = null;
        this.commandButton.removeMouseListener((MouseListener)this.substanceOverallRolloverListener);
        this.commandButton.removeMouseMotionListener((MouseMotionListener)this.substanceOverallRolloverListener);
        this.substanceOverallRolloverListener = null;
        this.overallStateTransitionTracker.unregisterModelListeners();
        this.commandButton.removeMouseListener(this.rolloverMenuMouseListener);
        this.rolloverMenuMouseListener = null;
        super.uninstallListeners();
    }

    public void fireRolloverActionPerformed(ActionEvent e) {
        RolloverActionListener[] listeners = (RolloverActionListener[])this.commandButton.getListeners(RolloverActionListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].actionPerformed(e);
        }
    }

    private void trackGlowingIcon() {
        ResizableIcon currIcon = this.commandButton.getIcon();
        if (currIcon instanceof GlowingResizableIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        boolean isPopupOnly = this.commandButton.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY;
        StateTransitionTracker tracker = isPopupOnly ? this.substanceVisualStateTracker.getPopupStateTransitionTracker() : this.substanceVisualStateTracker.getActionStateTransitionTracker();
        this.glowingIcon = new GlowingResizableIcon(currIcon, tracker.getIconGlowTracker());
    }

    private void paintButtonBackground(Graphics graphics) {
        if (SubstanceCoreUtilities.isButtonNeverPainted((JComponent)this.commandButton)) {
            return;
        }
        ActionButtonModel actionModel = this.commandButton.getActionModel();
        PopupButtonModel popupModel = this.commandButton.getPopupModel();
        Rectangle actionArea = this.getLayoutInfo().actionClickArea;
        Rectangle popupArea = this.getLayoutInfo().popupClickArea;
        BufferedImage fullAlphaBackground = CommandButtonBackgroundDelegate.getCombinedCommandButtonBackground(this.commandButton, actionModel, actionArea, popupModel, popupArea);
        boolean isFlat = this.commandButton.isFlat() && !this.commandButton.hasFocus() && !this.commandButton.getPopupModel().isPopupShowing();
        boolean isSpecial = isFlat || !this.commandButton.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                float extraActionAlpha = 0.0f;
                for (Map.Entry activeEntry : this.getActionTransitionTracker().getModelStateInfo().getStateContributionMap().entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraActionAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
                float extraPopupAlpha = 0.0f;
                for (Map.Entry activeEntry : this.getPopupTransitionTracker().getModelStateInfo().getStateContributionMap().entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraPopupAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
                extraAlpha = Math.max(extraActionAlpha, extraPopupAlpha);
            } else {
                ComponentState actionAreaState = ComponentState.getState((ButtonModel)actionModel, (JComponent)this.commandButton);
                if (actionAreaState.isDisabled()) {
                    extraAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)actionAreaState);
                }
            }
        }
        if ((extraAlpha = Math.min(1.0f, extraAlpha)) > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.commandButton, (float)extraAlpha, (Graphics)graphics));
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            NeonCortex.drawImageWithScale((Graphics)g2d, (double)NeonCortex.getScaleFactor((Component)this.commandButton), (Image)fullAlphaBackground, (int)0, (int)0);
            g2d.dispose();
        }
    }

    private void paintButtonIconRegular(Graphics g, Rectangle iconRect, Color textColor) {
        ResizableIcon regular = this.commandButton.getIcon();
        if (this.toUseDisabledIcon() && this.commandButton.getDisabledIcon() != null && regular != null && !regular.getClass().isAnnotationPresent(TransitionAware.class)) {
            regular = this.commandButton.getDisabledIcon();
        }
        if (iconRect == null || regular == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        GhostPaintingUtils.paintGhostIcon((Graphics2D)g2d, (Component)this.commandButton, (Icon)regular, (Rectangle)iconRect);
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.commandButton, (Graphics)g));
        StateTransitionTracker tracker = this.substanceVisualStateTracker.getActionStateTransitionTracker();
        ButtonModel model = this.commandButton.getActionModel();
        if (this.commandButton.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            tracker = this.substanceVisualStateTracker.getPopupStateTransitionTracker();
            model = this.commandButton.getPopupModel();
        }
        CommandButtonBackgroundDelegate.paintCommandButtonIcon(g2d, iconRect, this.commandButton, (Icon)regular, this.glowingIcon, model, tracker, textColor);
        g2d.dispose();
    }

    protected void paintButtonIcon(Graphics g, Rectangle iconRect, Color textColor) {
        boolean isSelectedMenu;
        boolean bl = isSelectedMenu = this.commandButton.getActionModel().isSelected() && ((CommandButtonPresentationModel)this.commandButton.getProjection().getPresentationModel()).isMenu();
        if (isSelectedMenu) {
            Graphics2D g2d = (Graphics2D)g.create();
            float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth((Component)this.commandButton);
            Rectangle2D.Float extended = new Rectangle2D.Float((float)iconRect.x - borderDelta / 2.0f, (float)iconRect.y - borderDelta / 2.0f, (float)iconRect.width + borderDelta, (float)iconRect.height + borderDelta);
            ComponentState currState = this.commandButton.getActionModel().isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)this.commandButton);
            fillPainter.paintContourBackground((Graphics)g2d, (Component)this.commandButton, extended.x + extended.width, extended.y + extended.height, (Shape)extended, false, fillScheme, false);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)currState);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)this.commandButton);
            borderPainter.paintBorder((Graphics)g2d, (Component)this.commandButton, extended.x + extended.width, extended.y + extended.height, (Shape)extended, null, borderScheme);
            g2d.dispose();
        }
        this.paintButtonIconRegular(g, iconRect, textColor);
        Icon iconToPaint = this.getIconToPaint();
        if (isSelectedMenu && iconToPaint == null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            ComponentState currState = this.commandButton.getActionModel().isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            g2d.setColor(fillScheme.getForegroundColor());
            int iw = iconRect.width;
            int ih = iconRect.height;
            GeneralPath path = new GeneralPath();
            path.moveTo(0.2f * (float)iw, 0.5f * (float)ih);
            path.lineTo(0.42f * (float)iw, 0.8f * (float)ih);
            path.lineTo(0.8f * (float)iw, 0.2f * (float)ih);
            g2d.translate(iconRect.x, iconRect.y);
            BasicStroke stroke = new BasicStroke(0.12f * (float)iw, 1, 1);
            g2d.setStroke(stroke);
            g2d.draw(path);
            g2d.dispose();
        }
    }

    private void paintButtonHorizontalSeparator(Graphics graphics, Rectangle separatorArea) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(0, separatorArea.y);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.getState((ButtonModel)this.commandButton.getActionModel(), (JComponent)this.commandButton));
        float fadeAlpha = this.getSeparatorAlpha();
        g2d.setComposite(AlphaComposite.SrcOver.derive(fadeAlpha));
        SeparatorPainterUtils.paintSeparator((Component)this.commandButton, (Graphics)g2d, (SubstanceColorScheme)colorScheme, (int)this.commandButton.getWidth(), (int)1, (int)0, (boolean)true, (int)4, (int)4, (boolean)true);
        g2d.dispose();
    }

    private void paintButtonVerticalSeparator(Graphics graphics, Rectangle separatorArea) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(separatorArea.x, 0);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.getState((ButtonModel)this.commandButton.getActionModel(), (JComponent)this.commandButton));
        float fadeAlpha = this.getSeparatorAlpha();
        g2d.setComposite(AlphaComposite.SrcOver.derive(fadeAlpha));
        SeparatorPainterUtils.paintSeparator((Component)this.commandButton, (Graphics)g2d, (SubstanceColorScheme)colorScheme, (int)1, (int)this.commandButton.getHeight(), (int)1, (boolean)true, (int)4, (int)4, (boolean)true);
        g2d.dispose();
    }

    @Override
    protected boolean isPaintingBackground() {
        if (((CommandButtonPresentationModel)this.commandButton.getProjection().getPresentationModel()).isMenu() && (this.commandButton.getActionModel().isRollover() || !this.commandButton.isFlat())) {
            return true;
        }
        if (super.isPaintingBackground()) {
            return true;
        }
        return this.commandButton.hasFocus() || this.overallStateTransitionTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected boolean isPaintingSeparators() {
        if (super.isPaintingSeparators()) {
            return true;
        }
        boolean hasIcon = this.commandButton.getIcon() != null;
        return this.commandButton.hasFocus() || hasIcon && this.overallStateTransitionTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected ResizableIcon createPopupActionIcon() {
        double scale = NeonCortex.getScaleFactor((Component)this.commandButton);
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton);
        int arrowIconHeight = (int)SubstanceSizeUtils.getArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getArrowIconWidth((int)fontSize);
        return new TransitionAwareResizableIcon(this.commandButton, this::getPopupTransitionTracker, (scheme, width, height) -> {
            CommandButtonPresentationModel.PopupOrientationKind orientation = this.commandButton.getPopupOrientationKind();
            int direction = orientation == CommandButtonPresentationModel.PopupOrientationKind.DOWNWARD ? 5 : (this.commandButton.getComponentOrientation().isLeftToRight() ? 3 : 7);
            return SubstanceImageCreator.getArrowIcon((float)width, (float)height, (double)scale, (float)(SubstanceSizeUtils.getArrowStrokeWidth((int)fontSize) - 0.5f), (int)direction, (SubstanceColorScheme)scheme);
        }, new Dimension(arrowIconWidth, arrowIconHeight));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean useActionAreaForFg;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(this.commandButton.getFont());
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton);
        this.commandButton.putClientProperty("icon.bounds", this.layoutInfo.iconRect);
        if (this.isPaintingBackground()) {
            this.paintButtonBackground(g2d);
        }
        StateTransitionTracker transitionTrackerForFg = (useActionAreaForFg = this.layoutInfo.isTextInActionArea) ? this.getActionTransitionTracker() : this.getPopupTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfoForFg = transitionTrackerForFg.getModelStateInfo();
        ComponentState currStateForFg = modelStateInfoForFg.getCurrModelState();
        Color fgColor = this.getForegroundColor(modelStateInfoForFg);
        if (this.layoutInfo.textLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo mainTextLayoutInfo : this.layoutInfo.textLayoutInfoList) {
                if (mainTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (Rectangle)mainTextLayoutInfo.textRect, (String)mainTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)fgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.extraTextLayoutInfoList != null) {
            SubstanceColorScheme disabledColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            Color disabledFgColor = disabledColorScheme.getForegroundColor();
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)bgFillColor, (double)buttonAlpha);
            }
            if (currStateForFg.isDisabled()) {
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)SubstanceColorUtilities.getBackgroundFillColor((Component)c), (double)0.5);
            }
            disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)fgColor, (double)0.5);
            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : this.layoutInfo.extraTextLayoutInfoList) {
                if (extraTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (Rectangle)extraTextLayoutInfo.textRect, (String)extraTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)disabledFgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.iconRect != null) {
            this.paintButtonIcon(g2d, this.layoutInfo.iconRect, this.getForegroundColor(this.getActionTransitionTracker().getModelStateInfo()));
        }
        if (this.layoutInfo.popupActionRect.getWidth() > 0.0) {
            this.paintPopupActionIcon(g2d, this.layoutInfo.popupActionRect);
        }
        if (this.isPaintingSeparators() && this.layoutInfo.separatorArea != null) {
            if (this.layoutInfo.separatorOrientation == CommandButtonLayoutManager.CommandButtonSeparatorOrientation.HORIZONTAL) {
                this.paintButtonHorizontalSeparator(g2d, this.layoutInfo.separatorArea);
            } else {
                this.paintButtonVerticalSeparator(g2d, this.layoutInfo.separatorArea);
            }
        }
        float focusRingPadding = SubstanceSizeUtils.getFocusRingPadding((Component)this.commandButton, (int)SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton));
        Rectangle innerFocusArea = this.isInnerFocusOnAction ? this.layoutInfo.actionClickArea : this.layoutInfo.popupClickArea;
        Rectangle2D.Float insetFocusArea = new Rectangle2D.Float((float)innerFocusArea.x + focusRingPadding, (float)innerFocusArea.y + focusRingPadding, (float)innerFocusArea.width - 2.0f * focusRingPadding, (float)innerFocusArea.height - 2.0f * focusRingPadding);
        SubstanceCoreUtilities.paintFocus((Graphics)g2d, (Component)this.commandButton, (Component)this.commandButton, (TransitionAwareUI)this, (Shape)insetFocusArea, (Rectangle)innerFocusArea, (float)1.0f, (float)0.0f);
        g2d.dispose();
    }

    protected Color getForegroundColor(StateTransitionTracker.ModelStateInfo modelStateInfo) {
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)modelStateInfo.getCurrModelState());
            if (((CommandButtonPresentationModel)this.commandButton.getProjection().getPresentationModel()).isMenu()) {
                fgColor = SubstanceCommandButtonUI.getMenuButtonForegroundColor(this.commandButton, modelStateInfo);
                if (buttonAlpha < 1.0f) {
                    Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                    fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)buttonAlpha);
                }
            } else {
                fgColor = SubstanceTextUtilities.getForegroundColor((JComponent)this.commandButton, (String)this.commandButton.getText(), (StateTransitionTracker.ModelStateInfo)modelStateInfo, (float)buttonAlpha);
            }
        }
        return fgColor;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.commandButton.getFont());
        this.paint(g2d, c);
        if (((CommandButtonPresentationModel)this.commandButton.getProjection().getPresentationModel()).isMenu()) {
            KeyTipRenderingUtilities.renderButtonKeyTips(g, this.commandButton, this.layoutManager);
        }
        g2d.dispose();
    }

    private void paintPopupActionIcon(Graphics g, Rectangle popupActionRect) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.popupActionIcon.paintIcon((Component)this.commandButton, (Graphics)g2d, popupActionRect.x + (popupActionRect.width - this.popupActionIcon.getIconWidth()) / 2, popupActionRect.y + (popupActionRect.height - this.popupActionIcon.getIconHeight()) / 2);
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JCommandButton button = (JCommandButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper((Component)button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        if (button.getPresentationState() == CommandButtonPresentationState.MEDIUM && SwingUtilities.getAncestorOfClass(JRibbon.class, button) == null && SwingUtilities.getAncestorOfClass(JBreadcrumbBar.class, button) == null && SwingUtilities.getAncestorOfClass(JCommandPopupMenu.class, button) == null) {
            JButton forSizing = new JButton(button.getText(), (Icon)button.getIcon());
            Dimension result = shaper.getPreferredSize((AbstractButton)forSizing, superPref);
            if (FlamingoUtilities.hasPopupAction(button)) {
                result.width = superPref.width;
            }
            return result;
        }
        return superPref;
    }

    private float getSeparatorAlpha() {
        ComponentState actionAreaState = this.getActionTransitionTracker().getModelStateInfo().getCurrModelState();
        if (!actionAreaState.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION) && !actionAreaState.isDisabled()) {
            float actionRolloverCycle = this.getActionTransitionTracker().getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER);
            float popupRolloverCycle = this.getPopupTransitionTracker().getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER);
            return Math.min(1.0f, actionRolloverCycle + popupRolloverCycle);
        }
        return 1.0f;
    }

    @Override
    protected void syncDisabledIcon() {
        ResizableIcon currDisabledIcon = this.commandButton.getDisabledIcon();
        ResizableIcon icon = this.commandButton.getIcon();
        if (currDisabledIcon == null || currDisabledIcon instanceof UIResource && !currDisabledIcon.getClass().isAnnotationPresent(TransitionAware.class)) {
            if (icon != null) {
                this.commandButton.setDisabledIcon((ResizableIcon)new ResizableIconUIResource((ResizableIcon)new SubstanceDisabledResizableIcon(icon)));
            } else {
                this.commandButton.setDisabledIcon(null);
            }
        } else if (icon != null) {
            this.commandButton.getDisabledIcon().setDimension(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.overallStateTransitionTracker;
    }

    public boolean isInside(MouseEvent me) {
        boolean inAction = this.layoutInfo.actionClickArea != null && this.layoutInfo.actionClickArea.contains(me.getPoint());
        boolean inPopup = this.layoutInfo.popupClickArea != null && this.layoutInfo.popupClickArea.contains(me.getPoint());
        return inAction || inPopup;
    }

    @Override
    public StateTransitionTracker getActionTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    @Override
    public StateTransitionTracker getPopupTransitionTracker() {
        return this.substanceVisualStateTracker.getPopupStateTransitionTracker();
    }

    private static Color getMenuButtonForegroundColor(JCommandButton menuButton, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        Map activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        SubstanceSlices.ColorSchemeAssociationKind currAssocKind = SubstanceSlices.ColorSchemeAssociationKind.FILL;
        if (!currState.isDisabled() && currState != ComponentState.ENABLED && !currState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER)) {
            currAssocKind = SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT;
        }
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)menuButton, (SubstanceSlices.ColorSchemeAssociationKind)currAssocKind, (ComponentState)currState);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return colorScheme.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            float alpha = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
            SubstanceSlices.ColorSchemeAssociationKind assocKind = SubstanceSlices.ColorSchemeAssociationKind.FILL;
            if (!activeState.isDisabled() && activeState != ComponentState.ENABLED && !activeState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER)) {
                assocKind = SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT;
            }
            SubstanceColorScheme activeColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)menuButton, (SubstanceSlices.ColorSchemeAssociationKind)assocKind, (ComponentState)activeState);
            Color activeForeground = activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }
}

