/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonPanelUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceCommandButtonPanelUI
extends BasicCommandButtonPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceCommandButtonPanelUI();
    }

    private SubstanceCommandButtonPanelUI() {
    }

    @Override
    protected Insets getGroupInsets() {
        int extraPadding = SubstanceSizeUtils.getExtraPadding((int)SubstanceSizeUtils.getComponentFontSize((Component)this.buttonPanel));
        Insets result = BasicCommandButtonPanelUI.GROUP_INSETS;
        return new Insets(result.top + extraPadding, result.left + extraPadding, result.bottom + extraPadding, result.right + extraPadding);
    }

    @Override
    protected int getGroupTitleHeight(int groupIndex) {
        int extraPadding = SubstanceSizeUtils.getExtraPadding((int)SubstanceSizeUtils.getComponentFontSize((Component)this.buttonPanel));
        return this.groupLabels[groupIndex].getPreferredSize().height + 2 * extraPadding;
    }

    @Override
    protected void paintGroupBackground(Graphics g, int groupIndex, int x, int y, int width, int height) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)this.buttonPanel);
        SubstanceColorScheme scheme = skin.getBackgroundColorScheme(DecorationPainterUtils.getDecorationType((Component)this.buttonPanel));
        Color background = groupIndex % 2 == 0 ? scheme.getBackgroundFillColor() : scheme.getAccentedBackgroundFillColor();
        BackgroundPaintingUtils.fillBackground((Graphics)g, (JComponent)this.buttonPanel, (Color)background, (Rectangle)new Rectangle(x, y, width, height));
    }

    @Override
    protected void paintGroupTitleBackground(Graphics g, int groupIndex, int x, int y, int width, int height) {
        EnumSet<SubstanceSlices.Side> openSides = EnumSet.of(SubstanceSlices.Side.LEFT, SubstanceSlices.Side.RIGHT);
        if (groupIndex == 0) {
            openSides.add(SubstanceSlices.Side.TOP);
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)this.buttonPanel);
        SubstanceColorScheme scheme = skin.getBackgroundColorScheme(DecorationPainterUtils.getDecorationType((Component)this.buttonPanel));
        Color backgroundFill = scheme.getAccentedBackgroundFillColor();
        Graphics2D g2d = (Graphics2D)g.create(x, y, width, height);
        g2d.setColor(backgroundFill);
        g2d.fillRect(0, 0, width, height);
        HighlightPainterUtils.paintHighlightBorder((Graphics2D)g2d, (Component)this.buttonPanel, (int)width, (int)height, (float)1.0f, openSides, (SubstanceBorderPainter)SubstanceCoreUtilities.getBorderPainter((Component)this.buttonPanel), (SubstanceColorScheme)SubstanceColorSchemeUtilities.getColorScheme((Component)this.buttonPanel, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED));
        g2d.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque((Graphics)g, (JComponent)c);
        this.paint(g, c);
    }
}

