/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon.synapse.model;

import org.pushingpixels.flamingo.api.common.HorizontalAlignment;
import org.pushingpixels.flamingo.api.common.model.ImmutablePresentationModel;

public class ComponentPresentationModel
implements ImmutablePresentationModel {
    private boolean isFlat;
    private HorizontalAlignment horizontalAlignment;
    private String keyTip;
    private boolean isResizingAware;

    private ComponentPresentationModel() {
    }

    public static ComponentPresentationModel withDefaults() {
        return ComponentPresentationModel.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public String getKeyTip() {
        return this.keyTip;
    }

    public boolean isResizingAware() {
        return this.isResizingAware;
    }

    public static class Builder {
        private boolean isFlat = true;
        private HorizontalAlignment horizontalAlignment = HorizontalAlignment.FILL;
        private String keyTip;
        private boolean isResizingAware;

        public Builder setFlat(boolean flat) {
            this.isFlat = flat;
            return this;
        }

        public Builder setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Builder setKeyTip(String keyTip) {
            this.keyTip = keyTip;
            return this;
        }

        public Builder setResizingAware(boolean resizingAware) {
            this.isResizingAware = resizingAware;
            return this;
        }

        public ComponentPresentationModel build() {
            ComponentPresentationModel commandPresentation = new ComponentPresentationModel();
            commandPresentation.horizontalAlignment = this.horizontalAlignment;
            commandPresentation.isFlat = this.isFlat;
            commandPresentation.keyTip = this.keyTip;
            commandPresentation.isResizingAware = this.isResizingAware;
            return commandPresentation;
        }
    }
}

