/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon.resize;

import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JFlowRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JFlowBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonBandUI;

public class CoreRibbonResizePolicies {
    public static List<RibbonBandResizePolicy> getCorePoliciesPermissive(JRibbonBand ribbonBand) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        result.add(new None(ribbonBand));
        result.add(new Low2Mid(ribbonBand));
        result.add(new Mid2Mid(ribbonBand));
        result.add(new Mirror(ribbonBand));
        result.add(new Mid2Low(ribbonBand));
        result.add(new High2Mid(ribbonBand));
        result.add(new High2Low(ribbonBand));
        result.add(new IconRibbonBandResizePolicy(ribbonBand));
        return result;
    }

    public static List<RibbonBandResizePolicy> getCorePoliciesRestrictive(JRibbonBand ribbonBand) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        result.add(new Mirror(ribbonBand));
        result.add(new Mid2Low(ribbonBand));
        result.add(new High2Mid(ribbonBand));
        result.add(new High2Low(ribbonBand));
        result.add(new IconRibbonBandResizePolicy(ribbonBand));
        return result;
    }

    public static List<RibbonBandResizePolicy> getCorePoliciesNone(JRibbonBand ribbonBand) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        result.add(new Mirror(ribbonBand));
        result.add(new IconRibbonBandResizePolicy(ribbonBand));
        return result;
    }

    public static List<RibbonBandResizePolicy> getCoreFlowPoliciesRestrictive(JFlowRibbonBand ribbonBand, int stepsToRepeat) {
        int i;
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        for (i = 0; i < stepsToRepeat; ++i) {
            result.add(new FlowTwoRows(ribbonBand));
        }
        for (i = 0; i < stepsToRepeat; ++i) {
            result.add(new FlowThreeRows(ribbonBand));
        }
        result.add(new IconRibbonBandResizePolicy(ribbonBand));
        return result;
    }

    public static class IconRibbonBandResizePolicy
    extends BaseRibbonBandResizePolicy<AbstractRibbonBand> {
        public IconRibbonBandResizePolicy(AbstractRibbonBand ribbonBand) {
            super(ribbonBand);
        }

        @Override
        public int getPreferredWidth(int availableHeight, int gap) {
            RibbonBandUI ui = this.ribbonBand.getUI();
            return ui.getPreferredCollapsedWidth();
        }

        @Override
        public void install(int availableHeight, int gap) {
        }
    }

    public static class FlowThreeRows
    extends BaseRibbonBandResizePolicy<JFlowRibbonBand> {
        public FlowThreeRows(JFlowRibbonBand flowRibbonBand) {
            super(flowRibbonBand);
        }

        @Override
        public int getPreferredWidth(int availableHeight, int gap) {
            JFlowBandControlPanel flowBandControlPanel = (JFlowBandControlPanel)this.controlPanel;
            int compCount = flowBandControlPanel.getFlowComponents().size();
            int[] widths = new int[compCount];
            int index = 0;
            int currBestResult = 0;
            for (JComponent flowComp : flowBandControlPanel.getFlowComponents()) {
                int pref = flowComp.getPreferredSize().width;
                widths[index++] = pref;
                currBestResult += pref + gap;
            }
            for (int inflectionIndex1 = 0; inflectionIndex1 < compCount - 2; ++inflectionIndex1) {
                for (int inflectionIndex2 = inflectionIndex1 + 1; inflectionIndex2 < compCount - 1; ++inflectionIndex2) {
                    int w1 = 0;
                    for (int index1 = 0; index1 <= inflectionIndex1; ++index1) {
                        w1 += widths[index1] + gap;
                    }
                    int w2 = 0;
                    for (int index2 = inflectionIndex1 + 1; index2 <= inflectionIndex2; ++index2) {
                        w2 += widths[index2] + gap;
                    }
                    int w3 = 0;
                    for (int index3 = inflectionIndex2 + 1; index3 < compCount; ++index3) {
                        w3 += widths[index3] + gap;
                    }
                    int width = Math.max(Math.max(w1, w2), w3);
                    if (width >= currBestResult) continue;
                    currBestResult = width;
                }
            }
            return currBestResult;
        }

        @Override
        public void install(int availableHeight, int gap) {
        }
    }

    public static class FlowTwoRows
    extends BaseRibbonBandResizePolicy<JFlowRibbonBand> {
        public FlowTwoRows(JFlowRibbonBand flowRibbonBand) {
            super(flowRibbonBand);
        }

        @Override
        public int getPreferredWidth(int availableHeight, int gap) {
            JFlowBandControlPanel flowBandControlPanel = (JFlowBandControlPanel)this.controlPanel;
            int compCount = flowBandControlPanel.getFlowComponents().size();
            int[] widths = new int[compCount];
            int index = 0;
            int currBestResult = 0;
            for (JComponent flowComp : flowBandControlPanel.getFlowComponents()) {
                int pref = flowComp.getPreferredSize().width;
                widths[index++] = pref;
                currBestResult += pref + gap;
            }
            for (int inflectionIndex = 0; inflectionIndex < compCount - 1; ++inflectionIndex) {
                int w1 = 0;
                for (int index1 = 0; index1 <= inflectionIndex; ++index1) {
                    w1 += widths[index1] + gap;
                }
                int w2 = 0;
                for (int index2 = inflectionIndex + 1; index2 < compCount; ++index2) {
                    w2 += widths[index2] + gap;
                }
                int width = Math.max(w1, w2);
                if (width >= currBestResult) continue;
                currBestResult = width;
            }
            return currBestResult;
        }

        @Override
        public void install(int availableHeight, int gap) {
        }
    }

    public static final class High2Low
    extends BaseCoreRibbonBandResizePolicy {
        public High2Low(JRibbonBand ribbonBand) {
            super(ribbonBand, priority -> JRibbonBand.PresentationPriority.LOW);
        }
    }

    public static final class High2Mid
    extends BaseCoreRibbonBandResizePolicy {
        public High2Mid(JRibbonBand ribbonBand) {
            super(ribbonBand, priority -> {
                switch (priority) {
                    case TOP: {
                        return JRibbonBand.PresentationPriority.MEDIUM;
                    }
                    case MEDIUM: {
                        return JRibbonBand.PresentationPriority.LOW;
                    }
                    case LOW: {
                        return JRibbonBand.PresentationPriority.LOW;
                    }
                }
                return null;
            });
        }
    }

    public static final class Mid2Low
    extends BaseCoreRibbonBandResizePolicy {
        public Mid2Low(JRibbonBand ribbonBand) {
            super(ribbonBand, priority -> {
                switch (priority) {
                    case TOP: {
                        return JRibbonBand.PresentationPriority.TOP;
                    }
                    case MEDIUM: {
                        return JRibbonBand.PresentationPriority.LOW;
                    }
                    case LOW: {
                        return JRibbonBand.PresentationPriority.LOW;
                    }
                }
                return null;
            });
        }
    }

    public static final class Mirror
    extends BaseCoreRibbonBandResizePolicy {
        public Mirror(JRibbonBand ribbonBand) {
            super(ribbonBand, priority -> priority);
        }
    }

    public static final class Mid2Mid
    extends BaseCoreRibbonBandResizePolicy {
        public Mid2Mid(JRibbonBand ribbonBand) {
            super(ribbonBand, priority -> {
                switch (priority) {
                    case TOP: {
                        return JRibbonBand.PresentationPriority.TOP;
                    }
                    case MEDIUM: {
                        return JRibbonBand.PresentationPriority.MEDIUM;
                    }
                    case LOW: {
                        return JRibbonBand.PresentationPriority.MEDIUM;
                    }
                }
                return null;
            });
        }
    }

    public static final class Low2Mid
    extends BaseCoreRibbonBandResizePolicy {
        public Low2Mid(JRibbonBand ribbonBand) {
            super(ribbonBand, priority -> {
                switch (priority) {
                    case TOP: {
                        return JRibbonBand.PresentationPriority.TOP;
                    }
                    case MEDIUM: {
                        return JRibbonBand.PresentationPriority.TOP;
                    }
                    case LOW: {
                        return JRibbonBand.PresentationPriority.MEDIUM;
                    }
                }
                return null;
            });
        }
    }

    public static final class None
    extends BaseCoreRibbonBandResizePolicy {
        public None(JRibbonBand ribbonBand) {
            super(ribbonBand, priority -> JRibbonBand.PresentationPriority.TOP);
        }
    }

    public static abstract class BaseCoreRibbonBandResizePolicy
    extends BaseRibbonBandResizePolicy<JRibbonBand> {
        protected Mapping mapping;

        protected BaseCoreRibbonBandResizePolicy(JRibbonBand ribbonBand, Mapping mapping) {
            super(ribbonBand);
            this.mapping = mapping;
        }

        protected int getWidth(int gap, List<JCommandButton> bigButtons, List<JCommandButton> mediumButtons, List<JCommandButton> smallButtons) {
            int result = 0;
            boolean hasLeadingContent = false;
            for (JCommandButton top : bigButtons) {
                if (hasLeadingContent) {
                    result += gap;
                }
                result += this.getPreferredWidth(top, JRibbonBand.PresentationPriority.TOP);
                hasLeadingContent = true;
            }
            int medSize = mediumButtons.size();
            if (medSize > 0) {
                while (mediumButtons.size() % 3 != 0 && smallButtons.size() > 0) {
                    JCommandButton low = smallButtons.remove(0);
                    mediumButtons.add(low);
                }
            }
            int index3 = 0;
            int maxWidth3 = 0;
            for (JCommandButton medium : mediumButtons) {
                int medWidth = this.getPreferredWidth(medium, JRibbonBand.PresentationPriority.MEDIUM);
                maxWidth3 = Math.max(maxWidth3, medWidth);
                if (++index3 != 3) continue;
                index3 = 0;
                if (hasLeadingContent) {
                    result += gap;
                }
                result += maxWidth3;
                hasLeadingContent = true;
                maxWidth3 = 0;
            }
            if (maxWidth3 > 0) {
                if (hasLeadingContent) {
                    result += gap;
                }
                result += maxWidth3;
                hasLeadingContent = true;
            }
            index3 = 0;
            maxWidth3 = 0;
            for (JCommandButton low : smallButtons) {
                int lowWidth = this.getPreferredWidth(low, JRibbonBand.PresentationPriority.LOW);
                maxWidth3 = Math.max(maxWidth3, lowWidth);
                if (++index3 != 3) continue;
                index3 = 0;
                if (hasLeadingContent) {
                    result += gap;
                }
                result += maxWidth3;
                hasLeadingContent = true;
                maxWidth3 = 0;
            }
            if (maxWidth3 > 0) {
                if (hasLeadingContent) {
                    result += gap;
                }
                result += maxWidth3;
                hasLeadingContent = true;
            }
            return result;
        }

        private int getPreferredWidth(JCommandButton button, JRibbonBand.PresentationPriority buttonPresentationPriority) {
            CommandButtonPresentationState presentationState = null;
            switch (buttonPresentationPriority) {
                case TOP: {
                    presentationState = CommandButtonPresentationState.BIG;
                    break;
                }
                case MEDIUM: {
                    presentationState = CommandButtonPresentationState.MEDIUM;
                    break;
                }
                case LOW: {
                    presentationState = CommandButtonPresentationState.SMALL;
                }
            }
            return presentationState.createLayoutManager((JCommandButton)button).getPreferredSize((JCommandButton)button).width;
        }

        @Override
        public int getPreferredWidth(int availableHeight, int gap) {
            int result = 0;
            Insets ins = this.controlPanel.getInsets();
            for (JBandControlPanel.ControlPanelGroup controlPanelGroup : ((JBandControlPanel)this.controlPanel).getControlPanelGroups()) {
                boolean isCoreContent = controlPanelGroup.isCoreContent();
                if (isCoreContent) {
                    int startRowIndex;
                    List<JRibbonComponent> ribbonComps = controlPanelGroup.getRibbonComps();
                    int rowIndex = startRowIndex = controlPanelGroup.getGroupTitle() == null ? 0 : 1;
                    int maxWidthInCurrColumn = 0;
                    for (int i = 0; i < ribbonComps.size(); ++i) {
                        JRibbonComponent ribbonComp = ribbonComps.get(i);
                        int rowSpan = 1;
                        int nextRowIndex = rowIndex + rowSpan;
                        if (nextRowIndex > 3) {
                            result += maxWidthInCurrColumn;
                            result += gap;
                            maxWidthInCurrColumn = 0;
                            rowIndex = startRowIndex;
                        }
                        JRibbonBand.PresentationPriority targetPriority = JRibbonBand.PresentationPriority.TOP;
                        if (ribbonComp.isResizingAware()) {
                            targetPriority = this.mapping.map(JRibbonBand.PresentationPriority.TOP);
                        }
                        int prefWidth = ribbonComp.getUI().getPreferredSize((JRibbonBand.PresentationPriority)targetPriority).width;
                        maxWidthInCurrColumn = Math.max(maxWidthInCurrColumn, prefWidth);
                        rowIndex += rowSpan;
                    }
                    if (rowIndex > 0 && rowIndex <= 3) {
                        result += maxWidthInCurrColumn;
                        result += gap;
                    }
                } else {
                    int galleryAvailableHeight = availableHeight - ins.top - ins.bottom;
                    result += this.getPreferredGalleryWidth(controlPanelGroup, galleryAvailableHeight, gap);
                    result += this.getPreferredButtonWidth(controlPanelGroup, gap);
                }
                result += gap * 3 / 2;
            }
            result -= gap * 3 / 2;
            result += ins.left + ins.right;
            return result += gap;
        }

        protected int getPreferredButtonWidth(JBandControlPanel.ControlPanelGroup controlPanelGroup, int gap) {
            HashMap mapped = new HashMap();
            for (JRibbonBand.PresentationPriority rep : JRibbonBand.PresentationPriority.values()) {
                mapped.put(rep, new ArrayList());
            }
            for (JRibbonBand.PresentationPriority elementPriority : JRibbonBand.PresentationPriority.values()) {
                JRibbonBand.PresentationPriority mappedPriority = this.mapping.map(elementPriority);
                for (JCommandButton button : controlPanelGroup.getRibbonButtons(elementPriority)) {
                    ((List)mapped.get((Object)mappedPriority)).add(button);
                }
            }
            return this.getWidth(gap, (List)mapped.get((Object)JRibbonBand.PresentationPriority.TOP), (List)mapped.get((Object)JRibbonBand.PresentationPriority.MEDIUM), (List)mapped.get((Object)JRibbonBand.PresentationPriority.LOW));
        }

        private int getPreferredGalleryWidth(JBandControlPanel.ControlPanelGroup controlPanelGroup, int galleryAvailableHeight, int gap) {
            int result = 0;
            for (JRibbonBand.PresentationPriority elementPriority : JRibbonBand.PresentationPriority.values()) {
                JRibbonBand.PresentationPriority mappedPriority = this.mapping.map(elementPriority);
                for (JRibbonGallery gallery : controlPanelGroup.getRibbonGalleries(elementPriority)) {
                    result += gallery.getPreferredWidth(mappedPriority, galleryAvailableHeight) + gap;
                }
            }
            return result;
        }

        @Override
        public void install(int availableHeight, int gap) {
            for (JBandControlPanel.ControlPanelGroup controlPanelGroup : ((JBandControlPanel)this.controlPanel).getControlPanelGroups()) {
                boolean isCoreContent = controlPanelGroup.isCoreContent();
                if (isCoreContent) {
                    List<JRibbonComponent> ribbonComps = controlPanelGroup.getRibbonComps();
                    for (int i = 0; i < ribbonComps.size(); ++i) {
                        JRibbonComponent ribbonComp = (JRibbonComponent)ribbonComps.get(i);
                        JRibbonBand.PresentationPriority targetPriority = JRibbonBand.PresentationPriority.TOP;
                        if (ribbonComp.isResizingAware()) {
                            targetPriority = this.mapping.map(JRibbonBand.PresentationPriority.TOP);
                        }
                        ribbonComp.setPresentationPriority(targetPriority);
                    }
                    continue;
                }
                for (JRibbonBand.PresentationPriority elementPriority : JRibbonBand.PresentationPriority.values()) {
                    JRibbonBand.PresentationPriority mappedPriority = this.mapping.map(elementPriority);
                    for (JRibbonGallery gallery : controlPanelGroup.getRibbonGalleries(elementPriority)) {
                        gallery.setPresentationPriority(mappedPriority);
                    }
                }
                HashMap mapped = new HashMap();
                for (JRibbonBand.PresentationPriority rep : JRibbonBand.PresentationPriority.values()) {
                    mapped.put(rep, new ArrayList());
                }
                for (JRibbonBand.PresentationPriority elementPriority : JRibbonBand.PresentationPriority.values()) {
                    JRibbonBand.PresentationPriority mappedPriority = this.mapping.map(elementPriority);
                    for (JCommandButton button : controlPanelGroup.getRibbonButtons(elementPriority)) {
                        ((List)mapped.get((Object)mappedPriority)).add(button);
                    }
                }
                for (JCommandButton big : (List)mapped.get((Object)JRibbonBand.PresentationPriority.TOP)) {
                    big.setPresentationState(CommandButtonPresentationState.BIG);
                }
                if (((List)mapped.get((Object)JRibbonBand.PresentationPriority.MEDIUM)).size() > 0) {
                    while (((List)mapped.get((Object)JRibbonBand.PresentationPriority.MEDIUM)).size() % 3 != 0 && ((List)mapped.get((Object)JRibbonBand.PresentationPriority.LOW)).size() > 0) {
                        JCommandButton low = (JCommandButton)((List)mapped.get((Object)JRibbonBand.PresentationPriority.LOW)).get(0);
                        ((List)mapped.get((Object)JRibbonBand.PresentationPriority.LOW)).remove(low);
                        ((List)mapped.get((Object)JRibbonBand.PresentationPriority.MEDIUM)).add(low);
                    }
                }
                for (JCommandButton medium : (List)mapped.get((Object)JRibbonBand.PresentationPriority.MEDIUM)) {
                    medium.setPresentationState(CommandButtonPresentationState.MEDIUM);
                }
                for (JCommandButton low : (List)mapped.get((Object)JRibbonBand.PresentationPriority.LOW)) {
                    low.setPresentationState(CommandButtonPresentationState.SMALL);
                }
            }
        }
    }

    public static abstract class BaseRibbonBandResizePolicy<B extends AbstractRibbonBand>
    implements RibbonBandResizePolicy {
        protected B ribbonBand;
        protected AbstractBandControlPanel controlPanel;

        protected BaseRibbonBandResizePolicy(B ribbonBand) {
            this.ribbonBand = ribbonBand;
            this.controlPanel = ((AbstractRibbonBand)this.ribbonBand).getControlPanel();
        }
    }

    static interface Mapping {
        public JRibbonBand.PresentationPriority map(JRibbonBand.PresentationPriority var1);
    }
}

