/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.pushingpixels.neon.api.AsynchronousLoadListener;
import org.pushingpixels.neon.api.AsynchronousLoading;
import org.pushingpixels.neon.api.NeonCortex;

abstract class ImageWrapperIcon
implements Icon,
AsynchronousLoading {
    protected BufferedImage originalImage;
    protected InputStream imageInputStream;
    protected Image image;
    protected Map<String, BufferedImage> cachedImages;
    protected int width;
    protected int height;
    protected EventListenerList listenerList;

    public ImageWrapperIcon(InputStream inputStream, int w, int h) {
        this.imageInputStream = inputStream;
        this.width = w;
        this.height = h;
        this.listenerList = new EventListenerList();
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
        this.renderImage(this.width, this.height);
    }

    public ImageWrapperIcon(Image image, int w, int h) {
        this.image = image;
        this.width = w;
        this.height = h;
        this.listenerList = new EventListenerList();
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
        this.renderImage(this.width, this.height);
    }

    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.add(AsynchronousLoadListener.class, l);
    }

    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.remove(AsynchronousLoadListener.class, l);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        if (image != null) {
            double scale = NeonCortex.getScaleFactor(null);
            int dx = (this.width - (int)((double)image.getWidth() / scale)) / 2;
            int dy = (this.height - (int)((double)image.getHeight() / scale)) / 2;
            NeonCortex.drawImageWithScale((Graphics)g, (double)scale, (Image)image, (int)(x + dx), (int)(y + dy));
        }
    }

    public synchronized void setPreferredSize(Dimension dim) {
        if (dim.width == this.width && dim.height == this.height) {
            return;
        }
        this.width = dim.width;
        this.height = dim.height;
        this.renderImage(this.width, this.height);
    }

    protected synchronized void renderImage(final int renderWidth, final int renderHeight) {
        String key = renderWidth + ":" + renderHeight;
        if (this.cachedImages.containsKey(key)) {
            this.fireAsyncCompleted(true);
            return;
        }
        SwingWorker<BufferedImage, Void> worker = new SwingWorker<BufferedImage, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected BufferedImage doInBackground() throws Exception {
                if (ImageWrapperIcon.this.imageInputStream != null) {
                    InputStream inputStream = ImageWrapperIcon.this.imageInputStream;
                    synchronized (inputStream) {
                        if (ImageWrapperIcon.this.originalImage == null) {
                            ImageWrapperIcon.this.originalImage = ImageIO.read(ImageWrapperIcon.this.imageInputStream);
                        }
                    }
                } else {
                    ImageWrapperIcon.this.originalImage = NeonCortex.getBlankUnscaledImage((int)ImageWrapperIcon.this.image.getWidth(null), (int)ImageWrapperIcon.this.image.getHeight(null));
                    Graphics2D g = ImageWrapperIcon.this.originalImage.createGraphics();
                    g.drawImage(ImageWrapperIcon.this.image, 0, 0, null);
                    g.dispose();
                }
                BufferedImage result = ImageWrapperIcon.this.originalImage;
                float scaleX = (float)ImageWrapperIcon.this.originalImage.getWidth() / (float)renderWidth;
                float scaleY = (float)ImageWrapperIcon.this.originalImage.getHeight() / (float)ImageWrapperIcon.this.height;
                float scale = Math.max(scaleX, scaleY);
                if (scale > 1.0f) {
                    int finalWidth = (int)((float)ImageWrapperIcon.this.originalImage.getWidth() / scale);
                    result = NeonCortex.createThumbnail((double)NeonCortex.getScaleFactor(null), (BufferedImage)ImageWrapperIcon.this.originalImage, (int)finalWidth);
                }
                return result;
            }

            @Override
            protected void done() {
                try {
                    BufferedImage bufferedImage = (BufferedImage)this.get();
                    ImageWrapperIcon.this.cachedImages.put(renderWidth + ":" + renderHeight, bufferedImage);
                    ImageWrapperIcon.this.fireAsyncCompleted(true);
                }
                catch (Exception exc) {
                    ImageWrapperIcon.this.fireAsyncCompleted(false);
                }
            }
        };
        worker.execute();
    }

    protected void fireAsyncCompleted(Boolean event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AsynchronousLoadListener.class) continue;
            ((AsynchronousLoadListener)listeners[i + 1]).completed(event.booleanValue());
        }
    }

    public synchronized boolean isLoading() {
        BufferedImage image = this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        return image == null;
    }
}

