/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Map;
import org.pushingpixels.neon.api.AsynchronousLoadListener;
import org.pushingpixels.neon.api.AsynchronousLoading;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class IconDeckResizableIcon<T>
implements ResizableIcon,
AsynchronousLoading {
    private ResizableIcon currentIcon;
    private final Map<T, ? extends ResizableIcon> iconDeck;

    public IconDeckResizableIcon(Map<T, ? extends ResizableIcon> iconDeck) {
        if (iconDeck.isEmpty()) {
            throw new IllegalArgumentException("Icon deck is empty; must have at least one icon");
        }
        this.iconDeck = iconDeck;
        this.currentIcon = iconDeck.values().iterator().next();
    }

    public void setIcon(T key) {
        this.currentIcon = this.iconDeck.get(key);
    }

    public void setDimension(Dimension dim) {
        for (ResizableIcon resizableIcon : this.iconDeck.values()) {
            int currH = resizableIcon.getIconHeight();
            int currW = resizableIcon.getIconWidth();
            if (currH == dim.height && currW == dim.width) continue;
            resizableIcon.setDimension(dim);
        }
    }

    public int getIconHeight() {
        return this.currentIcon.getIconHeight();
    }

    public int getIconWidth() {
        return this.currentIcon.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.currentIcon.paintIcon(c, g, x, y);
    }

    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        for (ResizableIcon resizableIcon : this.iconDeck.values()) {
            if (!(resizableIcon instanceof AsynchronousLoading)) continue;
            ((AsynchronousLoading)resizableIcon).addAsynchronousLoadListener(l);
        }
    }

    public boolean isLoading() {
        for (ResizableIcon resizableIcon : this.iconDeck.values()) {
            if (!(resizableIcon instanceof AsynchronousLoading) || !((AsynchronousLoading)resizableIcon).isLoading()) continue;
            return true;
        }
        return false;
    }

    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        for (ResizableIcon resizableIcon : this.iconDeck.values()) {
            if (!(resizableIcon instanceof AsynchronousLoading)) continue;
            ((AsynchronousLoading)resizableIcon).removeAsynchronousLoadListener(l);
        }
    }
}

