/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pushingpixels.neon.api.AsynchronousLoading;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class FilteredResizableIcon
implements ResizableIcon {
    private Map<String, BufferedImage> cachedImages;
    private ResizableIcon delegate;
    private BufferedImageOp operation;

    private FilteredResizableIcon(ResizableIcon delegate, BufferedImageOp operation) {
        this.delegate = delegate;
        this.operation = operation;
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d;
        double scale = NeonCortex.getScaleFactor((Component)c);
        String key = scale + ":" + this.getIconWidth() + ":" + this.getIconHeight();
        if (!this.cachedImages.containsKey(key)) {
            AsynchronousLoading asyncDelegate;
            if (this.delegate instanceof AsynchronousLoading && (asyncDelegate = (AsynchronousLoading)this.delegate).isLoading()) {
                return;
            }
            BufferedImage offscreen = NeonCortex.getBlankScaledImage((double)scale, (int)this.getIconWidth(), (int)this.getIconHeight());
            g2d = offscreen.createGraphics();
            this.delegate.paintIcon(c, (Graphics)g2d, 0, 0);
            g2d.dispose();
            BufferedImage filtered = this.operation.filter(offscreen, null);
            this.cachedImages.put(key, filtered);
        }
        BufferedImage toDraw = this.cachedImages.get(key);
        g2d = (Graphics2D)g.create();
        g2d.translate(x, y);
        g2d.drawImage(toDraw, 0, 0, (int)((double)toDraw.getWidth(null) / scale), (int)((double)toDraw.getHeight(null) / scale), null);
        g2d.dispose();
    }

    public static ResizableIcon.Factory factory(ResizableIcon.Factory delegateFactory, BufferedImageOp operation) {
        return () -> new FilteredResizableIcon(delegateFactory.createNewIcon(), operation);
    }
}

