/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.internal.ui.common.JRichTooltipPanel;

public class RichTooltipManager {
    private Timer initialDelayTimer = new Timer(750, new InitialDelayTimerAction());
    private Timer dismissTimer;
    private RichTooltip richTooltip;
    private JTrackableComponent currentActiveTrackable;
    private MouseEvent lastMouseEvent;
    private MouseEvent lastMouseEventInCurrentActiveTrackableCoordinates;
    private static final RichTooltipManager sharedInstance = new RichTooltipManager();
    private Popup tipWindow;
    private JRichTooltipPanel tip;
    private boolean tipShowing = false;

    private RichTooltipManager() {
        this.initialDelayTimer.setRepeats(false);
        this.dismissTimer = new Timer(20000, new DismissTimerAction());
        this.dismissTimer.setRepeats(false);
        Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
            MouseEvent mouseEvent = (MouseEvent)event;
            switch (mouseEvent.getID()) {
                case 501: {
                    this.hideTipWindow();
                    this.initialDelayTimer.stop();
                    this.currentActiveTrackable = null;
                    this.lastMouseEvent = null;
                    this.lastMouseEventInCurrentActiveTrackableCoordinates = null;
                    break;
                }
                case 503: {
                    JTrackableComponent trackableComponent;
                    int x = mouseEvent.getX();
                    int y = mouseEvent.getY();
                    Component source = (Component)event.getSource();
                    Component deepest = SwingUtilities.getDeepestComponentAt(source, x, y);
                    JTrackableComponent jTrackableComponent = trackableComponent = deepest instanceof JTrackableComponent ? (JTrackableComponent)deepest : (JTrackableComponent)SwingUtilities.getAncestorOfClass(JTrackableComponent.class, deepest);
                    if (trackableComponent != null) {
                        Point inTrackableComponent = SwingUtilities.convertPoint(source, x, y, trackableComponent);
                        if (trackableComponent.contains(inTrackableComponent)) {
                            if (this.currentActiveTrackable == trackableComponent) {
                                if (this.tipShowing) {
                                    this.checkForTipChange(mouseEvent, trackableComponent);
                                    break;
                                }
                                this.currentActiveTrackable = trackableComponent;
                                this.lastMouseEvent = mouseEvent;
                                this.lastMouseEventInCurrentActiveTrackableCoordinates = this.retarget(mouseEvent, source, trackableComponent);
                                this.richTooltip = null;
                                this.initialDelayTimer.restart();
                                break;
                            }
                            this.initiateToolTip(mouseEvent, trackableComponent);
                            break;
                        }
                        if (this.currentActiveTrackable == null) break;
                        this.windDownTooltip();
                        break;
                    }
                    if (this.currentActiveTrackable == null) break;
                    this.windDownTooltip();
                }
            }
        }, 48L);
    }

    public void setInitialDelay(int milliseconds) {
        this.initialDelayTimer.setInitialDelay(milliseconds);
    }

    public int getInitialDelay() {
        return this.initialDelayTimer.getInitialDelay();
    }

    public void setDismissDelay(int milliseconds) {
        this.dismissTimer.setInitialDelay(milliseconds);
    }

    public int getDismissDelay() {
        return this.dismissTimer.getInitialDelay();
    }

    private MouseEvent retarget(MouseEvent original, Component source, Component target) {
        Point inTarget = SwingUtilities.convertPoint(source, original.getX(), original.getY(), target);
        return new MouseEvent(target, original.getID(), original.getWhen(), original.getModifiersEx(), inTarget.x, inTarget.y, original.getClickCount(), original.isPopupTrigger(), original.getButton());
    }

    private void showTipWindow(MouseEvent mouseEvent) {
        boolean isInRibbonBand;
        if (this.currentActiveTrackable == null || !this.currentActiveTrackable.isShowing()) {
            return;
        }
        Point screenLocation = this.currentActiveTrackable.getLocationOnScreen();
        Point location = new Point();
        GraphicsConfiguration gc = this.currentActiveTrackable.getGraphicsConfiguration();
        Rectangle sBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        sBounds.x += screenInsets.left;
        sBounds.y += screenInsets.top;
        sBounds.width -= screenInsets.left + screenInsets.right;
        sBounds.height -= screenInsets.top + screenInsets.bottom;
        this.hideTipWindow();
        this.tip = new JRichTooltipPanel(this.currentActiveTrackable.getRichTooltip(mouseEvent));
        this.tip.applyComponentOrientation(this.currentActiveTrackable.getComponentOrientation());
        Dimension size = this.tip.getPreferredSize();
        AbstractRibbonBand ribbonBand = (AbstractRibbonBand)SwingUtilities.getAncestorOfClass(AbstractRibbonBand.class, this.currentActiveTrackable);
        boolean ltr = this.tip.getComponentOrientation().isLeftToRight();
        boolean bl = isInRibbonBand = ribbonBand != null;
        if (isInRibbonBand) {
            location.x = ltr ? screenLocation.x : screenLocation.x + this.currentActiveTrackable.getWidth() - size.width;
            Point bandLocationOnScreen = ribbonBand.getLocationOnScreen();
            location.y = bandLocationOnScreen.y + ribbonBand.getHeight() + 4;
            if (location.y + size.height > sBounds.y + sBounds.height) {
                location.y = bandLocationOnScreen.y - size.height;
            }
        } else {
            location.x = ltr ? screenLocation.x : screenLocation.x + this.currentActiveTrackable.getWidth() - size.width;
            location.y = screenLocation.y + this.currentActiveTrackable.getHeight();
            if (location.y + size.height > sBounds.y + sBounds.height) {
                location.y = screenLocation.y - size.height;
            }
        }
        if (location.x < sBounds.x) {
            location.x = sBounds.x;
        } else if (location.x - sBounds.x + size.width > sBounds.width) {
            location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.tipWindow = popupFactory.getPopup(this.currentActiveTrackable, this.tip, location.x, location.y);
        this.tipWindow.show();
        this.dismissTimer.start();
        this.tipShowing = true;
    }

    private void windDownTooltip() {
        this.initialDelayTimer.stop();
        this.currentActiveTrackable = null;
        this.richTooltip = null;
        this.lastMouseEvent = null;
        this.lastMouseEventInCurrentActiveTrackableCoordinates = null;
        this.hideTipWindow();
    }

    private void hideTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip = null;
            this.dismissTimer.stop();
        }
    }

    public static RichTooltipManager sharedInstance() {
        return sharedInstance;
    }

    public void hideCurrentlyShowingTipIfNecessary() {
        this.hideTipWindow();
    }

    private void initiateToolTip(MouseEvent original, JTrackableComponent component) {
        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
        if (popups.size() > 0) {
            JPopupPanel popupPanel = popups.get(popups.size() - 1).getPopupPanel();
            boolean ignore = true;
            for (Container c = component; c != null; c = c.getParent()) {
                if (c != popupPanel) continue;
                ignore = false;
                break;
            }
            if (ignore) {
                return;
            }
        }
        if (this.currentActiveTrackable != null) {
            this.initialDelayTimer.stop();
        }
        this.currentActiveTrackable = component;
        this.lastMouseEvent = original;
        this.lastMouseEventInCurrentActiveTrackableCoordinates = this.retarget(original, this.lastMouseEvent.getComponent(), component);
        this.initialDelayTimer.start();
    }

    private void checkForTipChange(MouseEvent event, JTrackableComponent component) {
        boolean isDifferent;
        RichTooltip newTooltip = component.getRichTooltip(event);
        boolean bl = isDifferent = this.richTooltip != newTooltip;
        if (isDifferent) {
            this.hideTipWindow();
            if (newTooltip != null) {
                this.richTooltip = newTooltip;
                this.initialDelayTimer.restart();
            }
        }
    }

    private class DismissTimerAction
    implements ActionListener {
        private DismissTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RichTooltipManager.this.hideTipWindow();
            RichTooltipManager.this.initialDelayTimer.stop();
            RichTooltipManager.this.currentActiveTrackable = null;
            RichTooltipManager.this.lastMouseEvent = null;
            RichTooltipManager.this.lastMouseEventInCurrentActiveTrackableCoordinates = null;
        }
    }

    private class InitialDelayTimerAction
    implements ActionListener {
        private InitialDelayTimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RichTooltipManager.this.currentActiveTrackable != null && RichTooltipManager.this.currentActiveTrackable.isShowing()) {
                if (RichTooltipManager.this.richTooltip == null && RichTooltipManager.this.lastMouseEvent != null) {
                    RichTooltipManager.this.richTooltip = RichTooltipManager.this.currentActiveTrackable.getRichTooltip(RichTooltipManager.this.lastMouseEventInCurrentActiveTrackableCoordinates);
                }
                if (RichTooltipManager.this.richTooltip != null) {
                    boolean showRichTooltip = true;
                    for (PopupPanelManager.PopupInfo pi : PopupPanelManager.defaultManager().getShownPath()) {
                        if (pi.getPopupOriginator() != RichTooltipManager.this.currentActiveTrackable) continue;
                        showRichTooltip = false;
                        break;
                    }
                    if (showRichTooltip) {
                        RichTooltipManager.this.showTipWindow(RichTooltipManager.this.lastMouseEventInCurrentActiveTrackableCoordinates);
                    }
                } else {
                    RichTooltipManager.this.currentActiveTrackable = null;
                    RichTooltipManager.this.richTooltip = null;
                    RichTooltipManager.this.lastMouseEvent = null;
                    RichTooltipManager.this.lastMouseEventInCurrentActiveTrackableCoordinates = null;
                    RichTooltipManager.this.hideTipWindow();
                }
            }
        }
    }

    public static abstract class JTrackableComponent
    extends JComponent {
        public abstract RichTooltip getRichTooltip(MouseEvent var1);
    }
}

