/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.model.ChangeAware;

public class WeakChangeSupport {
    private final List<WeakChangeListener> listenerList = new ArrayList<WeakChangeListener>();
    private final ChangeAware source;

    public WeakChangeSupport(ChangeAware source) {
        this.source = source;
    }

    public void addChangeListener(ChangeListener l) {
        if (l instanceof WeakChangeListener) {
            throw new IllegalArgumentException("Don't pass an explicitly wrapped listener");
        }
        this.listenerList.add(new WeakChangeListener(this.source, l));
    }

    public void removeChangeListener(ChangeListener l) {
        if (l instanceof WeakChangeListener) {
            this.listenerList.remove(l);
            return;
        }
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            WeakChangeListener current = this.listenerList.get(i);
            ChangeListener original = current.getOriginalChangeListener();
            if (original != null && original != l) continue;
            this.listenerList.remove(i);
        }
    }

    public void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            this.listenerList.get(i).stateChanged(event);
        }
    }

    private static class WeakChangeListener
    implements ChangeListener {
        private WeakReference<ChangeAware> sourceRef;
        private WeakReference<ChangeListener> listenerRef;

        public WeakChangeListener(ChangeAware source, ChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Cannot wrap a null listener");
            }
            if (source != null) {
                this.sourceRef = new WeakReference<ChangeAware>(source);
            }
            this.listenerRef = new WeakReference<ChangeListener>(listener);
        }

        public ChangeListener getOriginalChangeListener() {
            if (this.listenerRef == null) {
                return null;
            }
            return (ChangeListener)this.listenerRef.get();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ChangeListener originalListener = (ChangeListener)this.listenerRef.get();
            if (originalListener != null) {
                originalListener.stateChanged(e);
            } else {
                ChangeAware source;
                if (this.sourceRef != null && (source = (ChangeAware)this.sourceRef.get()) != null) {
                    source.removeChangeListener(this);
                }
                this.listenerRef = null;
                this.sourceRef = null;
            }
        }
    }
}

