/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.ComboPopup;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.ui.common.popup.PopupPanelUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.ScrollableHost;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstancePopupMenuBorder;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboPopup;

public abstract class BasicPopupPanelUI
extends PopupPanelUI {
    protected JPopupPanel popupPanel;
    private AWTEventListener awtEventListener;
    static PopupPanelManager.PopupListener popupPanelManagerListener;

    @Override
    public void installUI(JComponent c) {
        this.popupPanel = (JPopupPanel)c;
        super.installUI(this.popupPanel);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(this.popupPanel);
    }

    protected void installDefaults() {
        Border b = this.popupPanel.getBorder();
        if (b == null || b instanceof UIResource) {
            this.popupPanel.setBorder((Border)new SubstancePopupMenuBorder());
        }
        LookAndFeel.installProperty(this.popupPanel, "opaque", Boolean.TRUE);
    }

    protected void installListeners() {
        BasicPopupPanelUI.initiliazeGlobalListeners();
        this.awtEventListener = event -> {
            MouseEvent me;
            if (event instanceof MouseEvent && (me = (MouseEvent)event).getID() == 501) {
                Component src;
                for (Component c = src = me.getComponent(); c != null && !(c instanceof Window); c = c.getParent()) {
                    if (!(c instanceof JPopupPanel)) continue;
                    return;
                }
                PopupPanelManager.defaultManager().hidePopups(null);
            }
        };
        SubstanceCoreUtilities.registerAWTEventListener((AWTEventListener)this.awtEventListener);
    }

    protected void installComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.popupPanel);
    }

    protected void uninstallListeners() {
        SubstanceCoreUtilities.unregisterAWTEventListener((AWTEventListener)this.awtEventListener);
        this.awtEventListener = null;
    }

    protected void uninstallComponents() {
    }

    protected static synchronized void initiliazeGlobalListeners() {
        if (popupPanelManagerListener != null) {
            return;
        }
        popupPanelManagerListener = new PopupPanelEscapeDismisser();
        PopupPanelManager.defaultManager().addPopupListener(popupPanelManagerListener);
        new WindowTracker();
    }

    @Override
    public void focusFirst() {
    }

    @Override
    public void focusLast() {
    }

    @Override
    public void focusDown() {
    }

    @Override
    public void focusUp() {
    }

    @Override
    public void focusLeft() {
    }

    @Override
    public void focusRight() {
    }

    protected static class WindowTracker
    implements PopupPanelManager.PopupListener,
    AWTEventListener,
    ComponentListener,
    WindowListener {
        Window grabbedWindow;
        List<PopupPanelManager.PopupInfo> lastPathSelected;

        public WindowTracker() {
            PopupPanelManager popupPanelManager = PopupPanelManager.defaultManager();
            popupPanelManager.addPopupListener(this);
            this.lastPathSelected = popupPanelManager.getShownPath();
            if (this.lastPathSelected.size() != 0) {
                this.grabWindow(this.lastPathSelected);
            }
        }

        void grabWindow(List<PopupPanelManager.PopupInfo> shownPath) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(() -> {
                tk.addAWTEventListener(this, 131184L);
                return null;
            });
            JComponent invoker = shownPath.get(0).getPopupOriginator();
            this.grabbedWindow = SwingUtilities.getWindowAncestor(invoker);
            if (this.grabbedWindow != null) {
                this.grabbedWindow.addComponentListener(this);
                this.grabbedWindow.addWindowListener(this);
            }
        }

        void ungrabWindow() {
            Toolkit tk = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(() -> {
                tk.removeAWTEventListener(this);
                return null;
            });
            if (this.grabbedWindow != null) {
                this.grabbedWindow.removeComponentListener(this);
                this.grabbedWindow.removeWindowListener(this);
                this.grabbedWindow = null;
            }
        }

        @Override
        public void popupShown(PopupPanelManager.PopupEvent event) {
            PopupPanelManager msm = PopupPanelManager.defaultManager();
            List<PopupPanelManager.PopupInfo> p = msm.getShownPath();
            if (this.lastPathSelected.size() == 0 && p.size() != 0) {
                this.grabWindow(p);
            }
            this.lastPathSelected = p;
        }

        @Override
        public void popupHidden(PopupPanelManager.PopupEvent event) {
            PopupPanelManager msm = PopupPanelManager.defaultManager();
            List<PopupPanelManager.PopupInfo> p = msm.getShownPath();
            if (this.lastPathSelected.size() != 0 && p.size() == 0) {
                this.ungrabWindow();
            }
            this.lastPathSelected = p;
        }

        @Override
        public void eventDispatched(AWTEvent ev) {
            if (!(ev instanceof MouseEvent)) {
                return;
            }
            MouseEvent me = (MouseEvent)ev;
            Component src = me.getComponent();
            JPopupPanel popupPanelParent = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, src);
            switch (me.getID()) {
                case 501: {
                    JRibbon ribbon;
                    if (me.isPopupTrigger()) break;
                    boolean wasCommandButtonPopupShowing = false;
                    if (src instanceof JCommandButton) {
                        wasCommandButtonPopupShowing = ((JCommandButton)src).getPopupModel().isPopupShowing();
                    }
                    if (!wasCommandButtonPopupShowing && popupPanelParent != null) {
                        PopupPanelManager.defaultManager().hidePopups(popupPanelParent);
                        return;
                    }
                    if (src instanceof JRibbonTaskToggleButton && (ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, src)) != null && FlamingoUtilities.isShowingMinimizedRibbonInPopup(ribbon)) {
                        return;
                    }
                    if (wasCommandButtonPopupShowing || SwingUtilities.getAncestorOfClass(ComboPopup.class, src) != null) break;
                    PopupPanelManager.defaultManager().hidePopups(src);
                    break;
                }
                case 502: {
                    if (SwingUtilities.getAncestorOfClass(ComboPopup.class, src) == null || src instanceof JScrollBar) break;
                    SwingUtilities.invokeLater(() -> PopupPanelManager.defaultManager().hidePopups(src));
                    break;
                }
                case 507: {
                    if (popupPanelParent != null) {
                        PopupPanelManager.defaultManager().hidePopups(popupPanelParent);
                        return;
                    }
                    Component deepest = SwingUtilities.getDeepestComponentAt(src, me.getX(), me.getY());
                    if (SwingUtilities.getAncestorOfClass(ScrollableHost.class, deepest) != null || SwingUtilities.getAncestorOfClass(SubstanceComboPopup.class, deepest) != null) break;
                    PopupPanelManager.defaultManager().hidePopups(src);
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public void windowIconified(WindowEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            PopupPanelManager.defaultManager().hidePopups(null);
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }
    }

    protected static class PopupPanelEscapeDismisser
    implements PopupPanelManager.PopupListener {
        private ActionMap newActionMap;
        private InputMap newInputMap;
        List<PopupPanelManager.PopupInfo> lastPathSelected;
        private JRootPane tracedRootPane;

        public PopupPanelEscapeDismisser() {
            PopupPanelManager popupPanelManager = PopupPanelManager.defaultManager();
            this.lastPathSelected = popupPanelManager.getShownPath();
            if (this.lastPathSelected.size() != 0) {
                this.traceRootPane(this.lastPathSelected);
            }
        }

        @Override
        public void popupHidden(PopupPanelManager.PopupEvent event) {
            PopupPanelManager msm = PopupPanelManager.defaultManager();
            List<PopupPanelManager.PopupInfo> p = msm.getShownPath();
            if (this.lastPathSelected.size() != 0 && p.size() == 0) {
                this.untraceRootPane();
            }
            this.lastPathSelected = p;
        }

        private void untraceRootPane() {
            if (this.tracedRootPane != null) {
                this.removeUIActionMap(this.tracedRootPane, this.newActionMap);
                this.removeUIInputMap(this.tracedRootPane, this.newInputMap);
            }
        }

        @Override
        public void popupShown(PopupPanelManager.PopupEvent event) {
            PopupPanelManager msm = PopupPanelManager.defaultManager();
            List<PopupPanelManager.PopupInfo> p = msm.getShownPath();
            if (this.lastPathSelected.size() == 0 && p.size() != 0) {
                this.traceRootPane(p);
            }
            this.lastPathSelected = p;
        }

        private void traceRootPane(List<PopupPanelManager.PopupInfo> shownPath) {
            JComponent originator = shownPath.get(0).getPopupOriginator();
            this.tracedRootPane = SwingUtilities.getRootPane(originator);
            if (this.tracedRootPane != null) {
                this.newInputMap = new ComponentInputMapUIResource(this.tracedRootPane);
                this.newInputMap.put(KeyStroke.getKeyStroke(27, 0), "hidePopupPanel");
                this.newActionMap = new ActionMapUIResource();
                this.newActionMap.put("hidePopupPanel", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PopupPanelManager.PopupInfo lastPopup;
                        List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                        if (popups.size() > 0 && (lastPopup = popups.get(popups.size() - 1)).getPopupPanel() instanceof JRibbonApplicationMenuPopupPanel) {
                            JRibbonApplicationMenuPopupPanel appMenuPopupPanel = (JRibbonApplicationMenuPopupPanel)lastPopup.getPopupPanel();
                            KeyTipManager.KeyTipChain currentlyShownKeyTipChain = KeyTipManager.defaultManager().getCurrentlyShownKeyTipChain();
                            if (currentlyShownKeyTipChain != null && currentlyShownKeyTipChain.chainParentComponent == appMenuPopupPanel.getPanelLevel2()) {
                                return;
                            }
                        }
                        PopupPanelManager.defaultManager().hideLastPopup();
                    }
                });
                this.addUIInputMap(this.tracedRootPane, this.newInputMap);
                this.addUIActionMap(this.tracedRootPane, this.newActionMap);
            }
        }

        void addUIInputMap(JComponent c, InputMap map) {
            InputMap parent;
            InputMap lastNonUI = null;
            for (parent = c.getInputMap(2); parent != null && !(parent instanceof UIResource); parent = parent.getParent()) {
                lastNonUI = parent;
            }
            if (lastNonUI == null) {
                c.setInputMap(2, map);
            } else {
                lastNonUI.setParent(map);
            }
            map.setParent(parent);
        }

        void addUIActionMap(JComponent c, ActionMap map) {
            ActionMap parent;
            ActionMap lastNonUI = null;
            for (parent = c.getActionMap(); parent != null && !(parent instanceof UIResource); parent = parent.getParent()) {
                lastNonUI = parent;
            }
            if (lastNonUI == null) {
                c.setActionMap(map);
            } else {
                lastNonUI.setParent(map);
            }
            map.setParent(parent);
        }

        void removeUIInputMap(JComponent c, InputMap map) {
            InputMap im = null;
            for (InputMap parent = c.getInputMap(2); parent != null; parent = parent.getParent()) {
                if (parent == map) {
                    if (im == null) {
                        c.setInputMap(2, map.getParent());
                        break;
                    }
                    im.setParent(map.getParent());
                    break;
                }
                im = parent;
            }
        }

        void removeUIActionMap(JComponent c, ActionMap map) {
            ActionMap im = null;
            for (ActionMap parent = c.getActionMap(); parent != null; parent = parent.getParent()) {
                if (parent == map) {
                    if (im == null) {
                        c.setActionMap(map.getParent());
                        break;
                    }
                    im.setParent(map.getParent());
                    break;
                }
                im = parent;
            }
        }
    }
}

