/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.popup.JColorSelectorPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuPresentationModel;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicCommandPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.ColorSelectorPopupMenuMultiRowSelector;
import org.pushingpixels.flamingo.internal.ui.common.popup.ColorSelectorPopupMenuSingleRowSelector;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorPanel;

public abstract class BasicColorSelectorPopupMenuUI
extends BasicCommandPopupMenuUI {
    private int columnOfFocusedColorSelector = 0;
    private int indexOfMenuComponentWithFocus = -1;

    public abstract int getColorSelectorCellSize();

    public abstract int getColorSelectorCellGap();

    @Override
    protected boolean hasLeadingButtonPanel() {
        return false;
    }

    @Override
    protected BasicCommandPopupMenuUI.ScrollableCommandButtonPanel createScrollableButtonPanel() {
        return null;
    }

    @Override
    protected int getMaxVisibleMenuCommands() {
        return 0;
    }

    @Override
    public void focusFirst() {
        List<Component> popupMenuComponents = this.popupMenu.getMenuComponents();
        if (!popupMenuComponents.isEmpty()) {
            Component first = popupMenuComponents.get(0);
            if (first instanceof JColorSelectorPanel) {
                JColorSelectorPanel colorSelectorPanel = (JColorSelectorPanel)first;
                JPanel colorSelectionContainer = colorSelectorPanel.getColorSelectionContainer();
                if (colorSelectionContainer instanceof ColorSelectorPopupMenuSingleRowSelector) {
                    ((ColorSelectorPopupMenuSingleRowSelector)colorSelectionContainer).focusOn(this.columnOfFocusedColorSelector);
                } else {
                    ((ColorSelectorPopupMenuMultiRowSelector)colorSelectionContainer).focusOn(0, this.columnOfFocusedColorSelector);
                }
            } else {
                first.requestFocus();
                this.menuItemsPanel.scrollToIfNecessary(first.getY(), first.getHeight());
            }
            this.indexOfMenuComponentWithFocus = 0;
        }
    }

    @Override
    public void focusLast() {
        super.focusLast();
    }

    @Override
    public void focusDown() {
        JPanel colorSelectionContainer;
        if (this.indexOfMenuComponentWithFocus < 0) {
            this.focusFirst();
            return;
        }
        List<Component> popupMenuComponents = this.popupMenu.getMenuComponents();
        Component currMenuComponentWithFocus = popupMenuComponents.get(this.indexOfMenuComponentWithFocus);
        if (currMenuComponentWithFocus instanceof JColorSelectorPanel && (colorSelectionContainer = ((JColorSelectorPanel)currMenuComponentWithFocus).getColorSelectionContainer()) instanceof ColorSelectorPopupMenuMultiRowSelector && ((ColorSelectorPopupMenuMultiRowSelector)colorSelectionContainer).focusDown()) {
            return;
        }
        int currMenuComponentIndex = this.indexOfMenuComponentWithFocus + 1;
        while (currMenuComponentIndex <= popupMenuComponents.size() - 1) {
            Component currMenuComponent = popupMenuComponents.get(currMenuComponentIndex);
            if (currMenuComponent instanceof JSeparator) {
                ++currMenuComponentIndex;
                continue;
            }
            this.indexOfMenuComponentWithFocus = currMenuComponentIndex++;
            if (currMenuComponent instanceof JColorSelectorPanel) {
                JColorSelectorPanel colorSelectorPanel = (JColorSelectorPanel)currMenuComponent;
                JPanel colorSelectionContainer2 = colorSelectorPanel.getColorSelectionContainer();
                if (colorSelectionContainer2 instanceof ColorSelectorPopupMenuSingleRowSelector) {
                    ColorSelectorPopupMenuSingleRowSelector singleRowSelector = (ColorSelectorPopupMenuSingleRowSelector)colorSelectionContainer2;
                    int entryCount = singleRowSelector.getEntryCount();
                    if (entryCount == 0) continue;
                    this.columnOfFocusedColorSelector = Math.min(this.columnOfFocusedColorSelector, entryCount - 1);
                    singleRowSelector.focusOn(this.columnOfFocusedColorSelector);
                    break;
                }
                ((ColorSelectorPopupMenuMultiRowSelector)colorSelectionContainer2).focusOn(0, this.columnOfFocusedColorSelector);
                break;
            }
            currMenuComponent.requestFocus();
            this.menuItemsPanel.scrollToIfNecessary(currMenuComponent.getY(), currMenuComponent.getHeight());
            break;
        }
    }

    @Override
    public void focusUp() {
        JPanel colorSelectionContainer;
        if (this.indexOfMenuComponentWithFocus < 0) {
            this.focusLast();
            return;
        }
        List<Component> popupMenuComponents = this.popupMenu.getMenuComponents();
        Component currMenuComponentWithFocus = popupMenuComponents.get(this.indexOfMenuComponentWithFocus);
        if (currMenuComponentWithFocus instanceof JColorSelectorPanel && (colorSelectionContainer = ((JColorSelectorPanel)currMenuComponentWithFocus).getColorSelectionContainer()) instanceof ColorSelectorPopupMenuMultiRowSelector && ((ColorSelectorPopupMenuMultiRowSelector)colorSelectionContainer).focusUp()) {
            return;
        }
        int currMenuComponentIndex = this.indexOfMenuComponentWithFocus - 1;
        while (currMenuComponentIndex >= 0) {
            Component currMenuComponent = popupMenuComponents.get(currMenuComponentIndex);
            if (currMenuComponent instanceof JSeparator) {
                --currMenuComponentIndex;
                continue;
            }
            this.indexOfMenuComponentWithFocus = currMenuComponentIndex--;
            if (currMenuComponent instanceof JColorSelectorPanel) {
                JColorSelectorPanel colorSelectorPanel = (JColorSelectorPanel)currMenuComponent;
                JPanel colorSelectionContainer2 = colorSelectorPanel.getColorSelectionContainer();
                if (colorSelectionContainer2 instanceof ColorSelectorPopupMenuSingleRowSelector) {
                    ColorSelectorPopupMenuSingleRowSelector singleRowSelector = (ColorSelectorPopupMenuSingleRowSelector)colorSelectionContainer2;
                    int entryCount = singleRowSelector.getEntryCount();
                    if (entryCount == 0) continue;
                    this.columnOfFocusedColorSelector = Math.min(this.columnOfFocusedColorSelector, entryCount - 1);
                    singleRowSelector.focusOn(this.columnOfFocusedColorSelector);
                    break;
                }
                ColorSelectorPopupMenuMultiRowSelector multiRowSelector = (ColorSelectorPopupMenuMultiRowSelector)colorSelectionContainer2;
                multiRowSelector.focusOn(multiRowSelector.getRowCount() - 1, this.columnOfFocusedColorSelector);
                break;
            }
            currMenuComponent.requestFocus();
            this.menuItemsPanel.scrollToIfNecessary(currMenuComponent.getY(), currMenuComponent.getHeight());
            break;
        }
    }

    @Override
    public void focusLeft() {
        Component menuComponentWithFocus;
        if (this.indexOfMenuComponentWithFocus >= 0 && (menuComponentWithFocus = this.popupMenu.getMenuComponents().get(this.indexOfMenuComponentWithFocus)) instanceof JColorSelectorPanel) {
            this.columnOfFocusedColorSelector = Math.max(this.columnOfFocusedColorSelector - 1, 0);
            JColorSelectorPanel colorSelectorPanel = (JColorSelectorPanel)menuComponentWithFocus;
            JPanel colorSelectionContainer = colorSelectorPanel.getColorSelectionContainer();
            if (colorSelectionContainer instanceof ColorSelectorPopupMenuSingleRowSelector) {
                ColorSelectorPopupMenuSingleRowSelector singleRowSelector = (ColorSelectorPopupMenuSingleRowSelector)colorSelectionContainer;
                int entryCount = singleRowSelector.getEntryCount();
                this.columnOfFocusedColorSelector = Math.min(this.columnOfFocusedColorSelector, entryCount - 1);
                singleRowSelector.focusOn(this.columnOfFocusedColorSelector);
            } else {
                ((ColorSelectorPopupMenuMultiRowSelector)colorSelectionContainer).focusLeft();
            }
        }
    }

    @Override
    public void focusRight() {
        Component menuComponentWithFocus;
        if (this.indexOfMenuComponentWithFocus >= 0 && (menuComponentWithFocus = this.popupMenu.getMenuComponents().get(this.indexOfMenuComponentWithFocus)) instanceof JColorSelectorPanel) {
            int columnCount = ((ColorSelectorPopupMenuPresentationModel)((JColorSelectorPopupMenu)this.popupMenu).getProjection().getPresentationModel()).getColorColumns();
            this.columnOfFocusedColorSelector = Math.min(this.columnOfFocusedColorSelector + 1, columnCount - 1);
            JColorSelectorPanel colorSelectorPanel = (JColorSelectorPanel)menuComponentWithFocus;
            JPanel colorSelectionContainer = colorSelectorPanel.getColorSelectionContainer();
            if (colorSelectionContainer instanceof ColorSelectorPopupMenuSingleRowSelector) {
                ColorSelectorPopupMenuSingleRowSelector singleRowSelector = (ColorSelectorPopupMenuSingleRowSelector)colorSelectionContainer;
                int entryCount = singleRowSelector.getEntryCount();
                this.columnOfFocusedColorSelector = Math.min(this.columnOfFocusedColorSelector, entryCount - 1);
                singleRowSelector.focusOn(this.columnOfFocusedColorSelector);
            } else {
                ((ColorSelectorPopupMenuMultiRowSelector)colorSelectionContainer).focusRight();
            }
        }
    }
}

