/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;

public class CommandButtonLayoutManagerMedium
implements CommandButtonLayoutManager {
    @Override
    public int getPreferredIconSize(JCommandButton commandButton) {
        return FlamingoUtilities.getCommandButtonSmallIconSize(commandButton.getFont().getSize());
    }

    protected float getIconTextGapFactor() {
        return 1.0f;
    }

    private boolean hasIcon(JCommandButton button) {
        if (button.getIcon() != null) {
            return true;
        }
        return Boolean.TRUE.equals(button.getClientProperty("flamingo.internal.commandPopupMenu.forceIcon"));
    }

    @Override
    public Dimension getPreferredSize(JCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics((Font)commandButton.getFont());
        String buttonText = commandButton.getText();
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        boolean hasIcon = this.hasIcon(commandButton);
        boolean hasText = buttonText != null;
        boolean hasPopupIcon = FlamingoUtilities.hasPopupAction(commandButton);
        int prefIconSize = hasIcon ? this.getPreferredIconSize(commandButton) : 0;
        int width = borderInsets.left;
        if (hasIcon) {
            width += layoutHGap;
            width += prefIconSize;
            width += layoutHGap;
        }
        if (hasText) {
            width = hasIcon ? (width += (int)((float)layoutHGap * this.getIconTextGapFactor())) : (width += layoutHGap);
            width += fm.stringWidth(buttonText);
            width += layoutHGap;
        }
        if (hasPopupIcon) {
            if (hasText && hasIcon) {
                width += 2 * layoutHGap;
            }
            width += 1 + fm.getHeight() / 2;
            width += 2 * layoutHGap;
        }
        JCommandButton.CommandButtonKind buttonKind = commandButton.getCommandButtonKind();
        boolean hasSeparator = false;
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION && (hasIcon || hasText)) {
            hasSeparator = true;
        }
        if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP && hasIcon) {
            hasSeparator = true;
        }
        if (hasSeparator) {
            width += new JSeparator((int)1).getPreferredSize().width;
        }
        width += borderInsets.right;
        return new Dimension(width -= 2 * layoutHGap, by + Math.max(prefIconSize, fm.getAscent() + fm.getDescent()));
    }

    @Override
    public Point getActionKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        boolean hasIcon = this.hasIcon(commandButton);
        int height = commandButton.getHeight();
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            int x = hasIcon ? layoutInfo.iconRect.x + layoutInfo.iconRect.width : layoutInfo.actionClickArea.x + layoutInfo.actionClickArea.width;
            return new Point(x, (height + layoutInfo.actionClickArea.height) / 2);
        }
        int x = hasIcon ? layoutInfo.iconRect.x : layoutInfo.actionClickArea.x;
        return new Point(x, (height + layoutInfo.actionClickArea.height) / 2);
    }

    @Override
    public Point getPopupKeyTipAnchorCenterPoint(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = this.getLayoutInfo(commandButton);
        int height = commandButton.getHeight();
        if (commandButton.getComponentOrientation().isLeftToRight()) {
            return new Point(layoutInfo.popupClickArea.x + layoutInfo.popupClickArea.width, (height + layoutInfo.popupClickArea.height) / 2);
        }
        return new Point(layoutInfo.popupClickArea.x, (height + layoutInfo.popupClickArea.height) / 2);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(JCommandButton commandButton) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        String buttonText = commandButton.getText();
        int iconSize = this.getPreferredIconSize(commandButton);
        boolean hasIcon = this.hasIcon(commandButton);
        boolean hasText = buttonText != null;
        boolean hasPopupIcon = FlamingoUtilities.hasPopupAction(commandButton);
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        int prefWidth = this.getPreferredSize((JCommandButton)commandButton).width;
        int shiftX = 0;
        if (width > prefWidth) {
            switch (commandButton.getHorizontalAlignment()) {
                case 10: {
                    if (ltr) break;
                    shiftX = width - prefWidth;
                    break;
                }
                case 0: {
                    shiftX = (width - prefWidth) / 2;
                    break;
                }
                case 11: {
                    if (!ltr) break;
                    shiftX = width - prefWidth;
                }
            }
        }
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics((Font)commandButton.getFont());
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton.getCommandButtonKind();
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        if (ltr) {
            int x = ins.left + shiftX - layoutHGap;
            if (hasIcon) {
                result.iconRect.x = x += layoutHGap;
                result.iconRect.y = (height - iconSize) / 2;
                result.iconRect.width = iconSize;
                result.iconRect.height = iconSize;
                x += iconSize + layoutHGap;
            }
            if (hasText) {
                x = hasIcon ? (x += (int)((float)layoutHGap * this.getIconTextGapFactor())) : (x += layoutHGap);
                CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                lineLayoutInfo.text = commandButton.getText();
                lineLayoutInfo.textRect = new Rectangle();
                result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.textLayoutInfoList.add(lineLayoutInfo);
                lineLayoutInfo.textRect.x = x;
                lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
                lineLayoutInfo.textRect.width = fm.stringWidth(buttonText);
                lineLayoutInfo.textRect.height = labelHeight;
                x += lineLayoutInfo.textRect.width;
                x += layoutHGap;
            }
            if (hasPopupIcon) {
                if (hasText && hasIcon) {
                    x += 2 * layoutHGap;
                }
                if (!hasText && !hasIcon) {
                    x += (width - 2 * layoutHGap - 1 - labelHeight / 2) / 2;
                }
                result.popupActionRect.x = x;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.height = labelHeight + 2;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: {
                    if (hasText || hasIcon) {
                        result.popupActionRect.x += verticalSeparatorWidth;
                        xBorderBetweenActionAndPopup = result.popupActionRect.x - 2 * layoutHGap;
                        result.actionClickArea.x = 0;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = xBorderBetweenActionAndPopup;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        if (result.textLayoutInfoList != null) {
                            for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : result.textLayoutInfoList) {
                                textLayoutInfo.textRect.x += verticalSeparatorWidth;
                            }
                        }
                        result.popupActionRect.x += verticalSeparatorWidth;
                        xBorderBetweenActionAndPopup = result.iconRect.x + result.iconRect.width + layoutHGap;
                        result.actionClickArea.x = 0;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = xBorderBetweenActionAndPopup;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = false;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        } else {
            int x = width - ins.right - shiftX + layoutHGap;
            if (hasIcon) {
                result.iconRect.x = (x -= layoutHGap) - iconSize;
                result.iconRect.y = (height - iconSize) / 2;
                result.iconRect.width = iconSize;
                result.iconRect.height = iconSize;
                x -= iconSize + layoutHGap;
            }
            if (hasText) {
                x = hasIcon ? (x -= (int)((float)layoutHGap * this.getIconTextGapFactor())) : (x -= layoutHGap);
                CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                lineLayoutInfo.text = commandButton.getText();
                lineLayoutInfo.textRect = new Rectangle();
                result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.textLayoutInfoList.add(lineLayoutInfo);
                lineLayoutInfo.textRect.width = fm.stringWidth(buttonText);
                lineLayoutInfo.textRect.x = x - lineLayoutInfo.textRect.width;
                lineLayoutInfo.textRect.y = (height - labelHeight) / 2;
                lineLayoutInfo.textRect.height = labelHeight;
                x -= lineLayoutInfo.textRect.width;
                x -= layoutHGap;
            }
            if (hasPopupIcon) {
                if (hasText && hasIcon) {
                    x -= 2 * layoutHGap;
                }
                if (!hasText && !hasIcon) {
                    x -= (width - 2 * layoutHGap - 1 - labelHeight / 2) / 2;
                }
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.x = x - result.popupActionRect.width;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.height = labelHeight + 2;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: {
                    if (hasText || hasIcon) {
                        result.popupActionRect.x -= verticalSeparatorWidth;
                        result.actionClickArea.x = xBorderBetweenActionAndPopup = result.popupActionRect.x + result.popupActionRect.width + 2 * layoutHGap;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = 0;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        if (result.textLayoutInfoList != null) {
                            for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : result.textLayoutInfoList) {
                                textLayoutInfo.textRect.x -= verticalSeparatorWidth;
                            }
                        }
                        result.popupActionRect.x -= verticalSeparatorWidth;
                        result.actionClickArea.x = xBorderBetweenActionAndPopup = result.iconRect.x - layoutHGap;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = 0;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = false;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        }
        return result;
    }
}

