/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.pushingpixels.neon.api.AsynchronousLoading;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;

public class SubstanceDisabledResizableIcon
implements ResizableIcon {
    private LazyResettableHashMap<BufferedImage> cachedImages;
    private ResizableIcon delegate;

    public SubstanceDisabledResizableIcon(ResizableIcon delegate) {
        this.delegate = delegate;
        this.cachedImages = new LazyResettableHashMap("FlamingoSubstanceDisabledIcons @" + delegate.hashCode());
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        AsynchronousLoading asyncDelegate;
        if (this.delegate instanceof AsynchronousLoading && (asyncDelegate = (AsynchronousLoading)this.delegate).isLoading()) {
            return;
        }
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)c, (ComponentState)ComponentState.DISABLED_UNSELECTED);
        HashMapKey key = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{this.getIconWidth(), this.getIconHeight(), scheme.getDisplayName()});
        BufferedImage filtered = (BufferedImage)this.cachedImages.get(key);
        if (filtered == null) {
            BufferedImage offscreen = SubstanceCoreUtilities.getBlankImage((int)this.getIconWidth(), (int)this.getIconHeight());
            Graphics2D g2d = offscreen.createGraphics();
            this.delegate.paintIcon(c, (Graphics)g2d, 0, 0);
            g2d.dispose();
            filtered = SubstanceImageCreator.getColorSchemeImage((BufferedImage)offscreen, (SubstanceColorScheme)scheme, (float)0.5f);
            this.cachedImages.put(key, (Object)filtered);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.drawImage((Graphics)g2d, (Image)filtered, (int)0, (int)0);
        g2d.dispose();
    }
}

