/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.internal.substance.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.flamingo.internal.substance.utils.RibbonTaskToggleButtonBackgroundDelegate;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonTaskToggleButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceRibbonTaskToggleButtonUI
extends BasicRibbonTaskToggleButtonUI
implements TransitionAwareUI {
    private CommandButtonVisualStateTracker substanceVisualStateTracker;
    private PropertyChangeListener substancePropertyChangeListener;
    private RibbonTaskToggleButtonBackgroundDelegate delegate = new RibbonTaskToggleButtonBackgroundDelegate();

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceRibbonTaskToggleButtonUI();
    }

    private SubstanceRibbonTaskToggleButtonUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.commandButton.setOpaque(false);
        this.commandButton.setBorder(new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 12, 0, 12);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }
        });
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.commandButton, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.GENERAL);
        SubstanceCortex.ComponentOrParentChainScope.setColorizationFactor((JComponent)this.commandButton, (double)0.25);
    }

    @Override
    protected void uninstallComponents() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.commandButton);
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceVisualStateTracker = new CommandButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(this.commandButton);
        this.substancePropertyChangeListener = propertyChangeEvent -> {
            if ("contextualGroupHueColor".equals(propertyChangeEvent.getPropertyName())) {
                Color newValue = (Color)propertyChangeEvent.getNewValue();
                this.commandButton.setBackground(newValue);
            }
        };
        this.commandButton.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.substanceVisualStateTracker.uninstallListeners(this.commandButton);
        this.substanceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton);
        this.delegate.updateTaskToggleButtonBackground(g, (JRibbonTaskToggleButton)this.commandButton);
        this.paintTextAndFocus(g);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.commandButton.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }

    private void paintTextAndFocus(Graphics g) {
        int strWidth;
        FontMetrics fm = g.getFontMetrics();
        String toPaint = this.commandButton.getText();
        int fullInsets = this.commandButton.getInsets().left;
        int pw = this.getPreferredSize((JComponent)this.commandButton).width;
        int mw = this.getMinimumSize((JComponent)this.commandButton).width;
        int w = this.commandButton.getWidth();
        int h = this.commandButton.getHeight();
        int insets = fullInsets - (pw - w) * (fullInsets - 2) / (pw - mw);
        Rectangle textRect = new Rectangle(insets, 1 + (h - fm.getHeight()) / 2, w - 2 * insets, fm.getHeight());
        while (toPaint.length() != 0 && (strWidth = fm.stringWidth(toPaint)) > textRect.width) {
            toPaint = toPaint.substring(0, toPaint.length() - 1);
        }
        int finalStrWidth = fm.stringWidth(toPaint);
        if (finalStrWidth < textRect.width) {
            int delta = textRect.width - finalStrWidth;
            textRect.x += delta / 2;
            textRect.width -= delta;
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.substanceVisualStateTracker.getActionStateTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)currState);
        Color fgColor = SubstanceRibbonTaskToggleButtonUI.getForegroundColor(this.commandButton, modelStateInfo);
        if (buttonAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
            fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)buttonAlpha);
        }
        SubstanceTextUtilities.paintText((Graphics)g, (Rectangle)textRect, (String)toPaint, (int)-1, (Font)this.commandButton.getFont(), (Color)fgColor, null);
        float radius = RibbonTaskToggleButtonBackgroundDelegate.getTaskToggleButtonCornerRadius((JRibbonTaskToggleButton)this.commandButton);
        float focusRingPadding = SubstanceSizeUtils.getFocusRingPadding((int)SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton));
        Shape contour = SubstanceOutlineUtilities.getBaseOutline((float)this.commandButton.getWidth(), (float)this.commandButton.getHeight(), (float)radius, EnumSet.of(SubstanceSlices.Side.BOTTOM), (float)focusRingPadding);
        SubstanceCoreUtilities.paintFocus((Graphics)g, (Component)this.commandButton, (Component)this.commandButton, (TransitionAwareUI)this, (Shape)contour, (Rectangle)textRect, (Color)SubstanceColorUtilities.getAlphaColor((Color)fgColor, (int)192), (float)1.0f, (float)0.0f);
    }

    private static Color getForegroundColor(JCommandButton button, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        ComponentState currStateIgnoreSelection = ComponentState.getState((ButtonModel)button.getActionModel(), (JComponent)button, (boolean)true);
        ComponentState currState = ComponentState.getState((ButtonModel)button.getActionModel(), (JComponent)button, (boolean)false);
        Map activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        SubstanceColorScheme buttonFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)button, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.FILL, (ComponentState)currStateIgnoreSelection);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)button);
        SubstanceSlices.DecorationAreaType parentDecorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType((Component)button.getParent());
        SubstanceColorScheme parentFillScheme = skin.getBackgroundColorScheme(parentDecorationAreaType);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            SubstanceColorScheme schemeForCurrState = currState == ComponentState.ENABLED ? parentFillScheme : buttonFillScheme;
            return schemeForCurrState.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            float alpha = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
            boolean correspondsToParentFill = activeState == ComponentState.ENABLED && !button.getActionModel().isSelected();
            SubstanceColorScheme activeColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)button, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.FILL, (ComponentState)activeState);
            Color activeForeground = correspondsToParentFill ? parentFillScheme.getForegroundColor() : activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JCommandButton button = (JCommandButton)c;
        JButton forSizing = new JButton(button.getText(), (Icon)button.getIcon());
        Dimension result = forSizing.getUI().getPreferredSize(forSizing);
        Insets borderInsets = button.getBorder().getBorderInsets(button);
        result.width += borderInsets.left + borderInsets.right;
        result.height += borderInsets.top + borderInsets.bottom;
        return result;
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }
}

