/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.ribbon.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTaskbarKeyTipPolicy;
import org.pushingpixels.flamingo.internal.substance.common.TransitionAwareResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonLayoutManagerSmall;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;
import org.pushingpixels.substance.internal.utils.SubstancePopupContainer;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePaneUtilities;

public class SubstanceRibbonFrameTitlePane
extends SubstanceTitlePane {
    private static final double TASKBAR_WIDTH_MAX_RATIO = 0.25;
    private Map<RibbonContextualTaskGroup, SubstanceContextualGroupComponent> taskComponentMap = new HashMap<RibbonContextualTaskGroup, SubstanceContextualGroupComponent>();
    private ChangeListener ribbonFrameChangeListener;
    private TaskbarPanel taskbarPanel = new TaskbarPanel();

    public SubstanceRibbonFrameTitlePane(JRootPane root, SubstanceRootPaneUI ui) {
        super(root, ui);
        this.taskbarPanel.setComponentOrientation(root.getComponentOrientation());
        SubstanceTitlePaneUtilities.markTitlePaneExtraComponent((JComponent)this.taskbarPanel, (SubstanceTitlePaneUtilities.ExtraComponentKind)SubstanceTitlePaneUtilities.ExtraComponentKind.LEADING);
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.taskbarPanel, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.HEADER);
        this.add(this.taskbarPanel);
    }

    protected LayoutManager createLayout() {
        return new RibbonFrameTitlePaneLayout();
    }

    public void addNotify() {
        super.addNotify();
        JRibbon ribbon = this.getRibbon();
        this.syncRibbonState();
        this.ribbonFrameChangeListener = changeEvent -> {
            this.syncRibbonState();
            this.invalidate();
            this.revalidate();
            this.repaint();
        };
        ribbon.addChangeListener(this.ribbonFrameChangeListener);
    }

    public void removeNotify() {
        JRibbon ribbon = this.getRibbon();
        for (SubstanceContextualGroupComponent groupComp : this.taskComponentMap.values()) {
            this.remove(groupComp);
        }
        ribbon.removeChangeListener(this.ribbonFrameChangeListener);
        this.ribbonFrameChangeListener = null;
        super.removeNotify();
    }

    private void syncRibbonState() {
        for (SubstanceContextualGroupComponent groupComp : this.taskComponentMap.values()) {
            this.remove(groupComp);
        }
        this.taskComponentMap.clear();
        JRibbon ribbon = this.getRibbon();
        for (int i = 0; i < ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup group = ribbon.getContextualTaskGroup(i);
            if (!ribbon.isVisible(group)) continue;
            SubstanceContextualGroupComponent taskGroupComponent = new SubstanceContextualGroupComponent(group);
            taskGroupComponent.applyComponentOrientation(this.getRibbon().getComponentOrientation());
            this.add(taskGroupComponent);
            this.taskComponentMap.put(group, taskGroupComponent);
            SubstanceTitlePaneUtilities.markTitlePaneExtraComponent((JComponent)taskGroupComponent, (SubstanceTitlePaneUtilities.ExtraComponentKind)SubstanceTitlePaneUtilities.ExtraComponentKind.TRAILING);
        }
        this.taskbarPanel.removeAll();
        this.taskbarPanel.setPreferredSize(null);
    }

    public Container getTaskbarPanel() {
        return this.taskbarPanel;
    }

    private JRibbon getRibbon() {
        JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor((Component)((Object)this));
        return ribbonFrame.getRibbon();
    }

    private int getTaskBarLayoutGap(Container c) {
        return SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)c), (int)1, (int)6, (int)1, (boolean)false);
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int pw = 0;
            int gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(c);
            for (Component regComp : c.getComponents()) {
                if (!regComp.isVisible()) continue;
                pw += regComp.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, c.getParent().getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(c);
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            int x = ltr ? ins.left : c.getWidth() - ins.right;
            for (Component regComp : c.getComponents()) {
                if (!regComp.isVisible()) continue;
                int pw = regComp.getPreferredSize().width;
                if (ltr) {
                    regComp.setBounds(x, ins.top, pw, c.getHeight() - ins.top - ins.bottom);
                    x += pw + gap;
                    continue;
                }
                regComp.setBounds(x - pw, ins.top, pw, c.getHeight() - ins.top - ins.bottom);
                x -= pw + gap;
            }
        }
    }

    protected class RibbonFrameTitlePaneLayout
    extends SubstanceTitlePane.TitlePaneLayout {
        protected RibbonFrameTitlePaneLayout() {
            super((SubstanceTitlePane)SubstanceRibbonFrameTitlePane.this);
        }

        public void layoutContainer(Container c) {
            super.layoutContainer(c);
            JRibbon ribbon = SubstanceRibbonFrameTitlePane.this.getRibbon();
            boolean ltr = ribbon.getComponentOrientation().isLeftToRight();
            RibbonUI ribbonUI = ribbon.getUI();
            if (ltr) {
                for (Map.Entry entry : SubstanceRibbonFrameTitlePane.this.taskComponentMap.entrySet()) {
                    Rectangle taskGroupBounds = ribbonUI.getContextualTaskGroupBounds((RibbonContextualTaskGroup)entry.getKey());
                    int minTrailingX = c.getWidth();
                    for (int i = 0; i < c.getComponentCount(); ++i) {
                        SubstanceTitlePaneUtilities.ExtraComponentKind kind;
                        Component child = c.getComponent(i);
                        if (!child.isVisible() || !(child instanceof JComponent) || (kind = (SubstanceTitlePaneUtilities.ExtraComponentKind)((JComponent)child).getClientProperty("substancelaf.internal.titlePane.extraComponentKind")) == SubstanceTitlePaneUtilities.ExtraComponentKind.LEADING || child instanceof SubstanceContextualGroupComponent) continue;
                        minTrailingX = Math.min(child.getX(), minTrailingX);
                    }
                    int width = taskGroupBounds.width;
                    if (taskGroupBounds.x + width > minTrailingX - 5) {
                        width = minTrailingX - 5 - taskGroupBounds.x;
                    }
                    ((SubstanceContextualGroupComponent)entry.getValue()).setBounds(new Rectangle(taskGroupBounds.x, 0, width, c.getHeight()));
                    ((SubstanceContextualGroupComponent)entry.getValue()).setVisible(!ribbonUI.isShowingScrollsForTaskToggleButtons());
                }
                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setVisible(true);
                Dimension pref = SubstanceRibbonFrameTitlePane.this.taskbarPanel.getPreferredSize();
                int availableForTaskbarPanel = (int)(0.25 * (double)c.getBounds().width);
                if (pref.width <= availableForTaskbarPanel) {
                    SubstanceRibbonFrameTitlePane.this.taskbarPanel.showAll();
                } else {
                    SubstanceRibbonFrameTitlePane.this.taskbarPanel.showAsMuchAsPossible(availableForTaskbarPanel);
                    pref.width = availableForTaskbarPanel;
                }
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.getComponentCount() == 0) {
                    pref.width = 0;
                }
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                    if (pref.width == 0) {
                        SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() + SubstanceRibbonFrameTitlePane.this.menuBar.getWidth(), 0, pref.width, c.getHeight());
                    } else {
                        SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() + SubstanceRibbonFrameTitlePane.this.menuBar.getWidth() + 5, 0, pref.width, c.getHeight());
                    }
                    SubstanceRibbonFrameTitlePane.this.taskbarPanel.doLayout();
                }
            } else {
                for (Map.Entry entry : SubstanceRibbonFrameTitlePane.this.taskComponentMap.entrySet()) {
                    Rectangle taskGroupBounds = ribbonUI.getContextualTaskGroupBounds((RibbonContextualTaskGroup)entry.getKey());
                    int maxTrailingX = 0;
                    for (int i = 0; i < c.getComponentCount(); ++i) {
                        SubstanceTitlePaneUtilities.ExtraComponentKind kind;
                        Component child = c.getComponent(i);
                        if (!child.isVisible() || !(child instanceof JComponent) || (kind = (SubstanceTitlePaneUtilities.ExtraComponentKind)((JComponent)child).getClientProperty("substancelaf.internal.titlePane.extraComponentKind")) == SubstanceTitlePaneUtilities.ExtraComponentKind.LEADING || child instanceof SubstanceContextualGroupComponent) continue;
                        maxTrailingX = Math.max(child.getX() + child.getWidth(), maxTrailingX);
                    }
                    int width = taskGroupBounds.width;
                    int x = taskGroupBounds.x;
                    if (taskGroupBounds.x < maxTrailingX + 5) {
                        int diff = maxTrailingX + 5 - taskGroupBounds.x;
                        x += diff;
                        width -= diff;
                    }
                    ((SubstanceContextualGroupComponent)entry.getValue()).setBounds(new Rectangle(x, 0, width, c.getHeight()));
                    ((SubstanceContextualGroupComponent)entry.getValue()).setVisible(!ribbonUI.isShowingScrollsForTaskToggleButtons());
                }
                SubstanceRibbonFrameTitlePane.this.taskbarPanel.setVisible(true);
                Dimension pref = SubstanceRibbonFrameTitlePane.this.taskbarPanel.getPreferredSize();
                int availableForTaskbarPanel = (int)(0.25 * (double)c.getBounds().width);
                if (pref.width <= availableForTaskbarPanel) {
                    SubstanceRibbonFrameTitlePane.this.taskbarPanel.showAll();
                } else {
                    SubstanceRibbonFrameTitlePane.this.taskbarPanel.showAsMuchAsPossible(availableForTaskbarPanel);
                    pref.width = availableForTaskbarPanel;
                }
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.getComponentCount() == 0) {
                    pref.width = 0;
                }
                if (SubstanceRibbonFrameTitlePane.this.taskbarPanel.isVisible()) {
                    if (pref.width == 0) {
                        SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX(), 0, pref.width, c.getHeight());
                    } else {
                        SubstanceRibbonFrameTitlePane.this.taskbarPanel.setBounds(SubstanceRibbonFrameTitlePane.this.menuBar.getX() - 5 - pref.width, 0, pref.width, c.getHeight());
                    }
                    SubstanceRibbonFrameTitlePane.this.taskbarPanel.doLayout();
                }
            }
            SubstanceRibbonFrameTitlePane.this.menuBar.setVisible(true);
        }
    }

    private class TaskbarPanel
    extends JPanel {
        private TaskbarOverflowButton overflowButton;
        private List<Component> overflowComponents;

        private TaskbarPanel() {
            super(new TaskbarLayout());
            this.setFont(SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont());
            this.overflowComponents = new ArrayList<Component>();
            this.setOpaque(false);
            int insets = SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this), (int)2, (int)3, (int)1, (boolean)false);
            this.setBorder(new EmptyBorder(2, insets, 2, insets));
            int defaultIconSize = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)this.getFont().getSize());
            CommandButtonProjection<Command> overflowProjection = ((Command.Builder)Command.builder().setAction(commandActionEvent -> SwingUtilities.invokeLater(() -> this.showOverflowTaskbarContent(commandActionEvent.getButtonSource())))).build().project(CommandButtonPresentationModel.builder().setPresentationState(new CommandButtonPresentationState("overflow", defaultIconSize){

                @Override
                public CommandButtonLayoutManager createLayoutManager(JCommandButton commandButton) {
                    return new CommandButtonLayoutManagerTaskbarOverflow();
                }
            }).build());
            overflowProjection.setComponentCustomizer(button -> {
                int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)button);
                int arrowIconHeight = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
                int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
                TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon((JCommandButton)button, () -> ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker(), (scheme, width, height) -> SubstanceImageCreator.getDoubleArrowIcon((float)arrowIconWidth, (float)arrowIconHeight, (float)SubstanceSizeUtils.getSmallDoubleArrowGap((int)fontSize), (float)SubstanceSizeUtils.getDoubleArrowStrokeWidth((int)fontSize), (int)(this.getComponentOrientation().isLeftToRight() ? 3 : 7), (SubstanceColorScheme)scheme), new Dimension(arrowIconWidth, arrowIconHeight));
                button.setIcon(arrowIcon);
                button.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
                button.setCursor(Cursor.getPredefinedCursor(12));
                SubstanceCortex.ComponentScope.setButtonStraightSides((JComponent)button, EnumSet.allOf(SubstanceSlices.Side.class));
            });
            overflowProjection.setComponentSupplier(projection -> TaskbarOverflowButton::new);
            this.overflowButton = (TaskbarOverflowButton)overflowProjection.buildComponent();
        }

        @Override
        protected void paintComponent(Graphics g) {
        }

        @Override
        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            int pw = 0;
            int gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(this);
            for (Component component : SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                pw += component.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, this.getParent().getHeight());
        }

        private void showOverflowTaskbarContent(JCommandButton overflowButton) {
            int popupX;
            int gap;
            int overflowFullWidth = gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(this);
            for (Component overflow : this.overflowComponents) {
                overflowFullWidth += overflow.getPreferredSize().width + gap;
            }
            int ribbonWidth = SubstanceRibbonFrameTitlePane.this.getWidth();
            int popupWidth = Math.min(overflowFullWidth += 2 * gap, ribbonWidth);
            int overflowButtonX = overflowButton.getLocationOnScreen().x;
            int titlePaneX = SubstanceRibbonFrameTitlePane.this.getLocationOnScreen().x;
            int titlePaneY = SubstanceRibbonFrameTitlePane.this.getLocationOnScreen().y;
            int titlePaneHeight = SubstanceRibbonFrameTitlePane.this.getHeight();
            if (this.getComponentOrientation().isLeftToRight()) {
                if (overflowButtonX + popupWidth > titlePaneX + ribbonWidth) {
                    int delta = overflowButtonX + popupWidth - (titlePaneX + ribbonWidth);
                    popupX = overflowButtonX - delta;
                } else {
                    popupX = overflowButtonX;
                }
            } else {
                int overflowButtonWidth = overflowButton.getWidth();
                if (overflowButtonX + overflowButtonWidth - popupWidth < titlePaneX) {
                    int delta = titlePaneX - (overflowButtonX + overflowButtonWidth - popupWidth);
                    popupX = overflowButtonX + overflowButtonWidth - popupWidth + delta;
                } else {
                    popupX = overflowButtonX + overflowButtonWidth - popupWidth;
                }
            }
            TaskbarOverflowPopupPanel overflowPopupPanel = new TaskbarOverflowPopupPanel(this.overflowComponents, new Dimension(popupWidth, FlamingoUtilities.getTaskToggleButtonHeight(SubstanceRibbonFrameTitlePane.this.getRibbon())), overflowFullWidth > ribbonWidth);
            overflowPopupPanel.applyComponentOrientation(this.getComponentOrientation());
            Popup popup = PopupFactory.getSharedInstance().getPopup(overflowButton, overflowPopupPanel, popupX, titlePaneY + titlePaneHeight);
            PopupPanelManager.defaultManager().addPopup(overflowButton, popup, overflowPopupPanel);
        }

        private void showAsMuchAsPossible(int availableWidth) {
            this.removeAll();
            this.overflowComponents.clear();
            Insets ins = this.getInsets();
            int gap = SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(this);
            boolean isInOverflow = false;
            int pw = ins.left + ins.right + this.overflowButton.getPreferredSize().width + gap;
            for (Component component : SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                int componentWidth = component.getPreferredSize().width;
                if (!isInOverflow && pw + componentWidth + gap <= availableWidth) {
                    this.add(component);
                    pw += componentWidth + gap;
                    continue;
                }
                isInOverflow = true;
                this.overflowComponents.add(component);
            }
            this.add(this.overflowButton);
            this.overflowButton.setActionKeyTip(SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarKeyTipPolicy().getOverflowButtonKeyTip());
            this.updateKeyTips();
            this.revalidate();
        }

        private void showAll() {
            this.removeAll();
            this.overflowComponents.clear();
            for (Component component : SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents()) {
                this.add(component);
            }
            this.updateKeyTips();
            this.revalidate();
        }

        private void updateKeyTips() {
            RibbonTaskbarKeyTipPolicy policy = SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarKeyTipPolicy();
            List<Component> taskbarComponents = SubstanceRibbonFrameTitlePane.this.getRibbon().getTaskbarComponents();
            int index = 1;
            for (Component taskbarComp : taskbarComponents) {
                if (taskbarComp instanceof JCommandButton) {
                    JCommandButton button = (JCommandButton)taskbarComp;
                    switch (button.getCommandButtonKind()) {
                        case ACTION_ONLY: {
                            button.setActionKeyTip(policy.getContentKeyTip(index++));
                            break;
                        }
                        case ACTION_AND_POPUP_MAIN_ACTION: 
                        case ACTION_AND_POPUP_MAIN_POPUP: {
                            button.setActionKeyTip(policy.getContentKeyTip(index++));
                            button.setPopupKeyTip(policy.getContentKeyTip(index++));
                            break;
                        }
                        case POPUP_ONLY: {
                            button.setPopupKeyTip(policy.getContentKeyTip(index++));
                        }
                    }
                    continue;
                }
                if (!(taskbarComp instanceof JRibbonComponent)) continue;
                ((JRibbonComponent)taskbarComp).setKeyTip(policy.getContentKeyTip(index++));
            }
        }
    }

    public static class TaskbarOverflowButton
    extends JCommandButton {
        public TaskbarOverflowButton(Projection<JCommandButton, ? extends Command, CommandButtonPresentationModel> projection) {
            super(projection);
        }
    }

    @SubstancePopupContainer
    public class TaskbarOverflowPopupPanel
    extends JPopupPanel {
        private TaskbarOverflowPopupPanel(List<Component> overflowComponents, Dimension size, boolean hasScrolling) {
            this.setLayout(new BorderLayout());
            TaskbarOverflowPopupPanelContent overflowPanel = new TaskbarOverflowPopupPanelContent(new FlowLayout(1, SubstanceRibbonFrameTitlePane.this.getTaskBarLayoutGap(this), 0));
            for (Component overflow : overflowComponents) {
                overflowPanel.add(overflow);
            }
            if (hasScrolling) {
                this.add(new JScrollablePanel<TaskbarOverflowPopupPanelContent>(overflowPanel, JScrollablePanel.ScrollType.HORIZONTALLY), "Center");
            } else {
                this.add((Component)overflowPanel, "Center");
            }
            this.setPreferredSize(size);
            this.setSize(size);
            SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.HEADER);
        }
    }

    @SubstancePopupContainer
    private class TaskbarOverflowPopupPanelContent
    extends JPanel {
        public TaskbarOverflowPopupPanelContent(LayoutManager layout) {
            super(layout);
        }
    }

    private static class CommandButtonLayoutManagerTaskbarOverflow
    extends CommandButtonLayoutManagerSmall {
        private CommandButtonLayoutManagerTaskbarOverflow() {
        }

        @Override
        public int getPreferredIconSize(JCommandButton commandButton) {
            int fontSize = commandButton.getFont().getSize();
            int arrowIconHeight = (int)SubstanceSizeUtils.getSmallDoubleArrowIconHeight((int)fontSize);
            int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth((int)fontSize);
            return Math.max(arrowIconWidth, arrowIconHeight);
        }
    }

    private class SubstanceContextualGroupComponent
    extends JComponent {
        RibbonContextualTaskGroup taskGroup;

        private SubstanceContextualGroupComponent(RibbonContextualTaskGroup taskGroup) {
            this.taskGroup = taskGroup;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Color hueColor = this.taskGroup.getHueColor();
            Graphics2D g2d = (Graphics2D)g.create();
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor((Color)hueColor, (int)0), 0.0f, height, SubstanceColorUtilities.getAlphaColor((Color)hueColor, (int)63));
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width, height);
            g2d.setColor(hueColor);
            g2d.drawLine(1, height - 1, width, height - 1);
            JRibbon ribbon = SubstanceRibbonFrameTitlePane.this.getRibbon();
            SubstanceColorScheme scheme = SubstanceCoreUtilities.getSkin((Component)SubstanceRibbonFrameTitlePane.this.rootPane).getEnabledColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE);
            FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics((Font)ribbon.getFont());
            int yOffset = (height - fm.getHeight()) / 2;
            NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)ribbon.getFont());
            int offset = SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this), (int)5, (int)2, (int)1, (boolean)false);
            if (this.getComponentOrientation().isLeftToRight()) {
                SubstanceTextUtilities.paintText((Graphics)g2d, (Rectangle)new Rectangle(offset, yOffset, width, height - yOffset), (String)this.taskGroup.getTitle(), (int)-1, (Font)ribbon.getFont(), (Color)SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)scheme), null);
            } else {
                SubstanceTextUtilities.paintText((Graphics)g2d, (Rectangle)new Rectangle(width - offset - g2d.getFontMetrics().stringWidth(this.taskGroup.getTitle()), yOffset, width, height - yOffset), (String)this.taskGroup.getTitle(), (int)-1, (Font)ribbon.getFont(), (Color)SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)scheme), null);
            }
            SeparatorPainterUtils.paintSeparator((Component)ribbon, (Graphics)g2d, (int)2, (int)height, (int)1, (boolean)false, (int)(height / 3), (int)0, (boolean)true);
            g2d.translate(width - 1, 0);
            SeparatorPainterUtils.paintSeparator((Component)ribbon, (Graphics)g2d, (int)2, (int)height, (int)1, (boolean)false, (int)(height / 3), (int)0, (boolean)true);
            g2d.dispose();
        }
    }
}

