/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.popup.AbstractPopupMenu;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonLayoutManagerMedium;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicCommandPopupMenuUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstancePopupContainer;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenuBackgroundDelegate;

public class SubstanceCommandPopupMenuUI
extends BasicCommandPopupMenuUI {
    private DecorationPainterUtils.PopupInvokerLink popupInvokerLink;

    public static ComponentUI createUI(JComponent c) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)c);
        return new SubstanceCommandPopupMenuUI();
    }

    private SubstanceCommandPopupMenuUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.popupInvokerLink = ((AbstractPopupMenu)c)::getInvoker;
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.popupMenu.putClientProperty("substancelaf.internal.popupInvokerLink", this.popupInvokerLink);
    }

    @Override
    protected void uninstallDefaults() {
        this.popupMenu.putClientProperty("substancelaf.internal.popupInvokerLink", null);
        super.uninstallDefaults();
    }

    @Override
    protected JPanel createMenuPanel() {
        SubstanceMenuPanel result = new SubstanceMenuPanel();
        result.putClientProperty("substancelaf.internal.popupInvokerLink", this.popupInvokerLink);
        return result;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.update((Graphics)g, (JComponent)c, (boolean)false);
    }

    @SubstancePopupContainer
    protected class SubstanceMenuPanel
    extends BasicCommandPopupMenuUI.MenuPanel {
        protected SubstanceMenuPanel() {
        }

        @Override
        protected void paintIconGutterBackground(Graphics g) {
            List<Component> menuComponents = SubstanceCommandPopupMenuUI.this.popupMenu.getMenuComponents();
            if (menuComponents != null) {
                for (Component menuComponent : menuComponents) {
                    JCommandButton menuButton;
                    if (!(menuComponent instanceof JCommandButton) || (menuButton = (JCommandButton)menuComponent).getUI().getLayoutManager() instanceof CommandButtonLayoutManagerMedium) continue;
                    return;
                }
            }
            Graphics2D g2d = (Graphics2D)g.create();
            SubstanceSlices.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
            if (fillKind != SubstanceSlices.MenuGutterFillKind.NONE) {
                SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this, (ComponentState)ComponentState.ENABLED);
                Color extraLight = SubstanceMenuBackgroundDelegate.getGutterHardFillColor((SubstanceColorScheme)scheme);
                Color ultraLight = SubstanceMenuBackgroundDelegate.getGutterSoftFillColor((SubstanceColorScheme)scheme);
                Color leftColor = fillKind == SubstanceSlices.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceSlices.MenuGutterFillKind.HARD ? ultraLight : extraLight;
                Color rightColor = fillKind == SubstanceSlices.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceSlices.MenuGutterFillKind.SOFT ? ultraLight : extraLight;
                g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this, (float)0.7f, (Graphics)g));
                int sepX = this.getSeparatorX();
                if (this.getComponentOrientation().isLeftToRight()) {
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, leftColor, sepX + 2, 0.0f, rightColor);
                    g2d.setPaint(gp);
                    g2d.fillRect(0, 0, sepX, this.getHeight());
                } else {
                    GradientPaint gp = new GradientPaint(sepX, 0.0f, leftColor, this.getWidth(), 0.0f, rightColor);
                    g2d.setPaint(gp);
                    g2d.fillRect(sepX + 2, 0, this.getWidth() - sepX, this.getHeight());
                }
            }
            g2d.dispose();
        }
    }
}

