/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicColorSelectorPanelUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceColorSelectorPanelUI
extends BasicColorSelectorPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceColorSelectorPanelUI();
    }

    private SubstanceColorSelectorPanelUI() {
    }

    @Override
    protected void paintCaptionBackground(Graphics g, int x, int y, int width, int height) {
        SubstanceColorScheme bgFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.colorSelectorPanel, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)ComponentState.ENABLED);
        SubstanceCoreUtilities.getFillPainter((Component)this.colorSelectorPanel).paintContourBackground(g, (Component)this.colorSelectorPanel, (float)width, (float)height, (Shape)new Rectangle(x, y, width, height), false, bgFillScheme, false);
        Color borderColor = SubstanceCoreUtilities.getSkin((Component)this.colorSelectorPanel).getOverlayColor(SubstanceSlices.ColorOverlayType.LINE, DecorationPainterUtils.getDecorationType((Component)this.colorSelectorPanel), ComponentState.ENABLED);
        if (borderColor == null) {
            SubstanceColorScheme bgBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.colorSelectorPanel, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)ComponentState.ENABLED);
            borderColor = bgBorderScheme.getLineColor();
        }
        float lineThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setStroke(new BasicStroke(lineThickness));
        g2d.setColor(borderColor);
        g2d.draw(new Line2D.Float(x, y, x + width, y));
        float bottomLineY = (float)(y + height) - lineThickness;
        g2d.draw(new Line2D.Float(x, bottomLineY, x + width, bottomLineY));
        g2d.dispose();
    }

    @Override
    protected void paintBottomDivider(Graphics g, int x, int y, int width, int height) {
        Color borderColor = SubstanceCoreUtilities.getSkin((Component)this.colorSelectorPanel).getOverlayColor(SubstanceSlices.ColorOverlayType.LINE, DecorationPainterUtils.getDecorationType((Component)this.colorSelectorPanel), ComponentState.ENABLED);
        if (borderColor == null) {
            SubstanceColorScheme bgBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.colorSelectorPanel, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)ComponentState.ENABLED);
            borderColor = bgBorderScheme.getLineColor();
        }
        float lineThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setStroke(new BasicStroke(lineThickness));
        g2d.setColor(borderColor);
        float lineY = (float)(y + height) - lineThickness;
        g2d.draw(new Line2D.Float(x, lineY, x + width, lineY));
        g2d.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque((Graphics)g, (JComponent)c);
        this.paint(g, c);
    }

    @Override
    protected int getLayoutGap() {
        return (int)SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this.colorSelectorPanel), (float)4.0f, (int)1, (float)0.25f);
    }
}

