/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon.synapse.model;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.ribbon.synapse.model.ComponentContentModel;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class RibbonCheckBoxContentModel
implements ComponentContentModel {
    private boolean isEnabled;
    private ResizableIcon.Factory iconFactory;
    private String caption;
    private RichTooltip richTooltip;
    private ActionListener actionListener;
    private String text;
    private boolean isSelected;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static Builder builder() {
        return new Builder();
    }

    private RibbonCheckBoxContentModel() {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public String getText() {
        return this.text;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected != selected) {
            this.isSelected = selected;
            this.pcs.firePropertyChange("selected", !this.isSelected, this.isSelected);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.pcs.firePropertyChange("enabled", !this.isEnabled, this.isEnabled);
        }
    }

    @Override
    public ResizableIcon.Factory getIconFactory() {
        return this.iconFactory;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public RichTooltip getRichTooltip() {
        return this.richTooltip;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public static class Builder {
        private boolean isEnabled = true;
        private ResizableIcon.Factory iconFactory;
        private String caption;
        private RichTooltip richTooltip;
        private String text;
        private boolean isSelected;
        private ActionListener actionListener;

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setSelected(boolean selected) {
            this.isSelected = selected;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder setIconFactory(ResizableIcon.Factory iconFactory) {
            this.iconFactory = iconFactory;
            return this;
        }

        public Builder setCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder setRichTooltip(RichTooltip richTooltip) {
            this.richTooltip = richTooltip;
            return this;
        }

        public Builder setActionListener(ActionListener actionListener) {
            this.actionListener = actionListener;
            return this;
        }

        public RibbonCheckBoxContentModel build() {
            RibbonCheckBoxContentModel model = new RibbonCheckBoxContentModel();
            model.text = this.text;
            model.isSelected = this.isSelected;
            model.actionListener = this.actionListener;
            model.isEnabled = this.isEnabled;
            model.iconFactory = this.iconFactory;
            model.caption = this.caption;
            model.richTooltip = this.richTooltip;
            return model;
        }
    }
}

