/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.Color;
import java.util.ArrayList;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class RibbonContextualTaskGroup {
    private JRibbon ribbon;
    private ArrayList<RibbonTask> tasks;
    private String title;
    private Color hueColor;
    public static final double HUE_ALPHA = 0.25;

    public RibbonContextualTaskGroup(String title, Color hueColor, RibbonTask ... tasks) {
        this.title = title;
        this.hueColor = hueColor;
        this.tasks = new ArrayList();
        for (RibbonTask ribbonTask : tasks) {
            ribbonTask.setContextualGroup(this);
            this.tasks.add(ribbonTask);
        }
    }

    public RibbonContextualTaskGroup(String title, Color hueColor, Iterable<RibbonTask> tasks) {
        this.title = title;
        this.hueColor = hueColor;
        this.tasks = new ArrayList();
        for (RibbonTask ribbonTask : tasks) {
            ribbonTask.setContextualGroup(this);
            this.tasks.add(ribbonTask);
        }
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public RibbonTask getTask(int index) {
        return this.tasks.get(index);
    }

    public String getTitle() {
        return this.title;
    }

    public Color getHueColor() {
        return this.hueColor;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.ribbon != null) {
            this.ribbon.fireStateChanged();
        }
    }

    public String toString() {
        return this.getTitle() + " (" + this.getTaskCount() + " tasks)";
    }

    void setRibbon(JRibbon ribbon) {
        if (this.ribbon != null) {
            throw new IllegalStateException("The contextual task group already belongs to another ribbon");
        }
        this.ribbon = ribbon;
    }
}

