/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup;

import java.util.List;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelContentModel;
import org.pushingpixels.flamingo.api.common.popup.AbstractPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.CommandPanelProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.ScrollableHost;
import org.pushingpixels.substance.internal.utils.SubstancePopupContainer;

@SubstancePopupContainer
public class JCommandPopupMenu
extends AbstractPopupMenu
implements ScrollableHost {
    public static final String uiClassID = "CommandPopupMenuUI";
    private Projection<JCommandPopupMenu, CommandMenuContentModel, CommandPopupMenuPresentationModel> projection;
    private CommandMenuContentModel popupMenuContentModel;
    private CommandPopupMenuPresentationModel popupMenuPresentationModel;
    private CommandPanelContentModel popupMenuPanelContentModel;
    private ChangeListener popupMenuPanelContentChangeListener;
    private JCommandButtonPanel mainButtonPanel;

    public JCommandPopupMenu(Projection<JCommandPopupMenu, CommandMenuContentModel, CommandPopupMenuPresentationModel> projection) {
        this.projection = projection;
        this.popupMenuContentModel = (CommandMenuContentModel)projection.getContentModel();
        this.popupMenuPresentationModel = (CommandPopupMenuPresentationModel)projection.getPresentationModel();
        this.popupMenuPanelContentModel = this.popupMenuContentModel != null ? this.popupMenuContentModel.getPanelContentModel() : null;
        this.populateContent();
        this.popupMenuPanelContentChangeListener = event -> this.populateContent();
        this.popupMenuContentModel.addChangeListener(this.popupMenuPanelContentChangeListener);
        this.updateUI();
    }

    private void populateContent() {
        if (this.popupMenuPanelContentModel != null) {
            this.mainButtonPanel = (JCommandButtonPanel)new CommandPanelProjection(this.popupMenuPanelContentModel, this.popupMenuPresentationModel.getPanelPresentationModel()).buildComponent();
        }
        CommandButtonPresentationModel presentation = CommandButtonPresentationModel.builder().setPresentationState(this.popupMenuPresentationModel.getMenuPresentationState()).setMenu(true).build();
        List<CommandGroup> commandGroups = this.popupMenuContentModel.getCommandGroups();
        for (int i = 0; i < commandGroups.size(); ++i) {
            for (Command command : commandGroups.get(i).getCommands()) {
                CommandButtonPresentationModel.Overlay overlay = this.projection.getCommandOverlays().get(command);
                CommandButtonProjection<Command> commandProjection = overlay != null ? command.project(presentation.overlayWith(overlay)) : command.project(presentation);
                JCommandButton commandButton = (JCommandButton)commandProjection.buildComponent();
                Command highlightedCommand = this.popupMenuContentModel.getHighlightedCommand();
                if (command == highlightedCommand) {
                    commandButton.setFont(commandButton.getFont().deriveFont(1));
                }
                commandButton.setPopupOrientationKind(this.popupMenuPresentationModel.getPopupOrientationKind());
                this.addMenuButton(commandButton);
            }
            if (i >= commandGroups.size() - 1) continue;
            this.addMenuSeparator();
        }
    }

    public Projection<JCommandPopupMenu, CommandMenuContentModel, CommandPopupMenuPresentationModel> getProjection() {
        return this.projection;
    }

    public boolean hasCommandButtonPanel() {
        return this.mainButtonPanel != null;
    }

    public JCommandButtonPanel getMainButtonPanel() {
        return this.mainButtonPanel;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceCommandPopupMenuUI.createUI(this));
    }
}

