/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.model;

import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.model.ImmutablePresentationModel;
import org.pushingpixels.flamingo.api.common.popup.model.AbstractPopupMenuPresentationModel;

public class CommandButtonPresentationModel
implements ImmutablePresentationModel {
    public static final int DEFAULT_AUTO_REPEAT_INITIAL_INTERVAL_MS = 500;
    public static final int DEFAULT_AUTO_REPEAT_SUBSEQUENT_INTERVAL_MS = 100;
    private CommandButtonPresentationState presentationState;
    private Integer iconDimension;
    private boolean isFlat;
    private boolean isFocusable;
    private int horizontalAlignment;
    private double horizontalGapScaleFactor;
    private double verticalGapScaleFactor;
    private boolean isMenu;
    private PopupOrientationKind popupOrientationKind;
    private PopupHorizontalGravity popupHorizontalGravity;
    private String actionKeyTip;
    private String popupKeyTip;
    private boolean toDismissPopupsOnActivation;
    private AbstractPopupMenuPresentationModel popupMenuPresentationModel;
    private boolean isTextClickAction;
    private boolean isTextClickPopup;
    private boolean isAutoRepeatAction;
    private boolean hasAutoRepeatIntervalsSet;
    private int autoRepeatInitialInterval;
    private int autoRepeatSubsequentInterval;
    private boolean isFireActionOnRollover;
    private boolean isFireActionOnPress;

    private CommandButtonPresentationModel() {
    }

    public CommandButtonPresentationModel overlayWith(Overlay overlay) {
        CommandButtonPresentationModel result = new CommandButtonPresentationModel();
        result.presentationState = overlay.presentationState != null ? overlay.presentationState : this.presentationState;
        result.isFlat = overlay.isFlat != null ? overlay.isFlat : this.isFlat;
        result.isFocusable = overlay.isFocusable != null ? overlay.isFocusable : this.isFocusable;
        result.horizontalAlignment = overlay.horizontalAlignment != null ? overlay.horizontalAlignment : this.horizontalAlignment;
        result.horizontalGapScaleFactor = overlay.horizontalGapScaleFactor != null ? overlay.horizontalGapScaleFactor : this.horizontalGapScaleFactor;
        result.verticalGapScaleFactor = overlay.verticalGapScaleFactor != null ? overlay.verticalGapScaleFactor : this.verticalGapScaleFactor;
        result.iconDimension = overlay.iconDimension != null ? overlay.iconDimension : this.iconDimension;
        result.isMenu = overlay.isMenu != null ? overlay.isMenu : this.isMenu;
        result.popupOrientationKind = overlay.popupOrientationKind != null ? overlay.popupOrientationKind : this.popupOrientationKind;
        result.popupHorizontalGravity = overlay.popupHorizontalGravity != null ? overlay.popupHorizontalGravity : this.popupHorizontalGravity;
        result.toDismissPopupsOnActivation = overlay.toDismissPopupsOnActivation != null ? overlay.toDismissPopupsOnActivation : this.toDismissPopupsOnActivation;
        result.popupMenuPresentationModel = overlay.popupMenuPresentationModel != null ? overlay.popupMenuPresentationModel : this.popupMenuPresentationModel;
        result.actionKeyTip = overlay.actionKeyTip != null ? overlay.actionKeyTip : this.actionKeyTip;
        result.popupKeyTip = overlay.popupKeyTip != null ? overlay.popupKeyTip : this.popupKeyTip;
        result.isTextClickAction = overlay.isTextClickAction != null ? overlay.isTextClickAction : this.isTextClickAction;
        result.isTextClickPopup = overlay.isTextClickPopup != null ? overlay.isTextClickPopup : this.isTextClickPopup;
        result.isAutoRepeatAction = overlay.isAutoRepeatAction != null ? overlay.isAutoRepeatAction : this.isAutoRepeatAction;
        result.hasAutoRepeatIntervalsSet = overlay.hasAutoRepeatIntervalsSet != null ? overlay.hasAutoRepeatIntervalsSet : this.hasAutoRepeatIntervalsSet;
        result.autoRepeatInitialInterval = overlay.autoRepeatInitialInterval != null ? overlay.autoRepeatInitialInterval : this.autoRepeatInitialInterval;
        result.autoRepeatSubsequentInterval = overlay.autoRepeatSubsequentInterval != null ? overlay.autoRepeatSubsequentInterval : this.autoRepeatSubsequentInterval;
        result.isFireActionOnRollover = overlay.isFireActionOnRollover != null ? overlay.isFireActionOnRollover : this.isFireActionOnRollover;
        result.isFireActionOnPress = overlay.isFireActionOnPress != null ? overlay.isFireActionOnPress : this.isFireActionOnPress;
        return result;
    }

    public static CommandButtonPresentationModel withDefaults() {
        return CommandButtonPresentationModel.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Overlay overlay() {
        return new Overlay();
    }

    public CommandButtonPresentationState getPresentationState() {
        return this.presentationState;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public boolean isFocusable() {
        return this.isFocusable;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public double getHorizontalGapScaleFactor() {
        return this.horizontalGapScaleFactor;
    }

    public double getVerticalGapScaleFactor() {
        return this.verticalGapScaleFactor;
    }

    public Integer getIconDimension() {
        return this.iconDimension;
    }

    public PopupOrientationKind getPopupOrientationKind() {
        return this.popupOrientationKind;
    }

    public PopupHorizontalGravity getPopupHorizontalGravity() {
        return this.popupHorizontalGravity;
    }

    public boolean isMenu() {
        return this.isMenu;
    }

    public boolean isToDismissPopupsOnActivation() {
        return this.toDismissPopupsOnActivation;
    }

    public AbstractPopupMenuPresentationModel getPopupMenuPresentationModel() {
        return this.popupMenuPresentationModel;
    }

    public String getActionKeyTip() {
        return this.actionKeyTip;
    }

    public String getPopupKeyTip() {
        return this.popupKeyTip;
    }

    public boolean isTextClickAction() {
        return this.isTextClickAction;
    }

    public boolean isTextClickPopup() {
        return this.isTextClickPopup;
    }

    public boolean isFireActionOnRollover() {
        return this.isFireActionOnRollover;
    }

    public boolean isFireActionOnPress() {
        return this.isFireActionOnPress;
    }

    public boolean isAutoRepeatAction() {
        return this.isAutoRepeatAction;
    }

    public boolean hasAutoRepeatIntervalsSet() {
        return this.hasAutoRepeatIntervalsSet;
    }

    public int getAutoRepeatInitialInterval() {
        return this.hasAutoRepeatIntervalsSet ? this.autoRepeatInitialInterval : -1;
    }

    public int getAutoRepeatSubsequentInterval() {
        return this.hasAutoRepeatIntervalsSet ? this.autoRepeatSubsequentInterval : -1;
    }

    public static class Builder {
        private CommandButtonPresentationState presentationState = CommandButtonPresentationState.FIT_TO_ICON;
        private boolean isFlat = true;
        private boolean isFocusable = true;
        private int horizontalAlignment = 0;
        private double horizontalGapScaleFactor = 1.0;
        private double verticalGapScaleFactor = 1.0;
        private Integer iconDimension;
        private boolean isMenu = false;
        private PopupOrientationKind popupOrientationKind = PopupOrientationKind.DOWNWARD;
        private PopupHorizontalGravity popupHorizontalGravity = PopupHorizontalGravity.START;
        private String actionKeyTip;
        private String popupKeyTip;
        private boolean toDismissPopupsOnActivation = true;
        private AbstractPopupMenuPresentationModel popupMenuPresentationModel;
        private boolean isTextClickAction;
        private boolean isTextClickPopup;
        private boolean isAutoRepeatAction;
        private boolean hasAutoRepeatIntervalsSet;
        private int autoRepeatInitialInterval = 500;
        private int autoRepeatSubsequentInterval = 100;
        private boolean isFireActionOnRollover;
        private boolean isFireActionOnPress;

        public Builder setFlat(boolean flat) {
            this.isFlat = flat;
            return this;
        }

        public Builder setFocusable(boolean focusable) {
            this.isFocusable = focusable;
            return this;
        }

        public Builder setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Builder setHorizontalGapScaleFactor(double horizontalGapScaleFactor) {
            this.horizontalGapScaleFactor = horizontalGapScaleFactor;
            return this;
        }

        public Builder setVerticalGapScaleFactor(double verticalGapScaleFactor) {
            this.verticalGapScaleFactor = verticalGapScaleFactor;
            return this;
        }

        public Builder setPresentationState(CommandButtonPresentationState presentationState) {
            this.presentationState = presentationState;
            return this;
        }

        public Builder setIconDimension(Integer iconDimension) {
            this.iconDimension = iconDimension;
            return this;
        }

        public Builder setPopupOrientationKind(PopupOrientationKind popupOrientationKind) {
            this.popupOrientationKind = popupOrientationKind;
            return this;
        }

        public Builder setPopupHorizontalGravity(PopupHorizontalGravity popupHorizontalGravity) {
            this.popupHorizontalGravity = popupHorizontalGravity;
            return this;
        }

        public Builder setMenu(boolean isMenu) {
            this.isMenu = isMenu;
            return this;
        }

        public Builder setToDismissPopupsOnActivation(boolean toDismissPopupsOnActivation) {
            this.toDismissPopupsOnActivation = toDismissPopupsOnActivation;
            return this;
        }

        public Builder setPopupMenuPresentationModel(AbstractPopupMenuPresentationModel popupMenuPresentationModel) {
            this.popupMenuPresentationModel = popupMenuPresentationModel;
            return this;
        }

        public Builder setActionKeyTip(String actionKeyTip) {
            this.actionKeyTip = actionKeyTip;
            return this;
        }

        public Builder setPopupKeyTip(String popupKeyTip) {
            this.popupKeyTip = popupKeyTip;
            return this;
        }

        public Builder setTextClickAction() {
            this.isTextClickAction = true;
            return this;
        }

        public Builder setTextClickPopup() {
            this.isTextClickPopup = true;
            return this;
        }

        public Builder setAutoRepeatAction(boolean isAutoRepeatAction) {
            this.isAutoRepeatAction = isAutoRepeatAction;
            return this;
        }

        public Builder setAutoRepeatActionIntervals(int initial, int subsequent) {
            this.hasAutoRepeatIntervalsSet = true;
            this.autoRepeatInitialInterval = initial;
            this.autoRepeatSubsequentInterval = subsequent;
            return this;
        }

        public Builder setFireActionOnRollover(boolean isFireActionOnRollover) {
            this.isFireActionOnRollover = isFireActionOnRollover;
            return this;
        }

        public Builder setFireActionOnPress(boolean isFireActionOnPress) {
            this.isFireActionOnPress = isFireActionOnPress;
            return this;
        }

        public CommandButtonPresentationModel build() {
            CommandButtonPresentationModel commandPresentation = new CommandButtonPresentationModel();
            commandPresentation.presentationState = this.presentationState;
            commandPresentation.horizontalAlignment = this.horizontalAlignment;
            commandPresentation.horizontalGapScaleFactor = this.horizontalGapScaleFactor;
            commandPresentation.verticalGapScaleFactor = this.verticalGapScaleFactor;
            commandPresentation.isFlat = this.isFlat;
            commandPresentation.isFocusable = this.isFocusable;
            commandPresentation.iconDimension = this.iconDimension;
            commandPresentation.isMenu = this.isMenu;
            commandPresentation.popupOrientationKind = this.popupOrientationKind;
            commandPresentation.popupHorizontalGravity = this.popupHorizontalGravity;
            commandPresentation.actionKeyTip = this.actionKeyTip;
            commandPresentation.popupKeyTip = this.popupKeyTip;
            commandPresentation.toDismissPopupsOnActivation = this.toDismissPopupsOnActivation;
            commandPresentation.popupMenuPresentationModel = this.popupMenuPresentationModel;
            commandPresentation.isTextClickAction = this.isTextClickAction;
            commandPresentation.isTextClickPopup = this.isTextClickPopup;
            commandPresentation.isAutoRepeatAction = this.isAutoRepeatAction;
            commandPresentation.hasAutoRepeatIntervalsSet = this.hasAutoRepeatIntervalsSet;
            commandPresentation.autoRepeatInitialInterval = this.autoRepeatInitialInterval;
            commandPresentation.autoRepeatSubsequentInterval = this.autoRepeatSubsequentInterval;
            commandPresentation.isFireActionOnRollover = this.isFireActionOnRollover;
            commandPresentation.isFireActionOnPress = this.isFireActionOnPress;
            return commandPresentation;
        }
    }

    public static class Overlay {
        private CommandButtonPresentationState presentationState;
        private Boolean isFlat;
        private Boolean isFocusable;
        private Integer horizontalAlignment;
        private Double horizontalGapScaleFactor;
        private Double verticalGapScaleFactor;
        private Integer iconDimension;
        private Boolean isMenu;
        private PopupOrientationKind popupOrientationKind;
        private PopupHorizontalGravity popupHorizontalGravity;
        private Boolean toDismissPopupsOnActivation;
        private String actionKeyTip;
        private String popupKeyTip;
        private AbstractPopupMenuPresentationModel popupMenuPresentationModel;
        private Boolean isTextClickAction;
        private Boolean isTextClickPopup;
        private Boolean isAutoRepeatAction;
        private Boolean hasAutoRepeatIntervalsSet;
        private Integer autoRepeatInitialInterval;
        private Integer autoRepeatSubsequentInterval;
        private Boolean isFireActionOnRollover;
        private Boolean isFireActionOnPress;

        public Overlay setFlat(boolean flat) {
            this.isFlat = flat;
            return this;
        }

        public Overlay setFocusable(boolean focusable) {
            this.isFocusable = focusable;
            return this;
        }

        public Overlay setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
            return this;
        }

        public Overlay setHorizontalGapScaleFactor(double horizontalGapScaleFactor) {
            this.horizontalGapScaleFactor = horizontalGapScaleFactor;
            return this;
        }

        public Overlay setVerticalGapScaleFactor(double verticalGapScaleFactor) {
            this.verticalGapScaleFactor = verticalGapScaleFactor;
            return this;
        }

        public Overlay setPresentationState(CommandButtonPresentationState presentationState) {
            this.presentationState = presentationState;
            return this;
        }

        public Overlay setIconDimension(Integer iconDimension) {
            this.iconDimension = iconDimension;
            return this;
        }

        public Overlay setPopupOrientationKind(PopupOrientationKind popupOrientationKind) {
            this.popupOrientationKind = popupOrientationKind;
            return this;
        }

        public Overlay setPopupHorizontalGravity(PopupHorizontalGravity popupHorizontalGravity) {
            this.popupHorizontalGravity = popupHorizontalGravity;
            return this;
        }

        public Overlay setMenu(boolean isMenu) {
            this.isMenu = isMenu;
            return this;
        }

        public Overlay setToDismissPopupsOnActivation(boolean toDismissPopupsOnActivation) {
            this.toDismissPopupsOnActivation = toDismissPopupsOnActivation;
            return this;
        }

        public Overlay setPopupMenuPresentationModel(AbstractPopupMenuPresentationModel popupMenuPresentationModel) {
            this.popupMenuPresentationModel = popupMenuPresentationModel;
            return this;
        }

        public Overlay setActionKeyTip(String actionKeyTip) {
            this.actionKeyTip = actionKeyTip;
            return this;
        }

        public Overlay setPopupKeyTip(String popupKeyTip) {
            this.popupKeyTip = popupKeyTip;
            return this;
        }

        public Overlay setTextClickAction() {
            this.isTextClickAction = true;
            return this;
        }

        public Overlay setTextClickPopup() {
            this.isTextClickPopup = true;
            return this;
        }

        public Overlay setAutoRepeatAction(boolean isAutoRepeatAction) {
            this.isAutoRepeatAction = isAutoRepeatAction;
            return this;
        }

        public Overlay setAutoRepeatActionIntervals(int initial, int subsequent) {
            this.hasAutoRepeatIntervalsSet = true;
            this.autoRepeatInitialInterval = initial;
            this.autoRepeatSubsequentInterval = subsequent;
            return this;
        }

        public Overlay setFireActionOnRollover(boolean isFireActionOnRollover) {
            this.isFireActionOnRollover = isFireActionOnRollover;
            return this;
        }

        public Overlay setFireActionOnPress(boolean isFireActionOnPress) {
            this.isFireActionOnPress = isFireActionOnPress;
            return this;
        }
    }

    public static enum PopupHorizontalGravity {
        START,
        END;

    }

    public static enum PopupOrientationKind {
        DOWNWARD,
        SIDEWARD;

    }
}

