/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.CommandAction;
import org.pushingpixels.flamingo.api.common.CommandActionEvent;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.PopupActionListener;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.RichTooltipManager;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.ActionRepeatableButtonModel;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.popup.model.AbstractPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.CommandPopupMenuProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.projection.RibbonApplicationMenuCommandButtonProjection;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.RibbonApplicationMenuPanelProjection;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class JCommandButton
extends RichTooltipManager.JTrackableComponent {
    public static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    public static final double DEFAULT_GAP_SCALE_FACTOR = 1.0;
    public static final String uiClassID = "CommandButtonUI";
    private Projection<JCommandButton, ? extends Command, CommandButtonPresentationModel> projection;
    private Command command;
    private CommandButtonPresentationModel commandPresentation;
    private ResizableIcon icon;
    private ResizableIcon disabledIcon;
    private String text;
    private ActionButtonModel actionModel;
    private String extraText;
    private CommandButtonPresentationState presentationState;
    private int iconDimension;
    private boolean isFlat;
    private int horizontalAlignment;
    private double hgapScaleFactor;
    private double vgapScaleFactor;
    private RichTooltip actionRichTooltip;
    private CommandButtonLocationOrderKind locationOrderKind;
    private ActionHandler actionHandler;
    private String actionKeyTip;
    private PopupPanelCallback popupCallback;
    private CommandButtonKind commandButtonKind;
    private CommandButtonPresentationModel.PopupOrientationKind popupOrientationKind;
    private CommandButtonPresentationModel.PopupHorizontalGravity popupHorizontalGravity;
    private boolean isAutoRepeatAction;
    private int autoRepeatInitialInterval;
    private int autoRepeatSubsequentInterval;
    private boolean isFireActionOnRollover;
    private PopupButtonModel popupModel;
    private PopupHandler popupHandler;
    private RichTooltip popupRichTooltip;
    private String popupKeyTip;

    public JCommandButton(Projection<JCommandButton, ? extends Command, CommandButtonPresentationModel> projection) {
        boolean hasPopup;
        boolean hasAction;
        this.projection = projection;
        this.command = (Command)projection.getContentModel();
        this.commandPresentation = (CommandButtonPresentationModel)projection.getPresentationModel();
        this.setText(this.command.getText());
        this.setExtraText(this.command.getExtraText());
        this.setIcon(this.command.getIconFactory() != null ? this.command.getIconFactory().createNewIcon() : null);
        this.setDisabledIcon(this.command.getDisabledIconFactory() != null ? this.command.getDisabledIconFactory().createNewIcon() : null);
        boolean bl = hasAction = this.command.getAction() != null;
        if (hasAction) {
            this.addCommandListener(this.command.getAction());
            this.setActionRichTooltip(this.command.getActionRichTooltip());
            this.setActionKeyTip(this.commandPresentation.getActionKeyTip());
        }
        if (!this.commandPresentation.isToDismissPopupsOnActivation()) {
            this.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        }
        this.setPresentationState(this.commandPresentation.getPresentationState());
        this.setHorizontalAlignment(this.commandPresentation.getHorizontalAlignment());
        this.setHGapScaleFactor(this.commandPresentation.getHorizontalGapScaleFactor());
        this.setVGapScaleFactor(this.commandPresentation.getVerticalGapScaleFactor());
        this.setFlat(this.commandPresentation.isFlat());
        this.setFocusable(this.commandPresentation.isFocusable());
        if (this.commandPresentation.getIconDimension() != null) {
            this.setIconDimension(this.commandPresentation.getIconDimension());
        }
        this.actionHandler = new ActionHandler();
        this.setOpaque(false);
        ActionRepeatableButtonModel actionButtonModel = new ActionRepeatableButtonModel(this);
        actionButtonModel.setEnabled(this.command.isActionEnabled());
        actionButtonModel.setSelected(this.command.isToggleSelected());
        this.setActionModel(actionButtonModel);
        this.popupHandler = new PopupHandler();
        DefaultPopupButtonModel popupButtonModel = new DefaultPopupButtonModel(this);
        popupButtonModel.setEnabled(((Command)projection.getContentModel()).isSecondaryEnabled());
        this.setPopupModel(popupButtonModel);
        boolean bl2 = hasPopup = this.command.getSecondaryContentModel() != null;
        if (hasPopup) {
            if (this.command.getSecondaryContentModel() != null) {
                CommandMenuContentModel popupMenuContentModel = this.command.getSecondaryContentModel();
                AbstractPopupMenuPresentationModel popupMenuPresentationModel = this.commandPresentation.getPopupMenuPresentationModel();
                if (popupMenuContentModel instanceof RibbonApplicationMenu) {
                    RibbonApplicationMenuCommandButtonProjection ribbonApplicationMenuProjection = (RibbonApplicationMenuCommandButtonProjection)this.projection;
                    if (popupMenuPresentationModel == null) {
                        popupMenuPresentationModel = CommandPopupMenuPresentationModel.builder().build();
                    }
                    RibbonApplicationMenuPanelProjection menuPanelProjection = new RibbonApplicationMenuPanelProjection((RibbonApplicationMenu)popupMenuContentModel, (CommandPopupMenuPresentationModel)popupMenuPresentationModel);
                    menuPanelProjection.setCommandOverlays(ribbonApplicationMenuProjection.getCommandOverlays());
                    menuPanelProjection.setSecondaryLevelCommandPresentationState(ribbonApplicationMenuProjection.getSecondaryLevelCommandPresentationState());
                    this.setPopupCallback(commandButton -> (JRibbonApplicationMenuPopupPanel)menuPanelProjection.buildComponent());
                } else if (popupMenuContentModel != null) {
                    CommandButtonProjection commandProjection = (CommandButtonProjection)this.projection;
                    if (popupMenuPresentationModel == null) {
                        popupMenuPresentationModel = CommandPopupMenuPresentationModel.builder().build();
                    }
                    CommandPopupMenuProjection commandPopupMenuProjection = new CommandPopupMenuProjection(popupMenuContentModel, (CommandPopupMenuPresentationModel)popupMenuPresentationModel);
                    commandPopupMenuProjection.setCommandOverlays(this.projection.getCommandOverlays());
                    if (commandProjection.getPopupMenuSupplier() != null) {
                        commandPopupMenuProjection.setComponentSupplier(commandProjection.getPopupMenuSupplier());
                    }
                    if (commandProjection.getPopupMenuCustomizer() != null) {
                        commandPopupMenuProjection.setComponentCustomizer(commandProjection.getPopupMenuCustomizer());
                    }
                    this.setPopupCallback(commandButton -> (JCommandPopupMenu)commandPopupMenuProjection.buildComponent());
                }
            }
            this.setPopupRichTooltip(this.command.getSecondaryRichTooltip());
            this.setPopupKeyTip(this.commandPresentation.getPopupKeyTip());
        }
        if (hasAction && hasPopup) {
            this.setCommandButtonKind(this.commandPresentation.isTextClickAction() ? CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION : CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        } else if (hasPopup) {
            this.setCommandButtonKind(CommandButtonKind.POPUP_ONLY);
        } else {
            this.setCommandButtonKind(CommandButtonKind.ACTION_ONLY);
        }
        if (this.commandPresentation.isAutoRepeatAction()) {
            this.setAutoRepeatAction(true);
            if (this.commandPresentation.hasAutoRepeatIntervalsSet()) {
                this.setAutoRepeatActionIntervals(this.commandPresentation.getAutoRepeatInitialInterval(), this.commandPresentation.getAutoRepeatSubsequentInterval());
            }
        }
        this.setFireActionOnRollover(this.commandPresentation.isFireActionOnRollover());
        this.getActionModel().setFireActionOnPress(this.commandPresentation.isFireActionOnPress());
        this.setPopupOrientationKind(this.commandPresentation.getPopupOrientationKind());
        this.setPopupHorizontalGravity(this.commandPresentation.getPopupHorizontalGravity());
        if (this.command.getActionPreview() != null) {
            this.getActionModel().addChangeListener(new ChangeListener(){
                boolean wasRollover = false;

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean isRollover = JCommandButton.this.getActionModel().isRollover();
                    if (this.wasRollover && !isRollover) {
                        JCommandButton.this.command.getActionPreview().onCommandPreviewCanceled(JCommandButton.this.command);
                    }
                    if (!this.wasRollover && isRollover) {
                        JCommandButton.this.command.getActionPreview().onCommandPreviewActivated(JCommandButton.this.command);
                    }
                    this.wasRollover = isRollover;
                }
            });
        }
        this.updateUI();
    }

    @Override
    public CommandButtonUI getUI() {
        return (CommandButtonUI)this.ui;
    }

    public CommandButtonProjection<? extends Command> getProjection() {
        return (CommandButtonProjection)this.projection;
    }

    public void setPresentationState(CommandButtonPresentationState state) {
        CommandButtonPresentationState old = this.presentationState;
        this.presentationState = state;
        this.firePropertyChange("presentationState", old, this.presentationState);
    }

    public ResizableIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ResizableIcon defaultIcon) {
        ResizableIcon oldValue = this.icon;
        this.icon = defaultIcon;
        this.firePropertyChange("icon", oldValue, defaultIcon);
        if (defaultIcon != oldValue) {
            if (defaultIcon == null || oldValue == null || defaultIcon.getIconWidth() != oldValue.getIconWidth() || defaultIcon.getIconHeight() != oldValue.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public void setDisabledIcon(ResizableIcon disabledIcon) {
        this.disabledIcon = disabledIcon;
    }

    public ResizableIcon getDisabledIcon() {
        return this.disabledIcon;
    }

    public CommandButtonPresentationState getPresentationState() {
        return this.presentationState;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public void setExtraText(String extraText) {
        String oldValue = this.extraText;
        this.extraText = extraText;
        this.firePropertyChange("extraText", oldValue, extraText);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, extraText);
        }
        if (extraText == null || oldValue == null || !extraText.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChange("text", oldValue, text);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, text);
        }
        if (text == null || oldValue == null || !text.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setIconDimension(int dimension) {
        if (this.iconDimension != dimension) {
            int old = this.iconDimension;
            this.iconDimension = dimension;
            this.firePropertyChange("iconDimension", old, this.iconDimension);
        }
    }

    public int getIconDimension() {
        return this.iconDimension;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public void setFlat(boolean isFlat) {
        boolean old = this.isFlat;
        this.isFlat = isFlat;
        if (old != this.isFlat) {
            this.firePropertyChange("flat", old, this.isFlat);
        }
        if (old != isFlat) {
            this.repaint();
        }
    }

    public ActionButtonModel getActionModel() {
        return this.actionModel;
    }

    public void setActionModel(ActionButtonModel newModel) {
        ActionButtonModel oldModel = this.getActionModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.actionHandler);
            oldModel.removeActionListener(this.actionHandler);
        }
        this.actionModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.actionHandler);
            newModel.addActionListener(this.actionHandler);
        }
        this.firePropertyChange("actionModel", oldModel, newModel);
        if (newModel != oldModel) {
            this.revalidate();
            this.repaint();
        }
    }

    public void addCommandListener(CommandAction l) {
        this.listenerList.add(CommandAction.class, l);
    }

    public void removeCommandListener(CommandAction l) {
        this.listenerList.remove(CommandAction.class, l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(ce);
        }
    }

    protected void fireActionPerformed(ActionEvent event) {
        String actionCommand;
        int i;
        Object[] listeners = this.listenerList.getListenerList();
        CommandActionEvent e = null;
        for (i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandAction.class) continue;
            if (e == null) {
                actionCommand = event.getActionCommand();
                e = new CommandActionEvent(this, 1001, this.command, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((CommandAction)listeners[i + 1]).commandActivated(e);
        }
        for (i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                actionCommand = event.getActionCommand();
                e = new CommandActionEvent(this, 1001, this.command, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == this.horizontalAlignment) {
            return;
        }
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = alignment;
        this.firePropertyChange("horizontalAlignment", oldValue, this.horizontalAlignment);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHGapScaleFactor(double hgapScaleFactor) {
        if (hgapScaleFactor == this.hgapScaleFactor) {
            return;
        }
        double oldValue = this.hgapScaleFactor;
        this.hgapScaleFactor = hgapScaleFactor;
        this.firePropertyChange("hgapScaleFactor", oldValue, this.hgapScaleFactor);
        if (this.hgapScaleFactor != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setVGapScaleFactor(double vgapScaleFactor) {
        if (vgapScaleFactor == this.vgapScaleFactor) {
            return;
        }
        double oldValue = this.vgapScaleFactor;
        this.vgapScaleFactor = vgapScaleFactor;
        this.firePropertyChange("vgapScaleFactor", oldValue, this.vgapScaleFactor);
        if (this.vgapScaleFactor != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setGapScaleFactor(double gapScaleFactor) {
        this.setHGapScaleFactor(gapScaleFactor);
        this.setVGapScaleFactor(gapScaleFactor);
    }

    public double getHGapScaleFactor() {
        return this.hgapScaleFactor;
    }

    public double getVGapScaleFactor() {
        return this.vgapScaleFactor;
    }

    public void doActionClick() {
        Dimension size = this.getSize();
        ActionButtonModel actionModel = this.getActionModel();
        actionModel.setArmed(true);
        actionModel.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        actionModel.setPressed(false);
        actionModel.setArmed(false);
    }

    public void setActionRichTooltip(RichTooltip richTooltip) {
        RichTooltipManager.sharedInstance();
        this.actionRichTooltip = richTooltip;
    }

    @Override
    public void setToolTipText(String text) {
        throw new UnsupportedOperationException("Use rich tooltip APIs");
    }

    public CommandButtonLocationOrderKind getLocationOrderKind() {
        return this.locationOrderKind;
    }

    public void setLocationOrderKind(CommandButtonLocationOrderKind locationOrderKind) {
        CommandButtonLocationOrderKind old = this.locationOrderKind;
        if (old != locationOrderKind) {
            this.locationOrderKind = locationOrderKind;
            this.firePropertyChange("locationOrderKind", (Object)old, (Object)this.locationOrderKind);
        }
    }

    public String getActionKeyTip() {
        return this.actionKeyTip;
    }

    public void setActionKeyTip(String actionKeyTip) {
        String old = this.actionKeyTip;
        this.actionKeyTip = actionKeyTip;
        this.firePropertyChange("actionKeyTip", old, this.actionKeyTip);
    }

    public CommandButtonKind getCommandButtonKind() {
        return this.commandButtonKind;
    }

    public void setCommandButtonKind(CommandButtonKind commandButtonKind) {
        CommandButtonKind old = this.commandButtonKind;
        this.commandButtonKind = commandButtonKind;
        if (old != this.commandButtonKind) {
            this.firePropertyChange("commandButtonKind", (Object)old, (Object)this.commandButtonKind);
        }
    }

    public CommandButtonPresentationModel.PopupOrientationKind getPopupOrientationKind() {
        return this.popupOrientationKind;
    }

    public void setPopupOrientationKind(CommandButtonPresentationModel.PopupOrientationKind popupOrientationKind) {
        CommandButtonPresentationModel.PopupOrientationKind old = this.popupOrientationKind;
        this.popupOrientationKind = popupOrientationKind;
        if (old != this.popupOrientationKind) {
            this.firePropertyChange("popupOrientationKind", (Object)old, (Object)this.popupOrientationKind);
        }
    }

    public CommandButtonPresentationModel.PopupHorizontalGravity getPopupHorizontalGravity() {
        return this.popupHorizontalGravity;
    }

    public void setPopupHorizontalGravity(CommandButtonPresentationModel.PopupHorizontalGravity popupHorizontalGravity) {
        CommandButtonPresentationModel.PopupHorizontalGravity old = this.popupHorizontalGravity;
        this.popupHorizontalGravity = popupHorizontalGravity;
        if (old != this.popupHorizontalGravity) {
            this.firePropertyChange("popupHorizontalGravity", (Object)old, (Object)this.popupHorizontalGravity);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceCommandButtonUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public PopupPanelCallback getPopupCallback() {
        return this.popupCallback;
    }

    public void setPopupCallback(PopupPanelCallback popupCallback) {
        this.popupCallback = popupCallback;
        if (this.command != null) {
            boolean hasPopup;
            boolean hasAction = this.command.getAction() != null;
            boolean bl = hasPopup = this.popupCallback != null;
            if (hasPopup) {
                this.setPopupRichTooltip(this.command.getSecondaryRichTooltip());
                this.setPopupKeyTip(this.commandPresentation.getPopupKeyTip());
            }
            if (hasAction && hasPopup) {
                this.setCommandButtonKind(this.commandPresentation.isTextClickAction() ? CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION : CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            } else if (hasPopup) {
                this.setCommandButtonKind(CommandButtonKind.POPUP_ONLY);
            } else {
                this.setCommandButtonKind(CommandButtonKind.ACTION_ONLY);
            }
        }
    }

    public void setAutoRepeatAction(boolean isAutoRepeatAction) {
        this.isAutoRepeatAction = isAutoRepeatAction;
    }

    public void setAutoRepeatActionIntervals(int initial, int subsequent) {
        this.autoRepeatInitialInterval = initial;
        this.autoRepeatSubsequentInterval = subsequent;
    }

    public boolean isAutoRepeatAction() {
        return this.isAutoRepeatAction;
    }

    public int getAutoRepeatInitialInterval() {
        return this.autoRepeatInitialInterval;
    }

    public int getAutoRepeatSubsequentInterval() {
        return this.autoRepeatSubsequentInterval;
    }

    public void setFireActionOnRollover(boolean isFireActionOnRollover) {
        this.isFireActionOnRollover = isFireActionOnRollover;
    }

    public boolean isFireActionOnRollover() {
        return this.isFireActionOnRollover;
    }

    public PopupButtonModel getPopupModel() {
        return this.popupModel;
    }

    public void setPopupModel(PopupButtonModel newModel) {
        PopupButtonModel oldModel = this.getPopupModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.popupHandler);
            oldModel.removeActionListener(this.popupHandler);
        }
        this.popupModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.popupHandler);
            newModel.addActionListener(this.popupHandler);
        }
        this.firePropertyChange("popupModel", oldModel, newModel);
        if (newModel != oldModel) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.popupModel != null && !b && this.popupModel.isRollover()) {
            this.popupModel.setRollover(false);
        }
        if (this.actionModel != null && !b && this.actionModel.isRollover()) {
            this.actionModel.setRollover(false);
        }
        super.setEnabled(b);
        if (this.popupModel != null) {
            this.popupModel.setEnabled(b);
        }
        if (this.actionModel != null) {
            this.actionModel.setEnabled(b);
        }
    }

    protected void firePopupActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((PopupActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void setPopupRichTooltip(RichTooltip richTooltip) {
        RichTooltipManager.sharedInstance();
        this.popupRichTooltip = richTooltip;
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent event) {
        CommandButtonUI ui = this.getUI();
        if (ui.getLayoutInfo().actionClickArea.contains(event.getPoint())) {
            return this.actionRichTooltip;
        }
        if (ui.getLayoutInfo().popupClickArea.contains(event.getPoint())) {
            return this.popupRichTooltip;
        }
        return null;
    }

    public String getPopupKeyTip() {
        return this.popupKeyTip;
    }

    public void setPopupKeyTip(String popupKeyTip) {
        String old = this.popupKeyTip;
        this.popupKeyTip = popupKeyTip;
        this.firePropertyChange("popupKeyTip", old, this.popupKeyTip);
    }

    public void doPopupClick() {
        Dimension size = this.getSize();
        PopupButtonModel popupModel = this.getPopupModel();
        popupModel.setArmed(true);
        popupModel.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        popupModel.setPressed(false);
        popupModel.setArmed(false);
        popupModel.setPopupShowing(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
    }

    public boolean isPopupVisible() {
        List<PopupPanelManager.PopupInfo> popupInfos = PopupPanelManager.defaultManager().getShownPath();
        for (PopupPanelManager.PopupInfo popupInfo : popupInfos) {
            if (popupInfo.getPopupOriginator() != this) continue;
            return true;
        }
        return false;
    }

    public void addRolloverActionListener(RolloverActionListener l) {
        this.listenerList.add(RolloverActionListener.class, l);
    }

    public void removeRolloverActionListener(RolloverActionListener l) {
        this.listenerList.remove(RolloverActionListener.class, l);
    }

    public void doActionRollover() {
        ActionEvent ae = new ActionEvent(this, 1001, this.getActionModel().getActionCommand());
        RolloverActionListener[] listeners = (RolloverActionListener[])this.getListeners(RolloverActionListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].actionPerformed(ae);
        }
    }

    class PopupHandler
    implements PopupActionListener,
    ChangeListener {
        PopupHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCommandButton.this.fireStateChanged();
            JCommandButton.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JCommandButton.this.firePopupActionPerformed(event);
        }
    }

    class ActionHandler
    implements ActionListener,
    ChangeListener {
        ActionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCommandButton.this.fireStateChanged();
            JCommandButton.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JCommandButton.this.fireActionPerformed(event);
        }
    }

    private static class DefaultPopupButtonModel
    extends DefaultButtonModel
    implements PopupButtonModel {
        public static final int POPUP_SHOWING = 256;
        private JCommandButton commandButton;

        public DefaultPopupButtonModel(JCommandButton commandButton) {
            this.commandButton = commandButton;
        }

        @Override
        public void addPopupActionListener(PopupActionListener l) {
            this.listenerList.add(PopupActionListener.class, l);
        }

        @Override
        public void removePopupActionListener(PopupActionListener l) {
            this.listenerList.remove(PopupActionListener.class, l);
        }

        protected void firePopupActionPerformed(ActionEvent e) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PopupActionListener.class) continue;
                ((PopupActionListener)listeners[i + 1]).actionPerformed(e);
            }
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            if (this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiersEx();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.commandButton.getUI().setInnerFocusOnAction(false);
                this.firePopupActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
            this.fireStateChanged();
        }

        @Override
        public boolean isPopupShowing() {
            return (this.stateMask & 0x100) != 0;
        }

        @Override
        public void setPopupShowing(boolean b) {
            if (this.isPopupShowing() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 0x100) : (this.stateMask &= 0xFFFFFEFF);
            this.fireStateChanged();
        }
    }

    public static enum CommandButtonKind {
        ACTION_ONLY(true, false),
        POPUP_ONLY(false, true),
        ACTION_AND_POPUP_MAIN_ACTION(true, true),
        ACTION_AND_POPUP_MAIN_POPUP(true, true);

        private boolean hasAction;
        private boolean hasPopup;

        private CommandButtonKind(boolean hasAction, boolean hasPopup) {
            this.hasAction = hasAction;
            this.hasPopup = hasPopup;
        }

        public boolean hasAction() {
            return this.hasAction;
        }

        public boolean hasPopup() {
            return this.hasPopup;
        }
    }

    public static enum CommandButtonLocationOrderKind {
        ONLY,
        FIRST,
        MIDDLE,
        LAST;

    }
}

