/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandToggleGroupModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandPopupMenuProjection;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.model.RibbonGalleryContentModel;
import org.pushingpixels.flamingo.api.ribbon.model.RibbonGalleryPresentationModel;
import org.pushingpixels.flamingo.api.ribbon.projection.RibbonGalleryProjection;
import org.pushingpixels.flamingo.internal.substance.ribbon.ui.SubstanceRibbonGalleryUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonGalleryUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonGalleryUI;

public class JRibbonGallery
extends JComponent {
    private RibbonGalleryProjection galleryProjection;
    private RibbonGalleryContentModel galleryContentModel;
    private RibbonGalleryPresentationModel galleryPresentationModel;
    private Map<Command, CommandButtonPresentationModel.Overlay> galleryCommandOverlays;
    protected List<JCommandToggleButton> buttons;
    protected List<Command> commands;
    private CommandToggleGroupModel commandToggleGroupModel;
    private JRibbonBand.PresentationPriority presentationPriority;
    public static final String uiClassID = "RibbonGalleryUI";

    public JRibbonGallery(RibbonGalleryProjection galleryProjection) {
        this.galleryProjection = galleryProjection;
        this.galleryContentModel = (RibbonGalleryContentModel)galleryProjection.getContentModel();
        this.galleryPresentationModel = (RibbonGalleryPresentationModel)galleryProjection.getPresentationModel();
        this.galleryCommandOverlays = galleryProjection.getCommandOverlays() == null ? Collections.emptyMap() : galleryProjection.getCommandOverlays();
        this.buttons = new ArrayList<JCommandToggleButton>();
        this.commands = new ArrayList<Command>();
        this.commandToggleGroupModel = new CommandToggleGroupModel();
        this.validateCommandPresentationState(this.galleryPresentationModel.getCommandPresentationState());
        this.populateContent();
        this.galleryContentModel.addCommandActivationListener(activated -> this.commandToggleGroupModel.setSelected(activated, true));
        this.galleryContentModel.addChangeListener(changeEvent -> {
            this.buttons.clear();
            this.commandToggleGroupModel.removeAll();
            this.commands.clear();
            this.removeAll();
            this.populateContent();
        });
        this.updateUI();
    }

    private void populateContent() {
        this.setGroupMapping(this.galleryContentModel.getCommandGroups());
    }

    public void setUI(RibbonGalleryUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceRibbonGalleryUI.createUI(this));
    }

    @Override
    public RibbonGalleryUI getUI() {
        return (RibbonGalleryUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private void addGalleryCommand(final Command command) {
        CommandButtonPresentationModel presentation = CommandButtonPresentationModel.withDefaults();
        CommandButtonPresentationModel.Overlay overlay = this.galleryCommandOverlays.get(command);
        if (overlay != null) {
            presentation = presentation.overlayWith(overlay);
        }
        final JCommandToggleButton button = (JCommandToggleButton)command.project(presentation).buildComponent();
        button.getActionModel().addChangeListener(new ChangeListener(){
            boolean wasRollover = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isRollover = button.getActionModel().isRollover();
                if (this.wasRollover && !isRollover && JRibbonGallery.this.galleryContentModel != null) {
                    JRibbonGallery.this.galleryContentModel.cancelPreview(command);
                }
                if (!this.wasRollover && isRollover && JRibbonGallery.this.galleryContentModel != null) {
                    JRibbonGallery.this.galleryContentModel.activatePreview(command);
                }
                this.wasRollover = isRollover;
            }
        });
        button.getActionModel().addActionListener(e -> this.galleryContentModel.setSelectedCommand(command));
        this.buttons.add(button);
        this.commandToggleGroupModel.add(command);
        this.commands.add(command);
        button.setPresentationState(this.galleryPresentationModel.getCommandPresentationState());
        super.add(button);
    }

    public int getPreferredWidth(JRibbonBand.PresentationPriority state, int availableHeight) {
        int preferredVisibleButtonCount = this.galleryPresentationModel.getPreferredVisibleCommandCounts().get((Object)state);
        BasicRibbonGalleryUI ui = (BasicRibbonGalleryUI)this.getUI();
        return ui.getPreferredWidth(preferredVisibleButtonCount, availableHeight);
    }

    public void setPresentationPriority(JRibbonBand.PresentationPriority presentationPriority) {
        this.presentationPriority = presentationPriority;
    }

    public JRibbonBand.PresentationPriority getPresentationPriority() {
        return this.presentationPriority;
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public JCommandToggleButton getButtonAt(int index) {
        return this.buttons.get(index);
    }

    public JCommandToggleButton getSelectedButton() {
        int buttonIndex = this.commands.indexOf(this.commandToggleGroupModel.getSelected());
        return this.buttons.get(buttonIndex);
    }

    public RibbonGalleryProjection getProjection() {
        return this.galleryProjection;
    }

    private void setGroupMapping(List<CommandGroup> commandGroups) {
        for (CommandGroup commandGroupModel : commandGroups) {
            for (Command command : commandGroupModel.getCommands()) {
                if (!command.isToggle()) {
                    throw new IllegalStateException("Gallery command must be toggle");
                }
                if (command.getToggleGroupModel() == null) continue;
                throw new IllegalStateException("Gallery toggle command should not be associated with a toggle group");
            }
        }
        boolean hasGroupWithNullTitle = false;
        for (CommandGroup commandGroupModel : commandGroups) {
            if (commandGroupModel.getTitle() == null) {
                if (hasGroupWithNullTitle) {
                    throw new IllegalArgumentException("Can't have more than one ribbon gallery group with null name");
                }
                hasGroupWithNullTitle = true;
            }
            for (Command command : commandGroupModel.getCommands()) {
                this.addGalleryCommand(command);
            }
        }
    }

    private void validateCommandPresentationState(CommandButtonPresentationState commandPresentationState) {
        boolean isSupported;
        boolean bl = isSupported = commandPresentationState == JRibbonBand.BIG_FIXED || commandPresentationState == CommandButtonPresentationState.SMALL || commandPresentationState == JRibbonBand.BIG_FIXED_LANDSCAPE;
        if (!isSupported) {
            throw new IllegalArgumentException("Presentation state " + commandPresentationState.getDisplayName() + " is not supported in ribbon galleries");
        }
    }

    public static CommandPopupMenuProjection getExpandPopupMenu(final RibbonGalleryProjection galleryProjection, ComponentOrientation componentOrientation) {
        CommandPanelContentModel galleryPopupMenuPanelContentModel = new CommandPanelContentModel(((RibbonGalleryContentModel)galleryProjection.getContentModel()).getCommandGroups());
        galleryPopupMenuPanelContentModel.setSingleSelectionMode(true);
        galleryPopupMenuPanelContentModel.setCommandPreviewListener(new Command.CommandActionPreview(){

            @Override
            public void onCommandPreviewActivated(Command command) {
                ((RibbonGalleryContentModel)galleryProjection.getContentModel()).activatePreview(command);
            }

            @Override
            public void onCommandPreviewCanceled(Command command) {
                ((RibbonGalleryContentModel)galleryProjection.getContentModel()).cancelPreview(command);
            }
        });
        CommandMenuContentModel galleryPopupMenuContentModel = new CommandMenuContentModel(galleryPopupMenuPanelContentModel, ((RibbonGalleryContentModel)galleryProjection.getContentModel()).getExtraPopupCommandGroups());
        boolean allGroupsHaveTitles = true;
        for (CommandGroup commandGroupModel : ((RibbonGalleryContentModel)galleryProjection.getContentModel()).getCommandGroups()) {
            String groupTitle = commandGroupModel.getTitle();
            if (groupTitle != null) continue;
            allGroupsHaveTitles = false;
            break;
        }
        RibbonGalleryPresentationModel galleryPresentationModel = (RibbonGalleryPresentationModel)galleryProjection.getPresentationModel();
        CommandPopupMenuPresentationModel galleryPopupMenuPresentationModel = CommandPopupMenuPresentationModel.builder().setPanelPresentationModel(CommandPanelPresentationModel.builder().setToShowGroupLabels(allGroupsHaveTitles).setCommandPresentationState(galleryPresentationModel.getCommandPresentationState()).setMaxColumns(galleryPresentationModel.getPreferredPopupMaxCommandColumns()).setMaxRows(galleryPresentationModel.getPreferredPopupMaxVisibleCommandRows()).build()).build();
        CommandPopupMenuProjection commandPopupMenuProjection = new CommandPopupMenuProjection(galleryPopupMenuContentModel, galleryPopupMenuPresentationModel);
        if (galleryProjection.getCommandOverlays() != null) {
            commandPopupMenuProjection.setCommandOverlays(galleryProjection.getCommandOverlays());
        }
        commandPopupMenuProjection.setComponentCustomizer(galleryPopupMenu -> {
            galleryPopupMenu.applyComponentOrientation(componentOrientation);
            PopupPanelManager.PopupListener popupListener = new PopupPanelManager.PopupListener((JCommandPopupMenu)galleryPopupMenu, galleryProjection){
                final /* synthetic */ JCommandPopupMenu val$galleryPopupMenu;
                final /* synthetic */ RibbonGalleryProjection val$galleryProjection;
                {
                    this.val$galleryPopupMenu = jCommandPopupMenu;
                    this.val$galleryProjection = ribbonGalleryProjection;
                }

                @Override
                public void popupShown(PopupPanelManager.PopupEvent event) {
                    this.val$galleryPopupMenu.getMainButtonPanel().scrollToSelectedCommand();
                }

                @Override
                public void popupHidden(PopupPanelManager.PopupEvent event) {
                    Command selectedCommand = this.val$galleryPopupMenu.getMainButtonPanel().getSelectedCommand();
                    ((RibbonGalleryContentModel)this.val$galleryProjection.getContentModel()).setSelectedCommand(selectedCommand);
                    PopupPanelManager.defaultManager().removePopupListener(this);
                }
            };
            PopupPanelManager.defaultManager().addPopupListener(popupListener);
        });
        return commandPopupMenuProjection;
    }
}

