/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.RichTooltipManager;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandToggleGroupModel;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizeSequencingPolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonBandUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;

public abstract class BasicRibbonUI
extends RibbonUI {
    private static final String JUST_MINIMIZED = "ribbon.internal.justMinimized";
    protected JRibbon ribbon;
    protected JScrollablePanel<JPanel> bandScrollablePanel;
    private JScrollablePanel<TaskToggleButtonsHostPanel> taskToggleButtonsScrollablePanel;
    protected JRibbonApplicationMenuButton applicationMenuButton;
    private Container anchoredButtons;
    protected Map<RibbonTask, AbstractCommandButton> taskToggleButtons = new HashMap<RibbonTask, AbstractCommandButton>();
    private CommandToggleGroupModel taskToggleGroupModel = new CommandToggleGroupModel();
    private ChangeListener ribbonChangeListener;
    private PropertyChangeListener propertyChangeListener;
    private ComponentListener ribbonComponentListener;

    protected BasicRibbonUI() {
        this.taskToggleGroupModel.setAllowsClearingSelection(false);
    }

    @Override
    public void installUI(JComponent c) {
        this.ribbon = (JRibbon)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.ribbon = null;
    }

    protected void installListeners() {
        this.ribbonChangeListener = e -> this.syncRibbonState();
        this.ribbon.addChangeListener(this.ribbonChangeListener);
        this.propertyChangeListener = evt -> {
            if ("selectedTask".equals(evt.getPropertyName())) {
                this.syncSelectedTask();
            }
            if ("applicationMenu".equals(evt.getPropertyName())) {
                boolean isShowingAppMenuButton;
                if (this.applicationMenuButton != null) {
                    this.ribbon.remove(this.applicationMenuButton);
                }
                boolean bl = isShowingAppMenuButton = this.ribbon.getApplicationMenuProjection() != null;
                if (isShowingAppMenuButton) {
                    this.applicationMenuButton = new JRibbonApplicationMenuButton(this.ribbon.getApplicationMenuCommandProjection());
                    this.applicationMenuButton.applyComponentOrientation(this.ribbon.getComponentOrientation());
                    this.syncApplicationMenuTips();
                    this.ribbon.add(this.applicationMenuButton);
                }
                this.ribbon.revalidate();
                this.ribbon.doLayout();
                this.ribbon.repaint();
                Window windowAncestor = SwingUtilities.getWindowAncestor(this.ribbon);
                if (windowAncestor instanceof JRibbonFrame && isShowingAppMenuButton) {
                    this.applicationMenuButton.setText(((Command)this.ribbon.getApplicationMenuCommandProjection().getContentModel()).getText());
                }
                this.syncApplicationMenuTips();
            }
            if ("minimized".equals(evt.getPropertyName())) {
                PopupPanelManager.defaultManager().hidePopups(null);
                RichTooltipManager.sharedInstance().hideCurrentlyShowingTipIfNecessary();
                this.ribbon.revalidate();
                this.ribbon.doLayout();
                this.ribbon.repaint();
            }
        };
        this.ribbon.addPropertyChangeListener(this.propertyChangeListener);
        this.ribbonComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                KeyTipManager.defaultManager().hideAllKeyTips();
            }
        };
        this.ribbon.addComponentListener(this.ribbonComponentListener);
    }

    protected void uninstallListeners() {
        this.ribbon.removeChangeListener(this.ribbonChangeListener);
        this.ribbonChangeListener = null;
        this.ribbon.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.ribbon.removeComponentListener(this.ribbonComponentListener);
        this.ribbonComponentListener = null;
    }

    protected void installDefaults() {
        Border b = this.ribbon.getBorder();
        if (b == null || b instanceof UIResource) {
            this.ribbon.setBorder(new BorderUIResource.EmptyBorderUIResource(0, 0, 1, 0));
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        boolean isShowingAppMenuButton;
        JPanel bandHostPanel = new JPanel();
        bandHostPanel.setLayout(this.createBandHostPanelLayoutManager());
        this.bandScrollablePanel = new JScrollablePanel<JPanel>(bandHostPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        this.bandScrollablePanel.setScrollOnRollover(false);
        this.ribbon.add(this.bandScrollablePanel);
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.createTaskToggleButtonsHostPanel();
        taskToggleButtonsHostPanel.setLayout(this.createTaskToggleButtonsHostPanelLayoutManager());
        this.taskToggleButtonsScrollablePanel = new JScrollablePanel<TaskToggleButtonsHostPanel>(taskToggleButtonsHostPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        this.taskToggleButtonsScrollablePanel.setScrollOnRollover(false);
        this.taskToggleButtonsScrollablePanel.addChangeListener(e -> this.ribbon.repaint());
        this.ribbon.add(this.taskToggleButtonsScrollablePanel);
        this.ribbon.setLayout(this.createLayoutManager());
        this.syncRibbonState();
        boolean bl = isShowingAppMenuButton = this.ribbon.getApplicationMenuProjection() != null;
        if (isShowingAppMenuButton) {
            this.applicationMenuButton = new JRibbonApplicationMenuButton(this.ribbon.getApplicationMenuCommandProjection());
            this.applicationMenuButton.applyComponentOrientation(this.ribbon.getComponentOrientation());
            this.syncApplicationMenuTips();
            this.ribbon.add(this.applicationMenuButton);
            Window windowAncestor = SwingUtilities.getWindowAncestor(this.ribbon);
            if (windowAncestor instanceof JRibbonFrame) {
                this.applicationMenuButton.setText(((Command)this.ribbon.getApplicationMenuCommandProjection().getContentModel()).getText());
            }
        }
    }

    @Override
    public JRibbonApplicationMenuButton getApplicationMenuButton() {
        return this.applicationMenuButton;
    }

    private LayoutManager createTaskToggleButtonsHostPanelLayoutManager() {
        return new TaskToggleButtonsHostPanelLayout();
    }

    protected abstract TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel();

    private LayoutManager createBandHostPanelLayoutManager() {
        return new BandHostPanelLayout();
    }

    protected void uninstallComponents() {
        JPanel bandHostPanel = this.bandScrollablePanel.getView();
        bandHostPanel.removeAll();
        bandHostPanel.setLayout(null);
        this.ribbon.remove(this.bandScrollablePanel);
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.taskToggleButtonsScrollablePanel.getView();
        taskToggleButtonsHostPanel.removeAll();
        taskToggleButtonsHostPanel.setLayout(null);
        this.ribbon.remove(this.taskToggleButtonsScrollablePanel);
        this.ribbon.remove(this.applicationMenuButton);
        if (this.anchoredButtons != null) {
            this.ribbon.remove(this.anchoredButtons);
        }
        this.ribbon.setLayout(null);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.ribbon.getFont());
        super.update(g2d, c);
        g2d.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintBackground(g);
        if (this.ribbon.isMinimized()) {
            this.paintMinimizedRibbonSeparator(g);
        }
    }

    protected abstract void paintMinimizedRibbonSeparator(Graphics var1);

    protected abstract void paintBackground(Graphics var1);

    @Override
    public Rectangle getContextualTaskGroupBounds(RibbonContextualTaskGroup group) {
        Rectangle rect = null;
        for (int j = 0; j < group.getTaskCount(); ++j) {
            JComponent button = this.taskToggleButtons.get(group.getTask(j));
            rect = rect == null ? button.getBounds() : rect.union(button.getBounds());
        }
        int buttonGap = this.getTabButtonGap();
        Point location = SwingUtilities.convertPoint(this.taskToggleButtonsScrollablePanel.getView(), rect.getLocation(), this.ribbon);
        return new Rectangle(location.x - buttonGap / 3, location.y - 1, rect.width + buttonGap * 2 / 3 - 1, rect.height + 1);
    }

    private int getBandGap() {
        return FlamingoUtilities.getScaledSize(2, this.ribbon.getFont().getSize(), 0.2, 1);
    }

    protected int getTabButtonGap() {
        return FlamingoUtilities.getScaledSize(6, this.ribbon.getFont().getSize(), 0.25, 1);
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonLayout();
    }

    private void syncSelectedTask() {
        AbstractCommandButton toggleButton;
        RibbonTask currentSelection = this.ribbon.getSelectedTask();
        for (Map.Entry<RibbonTask, AbstractCommandButton> taskToggleButtonEntry : this.taskToggleButtons.entrySet()) {
            if (currentSelection == taskToggleButtonEntry.getKey()) {
                taskToggleButtonEntry.getValue().getActionModel().setSelected(true);
                continue;
            }
            taskToggleButtonEntry.getValue().getActionModel().setSelected(false);
        }
        if (this.isShowingScrollsForTaskToggleButtons() && currentSelection != null && (toggleButton = this.taskToggleButtons.get(currentSelection)) != null) {
            this.scrollAndRevealTaskToggleButton(toggleButton);
        }
        SwingUtilities.invokeLater(() -> {
            KeyTipManager ktm = KeyTipManager.defaultManager();
            if (ktm.isShowingKeyTips()) {
                KeyTipManager.KeyTipChain chain = ktm.getCurrentlyShownKeyTipChain();
                if (chain.chainParentComponent == this.taskToggleButtons.get(currentSelection)) {
                    ktm.refreshCurrentChain();
                }
            }
        });
    }

    private void syncRibbonState() {
        int i;
        JPanel bandHostPanel = this.bandScrollablePanel.getView();
        bandHostPanel.removeAll();
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.taskToggleButtonsScrollablePanel.getView();
        taskToggleButtonsHostPanel.removeAll();
        if (this.anchoredButtons != null) {
            this.ribbon.remove(this.anchoredButtons);
            this.anchoredButtons = null;
        }
        List<RibbonTask> visibleTasks = this.getCurrentlyShownRibbonTasks();
        RibbonTask selectedTask = this.ribbon.getSelectedTask();
        for (final RibbonTask task : visibleTasks) {
            Command taskToggleCommand = ((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(task.getTitle())).inToggleGroup(this.taskToggleGroupModel)).setAction(cae -> SwingUtilities.invokeLater(() -> this.processTaskSelection(task, (JRibbonTaskToggleButton)cae.getButtonSource())))).build();
            CommandButtonProjection<Command> taskToggleCommandProjection = taskToggleCommand.project(CommandButtonPresentationModel.builder().setActionKeyTip(task.getKeyTip()).setToDismissPopupsOnActivation(false).build());
            taskToggleCommandProjection.setComponentSupplier(projection -> JRibbonTaskToggleButton::new);
            taskToggleCommandProjection.setComponentCustomizer(button -> {
                JRibbonTaskToggleButton taskToggleButton = (JRibbonTaskToggleButton)button;
                taskToggleButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (BasicRibbonUI.this.ribbon.getSelectedTask() == task && e.getClickCount() == 2) {
                            boolean wasMinimized = BasicRibbonUI.this.ribbon.isMinimized();
                            BasicRibbonUI.this.ribbon.setMinimized(!wasMinimized);
                            if (!wasMinimized) {
                                BasicRibbonUI.this.ribbon.putClientProperty(BasicRibbonUI.JUST_MINIMIZED, Boolean.TRUE);
                            }
                        }
                    }
                });
                if (task.getContextualGroup() != null) {
                    taskToggleButton.setContextualGroupHueColor(task.getContextualGroup().getHueColor());
                }
                taskToggleButton.setRibbonTask(task);
            });
            AbstractCommandButton taskToggleButton = (AbstractCommandButton)taskToggleCommandProjection.buildComponent();
            taskToggleButtonsHostPanel.add(taskToggleButton);
            this.taskToggleButtons.put(task, taskToggleButton);
        }
        AbstractCommandButton toSelect = this.taskToggleButtons.get(selectedTask);
        if (toSelect != null) {
            toSelect.getActionModel().setSelected(true);
        }
        for (i = 0; i < this.ribbon.getTaskCount(); ++i) {
            RibbonTask task = this.ribbon.getTask(i);
            for (AbstractRibbonBand band : task.getBands()) {
                bandHostPanel.add(band);
                band.setVisible(selectedTask == task);
            }
        }
        for (i = 0; i < this.ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup taskGroup = this.ribbon.getContextualTaskGroup(i);
            for (int j = 0; j < taskGroup.getTaskCount(); ++j) {
                RibbonTask task = taskGroup.getTask(j);
                for (AbstractRibbonBand band : task.getBands()) {
                    bandHostPanel.add(band);
                    band.setVisible(selectedTask == task);
                }
            }
        }
        List<CommandButtonProjection> anchoredCommands = this.ribbon.getAnchoredCommands();
        if (anchoredCommands != null) {
            this.anchoredButtons = new Container();
            this.anchoredButtons.setLayout(new AnchoredButtonsPanelLayout());
            for (CommandButtonProjection anchoredCommandProjection : anchoredCommands) {
                this.anchoredButtons.add((Component)anchoredCommandProjection.buildComponent());
            }
            this.ribbon.add(this.anchoredButtons);
        }
        this.ribbon.revalidate();
        this.ribbon.repaint();
    }

    private void processTaskSelection(RibbonTask task, JRibbonTaskToggleButton taskToggleButton) {
        this.scrollAndRevealTaskToggleButton(taskToggleButton);
        this.ribbon.setSelectedTask(task);
        if (this.ribbon.isMinimized()) {
            int ph;
            AbstractRibbonBand band;
            if (Boolean.TRUE.equals(this.ribbon.getClientProperty(JUST_MINIMIZED))) {
                this.ribbon.putClientProperty(JUST_MINIMIZED, null);
                return;
            }
            List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
            if (popups.size() > 0) {
                for (PopupPanelManager.PopupInfo popup : popups) {
                    if (popup.getPopupOriginator() != taskToggleButton) continue;
                    PopupPanelManager.defaultManager().hidePopups(null);
                    return;
                }
            }
            PopupPanelManager.defaultManager().hidePopups(null);
            this.ribbon.remove(this.bandScrollablePanel);
            int prefHeight = this.bandScrollablePanel.getView().getPreferredSize().height;
            Insets ins = this.ribbon.getInsets();
            prefHeight += ins.top + ins.bottom;
            AbstractRibbonBand abstractRibbonBand = band = this.ribbon.getSelectedTask().getBandCount() > 0 ? this.ribbon.getSelectedTask().getBand(0) : null;
            if (band != null) {
                Insets bandIns = band.getInsets();
                prefHeight += bandIns.top + bandIns.bottom;
            }
            BandHostPopupPanel popupPanel = new BandHostPopupPanel(this.bandScrollablePanel, new Dimension(this.ribbon.getWidth(), prefHeight));
            int x = this.ribbon.getLocationOnScreen().x;
            int y = this.ribbon.getLocationOnScreen().y + this.ribbon.getHeight();
            Rectangle scrBounds = this.ribbon.getGraphicsConfiguration().getBounds();
            int pw = popupPanel.getPreferredSize().width;
            if (x + pw > scrBounds.x + scrBounds.width) {
                x = scrBounds.x + scrBounds.width - pw;
            }
            if (y + (ph = popupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                y = scrBounds.y + scrBounds.height - ph;
            }
            popupPanel.setPreferredSize(new Dimension(this.ribbon.getWidth(), prefHeight));
            Popup popup = PopupFactory.getSharedInstance().getPopup(taskToggleButton, popupPanel, x, y);
            PopupPanelManager.PopupListener tracker = new PopupPanelManager.PopupListener(){

                @Override
                public void popupShown(PopupPanelManager.PopupEvent event) {
                    JComponent originator = event.getPopupOriginator();
                    if (originator instanceof JRibbonTaskToggleButton) {
                        BasicRibbonUI.this.bandScrollablePanel.doLayout();
                        BasicRibbonUI.this.bandScrollablePanel.repaint();
                    }
                }

                @Override
                public void popupHidden(PopupPanelManager.PopupEvent event) {
                    JComponent originator = event.getPopupOriginator();
                    if (originator instanceof JRibbonTaskToggleButton) {
                        BasicRibbonUI.this.ribbon.add(BasicRibbonUI.this.bandScrollablePanel);
                        PopupPanelManager.defaultManager().removePopupListener(this);
                        BasicRibbonUI.this.ribbon.revalidate();
                        BasicRibbonUI.this.ribbon.doLayout();
                        BasicRibbonUI.this.ribbon.repaint();
                    }
                }
            };
            PopupPanelManager.defaultManager().addPopupListener(tracker);
            PopupPanelManager.defaultManager().addPopup(taskToggleButton, popup, popupPanel);
        }
    }

    private List<RibbonTask> getCurrentlyShownRibbonTasks() {
        int i;
        ArrayList<RibbonTask> result = new ArrayList<RibbonTask>();
        for (i = 0; i < this.ribbon.getTaskCount(); ++i) {
            RibbonTask task = this.ribbon.getTask(i);
            result.add(task);
        }
        for (i = 0; i < this.ribbon.getContextualTaskGroupCount(); ++i) {
            RibbonContextualTaskGroup group = this.ribbon.getContextualTaskGroup(i);
            if (!this.ribbon.isVisible(group)) continue;
            for (int j = 0; j < group.getTaskCount(); ++j) {
                RibbonTask task = group.getTask(j);
                result.add(task);
            }
        }
        return result;
    }

    protected abstract void syncApplicationMenuTips();

    @Override
    public boolean isShowingScrollsForTaskToggleButtons() {
        return this.taskToggleButtonsScrollablePanel.isShowingScrollButtons();
    }

    public Map<RibbonTask, AbstractCommandButton> getTaskToggleButtons() {
        return Collections.unmodifiableMap(this.taskToggleButtons);
    }

    public List<JCommandButton> getAnchoredCommandButtons() {
        ArrayList<JCommandButton> result = new ArrayList<JCommandButton>();
        for (Component anchored : this.anchoredButtons.getComponents()) {
            result.add((JCommandButton)anchored);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void handleMouseWheelEvent(MouseWheelEvent e) {
        int newSelectedTaskIndex;
        if (this.ribbon.isMinimized()) {
            return;
        }
        List<RibbonTask> visibleTasks = this.getCurrentlyShownRibbonTasks();
        if (visibleTasks.size() == 0) {
            return;
        }
        int delta = e.getWheelRotation();
        if (delta == 0) {
            return;
        }
        int currSelectedTaskIndex = visibleTasks.indexOf(this.ribbon.getSelectedTask());
        if (!this.ribbon.getComponentOrientation().isLeftToRight()) {
            delta = -delta;
        }
        if ((newSelectedTaskIndex = currSelectedTaskIndex + (delta > 0 ? 1 : -1)) < 0) {
            return;
        }
        if (newSelectedTaskIndex >= visibleTasks.size()) {
            return;
        }
        int indexToSet = newSelectedTaskIndex;
        SwingUtilities.invokeLater(() -> {
            this.ribbon.setCursor(Cursor.getPredefinedCursor(3));
            this.ribbon.setSelectedTask((RibbonTask)visibleTasks.get(indexToSet));
            this.ribbon.setCursor(Cursor.getPredefinedCursor(0));
        });
    }

    private void scrollAndRevealTaskToggleButton(AbstractCommandButton taskToggleButton) {
        Point loc = SwingUtilities.convertPoint(taskToggleButton.getParent(), taskToggleButton.getLocation(), this.taskToggleButtonsScrollablePanel.getView());
        this.taskToggleButtonsScrollablePanel.scrollToIfNecessary(loc.x, taskToggleButton.getWidth());
    }

    private static class BandHostPopupPanel
    extends JPopupPanel {
        private BandHostPopupPanel(Component component, Dimension originalSize) {
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setPreferredSize(originalSize);
            this.setSize(originalSize);
            SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.GENERAL);
        }
    }

    private class AnchoredButtonsPanelLayout
    implements LayoutManager {
        private AnchoredButtonsPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int minWidth = 0;
            for (Component comp : parent.getComponents()) {
                minWidth += comp.getMinimumSize().width;
            }
            return new Dimension(minWidth, FlamingoUtilities.getTaskToggleButtonHeight(BasicRibbonUI.this.ribbon));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int prefWidth = 0;
            for (Component comp : parent.getComponents()) {
                prefWidth += comp.getPreferredSize().width;
            }
            return new Dimension(prefWidth, FlamingoUtilities.getTaskToggleButtonHeight(BasicRibbonUI.this.ribbon));
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean ltr = BasicRibbonUI.this.ribbon.getComponentOrientation().isLeftToRight();
            if (ltr) {
                int x = 0;
                for (Component comp : parent.getComponents()) {
                    int prefWidth = comp.getPreferredSize().width;
                    comp.setBounds(x, 0, prefWidth, parent.getHeight());
                    x += prefWidth;
                }
            } else {
                int x = parent.getWidth();
                for (Component comp : parent.getComponents()) {
                    int prefWidth = comp.getPreferredSize().width;
                    comp.setBounds(x - prefWidth, 0, prefWidth, parent.getHeight());
                    x -= prefWidth;
                }
            }
        }
    }

    private class TaskToggleButtonsHostPanelLayout
    implements LayoutManager {
        private TaskToggleButtonsHostPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = FlamingoUtilities.getTaskToggleButtonHeight(BasicRibbonUI.this.ribbon);
            int totalTaskButtonsWidth = 0;
            List visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            for (RibbonTask task : visibleTasks) {
                AbstractCommandButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                int pw = tabButton.getPreferredSize().width;
                totalTaskButtonsWidth += pw + tabButtonGap;
            }
            return new Dimension(totalTaskButtonsWidth, taskToggleButtonHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = FlamingoUtilities.getTaskToggleButtonHeight(BasicRibbonUI.this.ribbon);
            int totalTaskButtonsWidth = 0;
            List visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            for (RibbonTask task : visibleTasks) {
                AbstractCommandButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                int pw = tabButton.getMinimumSize().width;
                totalTaskButtonsWidth += pw + tabButtonGap;
            }
            return new Dimension(totalTaskButtonsWidth, taskToggleButtonHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            int y = 0;
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = FlamingoUtilities.getTaskToggleButtonHeight(BasicRibbonUI.this.ribbon);
            int totalPrefWidth = 0;
            int totalMinWidth = 0;
            List visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            HashMap<AbstractCommandButton, Integer> diffMap = new HashMap<AbstractCommandButton, Integer>();
            int totalDiff = 0;
            for (RibbonTask task : visibleTasks) {
                AbstractCommandButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                int pw = tabButton.getPreferredSize().width;
                int mw = tabButton.getMinimumSize().width;
                diffMap.put(tabButton, pw - mw);
                totalDiff += pw - mw;
                totalPrefWidth += pw;
                totalMinWidth += mw;
            }
            totalMinWidth += tabButtonGap * visibleTasks.size();
            boolean ltr = BasicRibbonUI.this.ribbon.getComponentOrientation().isLeftToRight();
            if ((totalPrefWidth += tabButtonGap * visibleTasks.size()) <= c.getWidth()) {
                int x = ltr ? 0 : c.getWidth();
                for (RibbonTask task : visibleTasks) {
                    AbstractCommandButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                    int pw = tabButton.getPreferredSize().width;
                    if (ltr) {
                        tabButton.setBounds(x, y + 1, pw, taskToggleButtonHeight - 1);
                        x += pw + tabButtonGap;
                    } else {
                        tabButton.setBounds(x - pw, y + 1, pw, taskToggleButtonHeight - 1);
                        x -= pw + tabButtonGap;
                    }
                    tabButton.setActionRichTooltip(null);
                }
                ((JComponent)c).putClientProperty("flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished", null);
            } else {
                if (totalMinWidth > c.getWidth()) {
                    throw new IllegalStateException("Available width not enough to host minimized task tab buttons");
                }
                int x = ltr ? 0 : c.getWidth();
                int toDistribute = totalPrefWidth - c.getWidth() + 2;
                for (RibbonTask task : visibleTasks) {
                    AbstractCommandButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                    int pw = tabButton.getPreferredSize().width;
                    int delta = toDistribute * (Integer)diffMap.get(tabButton) / totalDiff;
                    int finalWidth = pw - delta;
                    if (ltr) {
                        tabButton.setBounds(x, y + 1, finalWidth, taskToggleButtonHeight - 1);
                        x += finalWidth + tabButtonGap;
                    } else {
                        tabButton.setBounds(x - finalWidth, y + 1, finalWidth, taskToggleButtonHeight - 1);
                        x -= finalWidth + tabButtonGap;
                    }
                    tabButton.setActionRichTooltip(RichTooltip.builder().setTitle(task.getTitle()).build());
                }
                ((JComponent)c).putClientProperty("flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished", Boolean.TRUE);
            }
        }
    }

    protected abstract class TaskToggleButtonsHostPanel
    extends JPanel {
        private static final String IS_SQUISHED = "flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished";

        protected TaskToggleButtonsHostPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintContextualTaskGroupsOutlines(g);
            if (Boolean.TRUE.equals(this.getClientProperty(IS_SQUISHED))) {
                this.paintTaskOutlines(g);
            }
        }

        protected abstract void paintTaskOutlines(Graphics var1);

        private void paintContextualTaskGroupsOutlines(Graphics g) {
            for (int i = 0; i < BasicRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = BasicRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (!BasicRibbonUI.this.ribbon.isVisible(group)) continue;
                Rectangle rect = BasicRibbonUI.this.getContextualTaskGroupBounds(group);
                rect.setLocation(SwingUtilities.convertPoint(BasicRibbonUI.this.ribbon, rect.getLocation(), BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getView()));
                this.paintContextualTaskGroupOutlines(g, group, rect);
            }
        }

        protected abstract void paintContextualTaskGroupOutlines(Graphics var1, RibbonContextualTaskGroup var2, Rectangle var3);
    }

    private class BandHostPanelLayout
    implements LayoutManager {
        private BandHostPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int maxPrefBandHeight = 0;
            if (BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getPreferredSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    maxPrefBandHeight = Math.max(maxPrefBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
            }
            return new Dimension(c.getWidth(), maxPrefBandHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int width = 0;
            int maxMinBandHeight = 0;
            int gap = BasicRibbonUI.this.getBandGap();
            RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
            for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                int bandPrefHeight = ribbonBand.getMinimumSize().height;
                Insets bandInsets = ribbonBand.getInsets();
                RibbonBandUI bandUI = ribbonBand.getUI();
                int preferredCollapsedWidth = bandUI.getPreferredCollapsedWidth() + bandInsets.left + bandInsets.right;
                width += preferredCollapsedWidth;
                maxMinBandHeight = Math.max(maxMinBandHeight, bandPrefHeight);
            }
            return new Dimension(width += gap * (selectedTask.getBandCount() + 1), maxMinBandHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            boolean ltr;
            int bandGap = BasicRibbonUI.this.getBandGap();
            int y = 0;
            RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
            if (selectedTask == null) {
                return;
            }
            for (AbstractRibbonBand band : selectedTask.getBands()) {
                FlamingoUtilities.checkResizePoliciesConsistency(band);
            }
            for (AbstractRibbonBand band : selectedTask.getBands()) {
                List<RibbonBandResizePolicy> policies = band.getResizePolicies();
                RibbonBandResizePolicy last = policies.get(0);
                band.setCurrentResizePolicy(last);
            }
            int availableBandHeight = c.getHeight();
            int availableWidth = c.getWidth();
            if (selectedTask.getBandCount() > 0) {
                RibbonBandResizeSequencingPolicy resizeSequencingPolicy = selectedTask.getResizeSequencingPolicy();
                resizeSequencingPolicy.reset();
                AbstractRibbonBand currToTakeFrom = resizeSequencingPolicy.next();
                while (true) {
                    boolean noMore = true;
                    for (AbstractRibbonBand abstractRibbonBand : selectedTask.getBands()) {
                        List<RibbonBandResizePolicy> resizePolicies;
                        RibbonBandResizePolicy currentResizePolicy = abstractRibbonBand.getCurrentResizePolicy();
                        if (currentResizePolicy == (resizePolicies = abstractRibbonBand.getResizePolicies()).get(resizePolicies.size() - 1)) continue;
                        noMore = false;
                        break;
                    }
                    if (noMore) break;
                    int totalWidth = 0;
                    for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                        RibbonBandResizePolicy currentResizePolicy = ribbonBand.getCurrentResizePolicy();
                        Insets ribbonBandInsets = ribbonBand.getInsets();
                        AbstractBandControlPanel controlPanel = ribbonBand.getControlPanel();
                        if (controlPanel == null) {
                            controlPanel = ribbonBand.getPopupRibbonBand().getControlPanel();
                        }
                        Insets controlPanelInsets = controlPanel.getInsets();
                        int controlPanelGap = controlPanel.getUI().getLayoutGap();
                        int ribbonBandHeight = availableBandHeight - ribbonBandInsets.top - ribbonBandInsets.bottom;
                        int availableHeight = ribbonBandHeight - ribbonBand.getUI().getBandTitleHeight();
                        if (controlPanel != null) {
                            availableHeight = availableHeight - controlPanelInsets.top - controlPanelInsets.bottom;
                        }
                        int preferredWidth = currentResizePolicy.getPreferredWidth(availableHeight, controlPanelGap) + ribbonBandInsets.left + ribbonBandInsets.right;
                        totalWidth += preferredWidth + bandGap;
                    }
                    if (totalWidth < availableWidth) break;
                    List<RibbonBandResizePolicy> list = currToTakeFrom.getResizePolicies();
                    int currPolicyIndex = list.indexOf(currToTakeFrom.getCurrentResizePolicy());
                    if (currPolicyIndex != list.size() - 1) {
                        currToTakeFrom.setCurrentResizePolicy(list.get(currPolicyIndex + 1));
                    }
                    currToTakeFrom = resizeSequencingPolicy.next();
                }
            }
            int x = (ltr = BasicRibbonUI.this.ribbon.getComponentOrientation().isLeftToRight()) ? 1 : c.getWidth() - 1;
            for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                Insets ribbonBandInsets = ribbonBand.getInsets();
                RibbonBandResizePolicy ribbonBandResizePolicy = ribbonBand.getCurrentResizePolicy();
                AbstractBandControlPanel controlPanel = ribbonBand.getControlPanel();
                if (controlPanel == null) {
                    controlPanel = ribbonBand.getPopupRibbonBand().getControlPanel();
                }
                Insets controlPanelInsets = controlPanel.getInsets();
                int controlPanelGap = controlPanel.getUI().getLayoutGap();
                int ribbonBandHeight = availableBandHeight;
                int availableHeight = ribbonBandHeight - ribbonBandInsets.top - ribbonBandInsets.bottom - ribbonBand.getUI().getBandTitleHeight();
                if (controlPanelInsets != null) {
                    availableHeight = availableHeight - controlPanelInsets.top - controlPanelInsets.bottom;
                }
                int requiredBandWidth = ribbonBandResizePolicy.getPreferredWidth(availableHeight, controlPanelGap) + ribbonBandInsets.left + ribbonBandInsets.right;
                if (ltr) {
                    ribbonBand.setBounds(x, y, requiredBandWidth, ribbonBandHeight);
                } else {
                    ribbonBand.setBounds(x - requiredBandWidth, y, requiredBandWidth, ribbonBandHeight);
                }
                if (ribbonBand.getHeight() > 0) {
                    ribbonBand.doLayout();
                }
                if (ltr) {
                    x += requiredBandWidth + bandGap;
                    continue;
                }
                x -= requiredBandWidth + bandGap;
            }
        }
    }

    private class RibbonLayout
    implements LayoutManager {
        private RibbonLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int maxPrefBandHeight = 0;
            boolean isRibbonMinimized = BasicRibbonUI.this.ribbon.isMinimized();
            if (!isRibbonMinimized && BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getPreferredSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    maxPrefBandHeight = Math.max(maxPrefBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
            }
            int extraHeight = FlamingoUtilities.getTaskToggleButtonHeight(BasicRibbonUI.this.ribbon);
            int prefHeight = maxPrefBandHeight + extraHeight + ins.top + ins.bottom;
            return new Dimension(c.getWidth(), prefHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int width = 0;
            int maxMinBandHeight = 0;
            int gap = BasicRibbonUI.this.getBandGap();
            int extraHeight = FlamingoUtilities.getTaskToggleButtonHeight(BasicRibbonUI.this.ribbon);
            if (BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                boolean isRibbonMinimized = BasicRibbonUI.this.ribbon.isMinimized();
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getMinimumSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    RibbonBandUI bandUI = ribbonBand.getUI();
                    width += bandUI.getPreferredCollapsedWidth();
                    if (isRibbonMinimized) continue;
                    maxMinBandHeight = Math.max(maxMinBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
                width += gap * (selectedTask.getBandCount() - 1);
            } else {
                width = 50;
            }
            return new Dimension(width, maxMinBandHeight + extraHeight + ins.top + ins.bottom);
        }

        private int getAnchoredButtonsWidth(CommandButtonPresentationState state) {
            int result = 0;
            for (Component comp : BasicRibbonUI.this.anchoredButtons.getComponents()) {
                AbstractCommandButton anchoredButton = (AbstractCommandButton)comp;
                result += state.createLayoutManager((AbstractCommandButton)anchoredButton).getPreferredSize((AbstractCommandButton)anchoredButton).width;
            }
            return result;
        }

        @Override
        public void layoutContainer(Container c) {
            int taskButtonsWidth;
            int anchoredButtonPanelWidth;
            AbstractCommandButton anchoredButton;
            Insets ins = c.getInsets();
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            boolean ltr = BasicRibbonUI.this.ribbon.getComponentOrientation().isLeftToRight();
            int width = c.getWidth();
            int y = ins.top;
            int taskToggleButtonHeight = FlamingoUtilities.getTaskToggleButtonHeight(BasicRibbonUI.this.ribbon);
            int x = ltr ? ins.left : width - ins.right;
            boolean isShowingAppMenuButton = BasicRibbonUI.this.ribbon.getApplicationMenuProjection() != null;
            FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics((Font)BasicRibbonUI.this.applicationMenuButton.getFont());
            int appMenuButtonWidth = isShowingAppMenuButton ? fm.stringWidth(((Command)BasicRibbonUI.this.ribbon.getApplicationMenuCommandProjection().getContentModel()).getText()) + 40 : 0;
            int n = x = ltr ? x + 2 : x - 2;
            if (isShowingAppMenuButton) {
                x = ltr ? x + appMenuButtonWidth + 2 : x - appMenuButtonWidth - 2;
            }
            int anchoredButtonsCollapsedWidth = this.getAnchoredButtonsWidth(CommandButtonPresentationState.SMALL);
            int anchoredButtonsExpandedWidth = this.getAnchoredButtonsWidth(CommandButtonPresentationState.MEDIUM);
            TaskToggleButtonsHostPanel taskToggleButtonsStrip = (TaskToggleButtonsHostPanel)BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getView();
            taskToggleButtonsStrip.setPreferredSize(null);
            int fullPreferredContentWidth = ins.left + ins.right + 2 + (isShowingAppMenuButton ? appMenuButtonWidth : 0) + (BasicRibbonUI.this.anchoredButtons.getComponentCount() > 0 ? anchoredButtonsExpandedWidth + tabButtonGap : 0) + taskToggleButtonsStrip.getPreferredSize().width;
            if (fullPreferredContentWidth <= c.getWidth()) {
                for (Component comp : BasicRibbonUI.this.anchoredButtons.getComponents()) {
                    anchoredButton = (AbstractCommandButton)comp;
                    anchoredButton.setPresentationState(CommandButtonPresentationState.MEDIUM);
                }
                anchoredButtonPanelWidth = anchoredButtonsExpandedWidth;
            } else {
                for (Component comp : BasicRibbonUI.this.anchoredButtons.getComponents()) {
                    anchoredButton = (AbstractCommandButton)comp;
                    anchoredButton.setPresentationState(CommandButtonPresentationState.SMALL);
                }
                anchoredButtonPanelWidth = anchoredButtonsCollapsedWidth;
            }
            if (BasicRibbonUI.this.anchoredButtons.getComponentCount() > 0) {
                if (ltr) {
                    BasicRibbonUI.this.anchoredButtons.setBounds(width - ins.right - anchoredButtonPanelWidth, y, anchoredButtonPanelWidth, taskToggleButtonHeight);
                } else {
                    BasicRibbonUI.this.anchoredButtons.setBounds(ins.left, y, anchoredButtonPanelWidth, taskToggleButtonHeight);
                }
                BasicRibbonUI.this.anchoredButtons.doLayout();
            }
            if (ltr) {
                taskButtonsWidth = BasicRibbonUI.this.anchoredButtons.getComponentCount() > 0 ? BasicRibbonUI.this.anchoredButtons.getX() - tabButtonGap - x : c.getWidth() - ins.right - x;
                BasicRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x, y, taskButtonsWidth, taskToggleButtonHeight);
            } else {
                taskButtonsWidth = BasicRibbonUI.this.anchoredButtons.getComponentCount() > 0 ? x - tabButtonGap - BasicRibbonUI.this.anchoredButtons.getX() - BasicRibbonUI.this.anchoredButtons.getWidth() : x - ins.left;
                BasicRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x - taskButtonsWidth, y, taskButtonsWidth, taskToggleButtonHeight);
            }
            if (BasicRibbonUI.this.ribbon.getApplicationMenuProjection() != null) {
                BasicRibbonUI.this.applicationMenuButton.setVisible(true);
                if (ltr) {
                    BasicRibbonUI.this.applicationMenuButton.setBounds(x - appMenuButtonWidth - 2, y + 1, appMenuButtonWidth, taskToggleButtonHeight - 1);
                } else {
                    BasicRibbonUI.this.applicationMenuButton.setBounds(x + 2, y + 1, appMenuButtonWidth, taskToggleButtonHeight - 1);
                }
            } else {
                BasicRibbonUI.this.applicationMenuButton.setVisible(false);
            }
            TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = (TaskToggleButtonsHostPanel)BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getView();
            int taskToggleButtonsHostPanelMinWidth = taskToggleButtonsHostPanel.getMinimumSize().width;
            taskToggleButtonsHostPanel.setPreferredSize(new Dimension(taskToggleButtonsHostPanelMinWidth, ((BasicRibbonUI)BasicRibbonUI.this).taskToggleButtonsScrollablePanel.getBounds().height));
            BasicRibbonUI.this.taskToggleButtonsScrollablePanel.doLayout();
            y += taskToggleButtonHeight;
            if (BasicRibbonUI.this.bandScrollablePanel.getParent() == BasicRibbonUI.this.ribbon) {
                if (!BasicRibbonUI.this.ribbon.isMinimized() && BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                    Insets bandInsets = BasicRibbonUI.this.ribbon.getSelectedTask().getBandCount() == 0 ? new Insets(0, 0, 0, 0) : BasicRibbonUI.this.ribbon.getSelectedTask().getBand(0).getInsets();
                    BasicRibbonUI.this.bandScrollablePanel.setBounds(ins.left, y + bandInsets.top, c.getWidth() - 2 * ins.left - 2 * ins.right, c.getHeight() - taskToggleButtonHeight - ins.top - ins.bottom - bandInsets.top - bandInsets.bottom);
                    JPanel bandHostPanel = BasicRibbonUI.this.bandScrollablePanel.getView();
                    int bandHostPanelMinWidth = bandHostPanel.getMinimumSize().width;
                    bandHostPanel.setPreferredSize(new Dimension(bandHostPanelMinWidth, BasicRibbonUI.this.bandScrollablePanel.getBounds().height));
                    BasicRibbonUI.this.bandScrollablePanel.doLayout();
                    bandHostPanel.doLayout();
                } else {
                    BasicRibbonUI.this.bandScrollablePanel.setBounds(0, 0, 0, 0);
                }
            }
        }
    }
}

