/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BandControlPanelUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

abstract class AbstractBandControlPanelUI
extends BandControlPanelUI {
    protected AbstractBandControlPanel controlPanel;
    protected AbstractCommandButton dummy;
    public static final String TOP_ROW = "flamingo.internal.ribbonBandControlPanel.topRow";
    public static final String MID_ROW = "flamingo.internal.ribbonBandControlPanel.midRow";
    public static final String BOTTOM_ROW = "flamingo.internal.ribbonBandControlPanel.bottomRow";

    AbstractBandControlPanelUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.controlPanel = (AbstractBandControlPanel)c;
        this.dummy = (AbstractCommandButton)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText("Dummy")).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> {})).build().project(CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.BIG).build()).buildComponent();
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.controlPanel = null;
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        Border b;
        this.controlPanel.setBackground(null);
        Font font = this.controlPanel.getFont();
        if (font == null || font instanceof UIResource) {
            FontUIResource toSet = SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont();
            this.controlPanel.setFont(toSet);
        }
        if ((b = this.controlPanel.getBorder()) == null || b instanceof UIResource) {
            Insets insets = SubstanceSizeUtils.getDefaultBorderInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)this.controlPanel));
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.controlPanel);
    }

    protected abstract LayoutManager createLayoutManager();

    @Override
    public int getLayoutGap() {
        return FlamingoUtilities.getScaledSize(4, this.controlPanel.getFont().getSize(), 0.25, 1);
    }
}

