/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.AbstractPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JColorSelectorPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonPanelUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicPopupPanelUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public abstract class BasicCommandPopupMenuUI
extends BasicPopupPanelUI {
    protected AbstractPopupMenu popupMenu;
    private ChangeListener popupMenuChangeListener;
    private PopupPanelManager.PopupListener popupListener;
    private ScrollableCommandButtonPanel commandButtonPanel;
    private JScrollablePanel<JPanel> menuItemsPanel;
    public static final String FORCE_ICON = "flamingo.internal.commandPopupMenu.forceIcon";

    @Override
    public void installUI(JComponent c) {
        this.popupMenu = (AbstractPopupMenu)c;
        super.installUI(this.popupMenu);
        this.popupMenu.setLayout(this.createLayoutManager());
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.syncComponents();
    }

    protected boolean hasLeadingButtonPanel() {
        return ((JCommandPopupMenu)this.popupMenu).hasCommandButtonPanel();
    }

    protected int getMaxVisibleMenuCommands() {
        return ((CommandPopupMenuPresentationModel)((JCommandPopupMenu)this.popupMenu).getProjection().getPresentationModel()).getMaxVisibleMenuCommands();
    }

    protected void syncComponents() {
        if (this.hasLeadingButtonPanel()) {
            this.commandButtonPanel = this.createScrollableButtonPanel();
            this.popupMenu.add(this.commandButtonPanel);
        }
        final JPanel menuPanel = this.createMenuPanel();
        menuPanel.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int height = 0;
                int width = 0;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Dimension pref = parent.getComponent(i).getPreferredSize();
                    height += pref.height;
                    width = Math.max(width, pref.width);
                }
                Insets ins = parent.getInsets();
                return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets ins = parent.getInsets();
                int topY = ins.top;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component comp = parent.getComponent(i);
                    Dimension pref = comp.getPreferredSize();
                    comp.setBounds(ins.left, topY, parent.getWidth() - ins.left - ins.right, pref.height);
                    topY += pref.height;
                }
            }
        });
        this.popupMenu.putClientProperty(FORCE_ICON, null);
        List<Component> menuComponents = this.popupMenu.getMenuComponents();
        if (menuComponents != null) {
            AbstractCommandButton menuButton;
            for (Component menuComponent : menuComponents) {
                menuPanel.add(menuComponent);
            }
            boolean atLeastOneButtonHasIcon = false;
            for (Component menuComponent : menuComponents) {
                if (menuComponent instanceof JCommandMenuButton && (menuButton = (JCommandMenuButton)menuComponent).getIcon() != null) {
                    atLeastOneButtonHasIcon = true;
                }
                if (!(menuComponent instanceof JCommandToggleMenuButton)) continue;
                atLeastOneButtonHasIcon = true;
            }
            this.popupMenu.putClientProperty(FORCE_ICON, atLeastOneButtonHasIcon ? Boolean.TRUE : null);
            for (Component menuComponent : menuComponents) {
                if (menuComponent instanceof JCommandMenuButton) {
                    menuButton = (JCommandMenuButton)menuComponent;
                    menuButton.putClientProperty(FORCE_ICON, atLeastOneButtonHasIcon ? Boolean.TRUE : null);
                }
                if (!(menuComponent instanceof JCommandToggleMenuButton)) continue;
                menuButton = (JCommandToggleMenuButton)menuComponent;
                menuButton.putClientProperty(FORCE_ICON, Boolean.TRUE);
            }
        }
        this.menuItemsPanel = new JScrollablePanel<JPanel>(menuPanel, JScrollablePanel.ScrollType.VERTICALLY);
        final LayoutManager scrollableLm = this.menuItemsPanel.getLayout();
        this.menuItemsPanel.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
                scrollableLm.addLayoutComponent(name, comp);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
                scrollableLm.removeLayoutComponent(comp);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Dimension result = menuPanel.getPreferredSize();
                int maxMenuButtonCount = BasicCommandPopupMenuUI.this.getMaxVisibleMenuCommands();
                if (maxMenuButtonCount < 0 || maxMenuButtonCount >= menuPanel.getComponentCount()) {
                    return result;
                }
                int singleHeight = menuPanel.getComponent((int)0).getPreferredSize().height;
                int width = 0;
                for (int i = 0; i < menuPanel.getComponentCount(); ++i) {
                    width = Math.max(width, menuPanel.getComponent((int)i).getPreferredSize().width);
                }
                Insets ins = parent.getInsets();
                return new Dimension(width + ins.left + ins.right, singleHeight * (maxMenuButtonCount + 2) + ins.top + ins.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                scrollableLm.layoutContainer(parent);
            }
        });
        this.popupMenu.add(this.menuItemsPanel);
    }

    protected ScrollableCommandButtonPanel createScrollableButtonPanel() {
        CommandPanelPresentationModel panelPresentationModel = ((CommandPopupMenuPresentationModel)((JCommandPopupMenu)this.popupMenu).getProjection().getPresentationModel()).getPanelPresentationModel();
        return new ScrollableCommandButtonPanel(((JCommandPopupMenu)this.popupMenu).getMainButtonPanel(), panelPresentationModel.getMaxColumns(), panelPresentationModel.getMaxRows());
    }

    @Override
    protected void uninstallComponents() {
        this.popupMenu.removeAll();
        super.uninstallComponents();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupMenuChangeListener = e -> {
            this.popupMenu.removeAll();
            this.syncComponents();
        };
        this.popupMenu.addChangeListener(this.popupMenuChangeListener);
        this.popupListener = new PopupPanelManager.PopupListener(){

            @Override
            public void popupShown(PopupPanelManager.PopupEvent event) {
            }

            @Override
            public void popupHidden(PopupPanelManager.PopupEvent event) {
                if (event.getSource() instanceof JColorSelectorPopupMenu) {
                    ((ColorSelectorPopupMenuContentModel)((JColorSelectorPopupMenu)event.getSource()).getProjection().getContentModel()).getColorPreviewListener().onColorPreviewCanceled();
                }
            }
        };
        PopupPanelManager.defaultManager().addPopupListener(this.popupListener);
    }

    @Override
    protected void uninstallListeners() {
        this.popupMenu.removeChangeListener(this.popupMenuChangeListener);
        this.popupMenuChangeListener = null;
        PopupPanelManager.defaultManager().removePopupListener(this.popupListener);
        this.popupListener = null;
        super.uninstallListeners();
    }

    protected abstract JPanel createMenuPanel();

    protected LayoutManager createLayoutManager() {
        return new PopupMenuLayoutManager();
    }

    protected static abstract class MenuPanel
    extends JPanel {
        protected MenuPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            AbstractPopupMenu menu = (AbstractPopupMenu)SwingUtilities.getAncestorOfClass(AbstractPopupMenu.class, this);
            if (Boolean.TRUE.equals(menu.getClientProperty(BasicCommandPopupMenuUI.FORCE_ICON))) {
                this.paintIconGutterBackground(g);
            }
        }

        protected int getSeparatorX() {
            AbstractPopupMenu menu = (AbstractPopupMenu)SwingUtilities.getAncestorOfClass(AbstractPopupMenu.class, this);
            if (!Boolean.TRUE.equals(menu.getClientProperty(BasicCommandPopupMenuUI.FORCE_ICON))) {
                return -1;
            }
            List<Component> menuComponents = menu.getMenuComponents();
            if (menuComponents != null) {
                for (Component menuComponent : menuComponents) {
                    AbstractCommandButton button;
                    if (!(menuComponent instanceof JCommandMenuButton) && !(menuComponent instanceof JCommandToggleMenuButton) || !Boolean.TRUE.equals((button = (AbstractCommandButton)menuComponent).getClientProperty(BasicCommandPopupMenuUI.FORCE_ICON))) continue;
                    boolean ltr = button.getComponentOrientation().isLeftToRight();
                    CommandButtonLayoutManager.CommandButtonLayoutInfo layoutInfo = button.getUI().getLayoutInfo();
                    if (ltr) {
                        int iconRight = layoutInfo.iconRect.x + layoutInfo.iconRect.width;
                        int textLeft = button.getWidth();
                        for (CommandButtonLayoutManager.TextLayoutInfo tli : layoutInfo.textLayoutInfoList) {
                            textLeft = Math.min(textLeft, tli.textRect.x);
                        }
                        return (iconRight + textLeft) / 2;
                    }
                    int iconLeft = layoutInfo.iconRect.x;
                    int textRight = 0;
                    for (CommandButtonLayoutManager.TextLayoutInfo tli : layoutInfo.textLayoutInfoList) {
                        textRight = Math.max(textRight, tli.textRect.x + tli.textRect.width);
                    }
                    return (iconLeft + textRight) / 2;
                }
            }
            throw new IllegalStateException("Menu marked to show icons but no menu buttons in it");
        }

        protected abstract void paintIconGutterBackground(Graphics var1);
    }

    protected class PopupMenuLayoutManager
    implements LayoutManager {
        protected PopupMenuLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int height = 0;
            int width = 0;
            if (BasicCommandPopupMenuUI.this.commandButtonPanel != null) {
                width = ((BasicCommandPopupMenuUI)BasicCommandPopupMenuUI.this).commandButtonPanel.getPreferredSize().width;
                height = ((BasicCommandPopupMenuUI)BasicCommandPopupMenuUI.this).commandButtonPanel.getPreferredSize().height;
            }
            Dimension menuItemsPref = BasicCommandPopupMenuUI.this.getMaxVisibleMenuCommands() > 0 ? BasicCommandPopupMenuUI.this.menuItemsPanel.getPreferredSize() : ((JPanel)BasicCommandPopupMenuUI.this.menuItemsPanel.getView()).getPreferredSize();
            width = Math.max(menuItemsPref.width, width);
            Insets ins = parent.getInsets();
            return new Dimension(width + ins.left + ins.right, (height += menuItemsPref.height) + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets ins = parent.getInsets();
            int bottomY = parent.getHeight() - ins.bottom;
            Dimension menuItemsPref = BasicCommandPopupMenuUI.this.getMaxVisibleMenuCommands() > 0 ? BasicCommandPopupMenuUI.this.menuItemsPanel.getPreferredSize() : ((JPanel)BasicCommandPopupMenuUI.this.menuItemsPanel.getView()).getPreferredSize();
            BasicCommandPopupMenuUI.this.menuItemsPanel.setBounds(ins.left, bottomY - menuItemsPref.height, parent.getWidth() - ins.left - ins.right, menuItemsPref.height);
            BasicCommandPopupMenuUI.this.menuItemsPanel.doLayout();
            bottomY -= menuItemsPref.height;
            if (BasicCommandPopupMenuUI.this.commandButtonPanel != null) {
                BasicCommandPopupMenuUI.this.commandButtonPanel.setBounds(ins.left, ins.top, parent.getWidth() - ins.left - ins.right, bottomY - ins.top);
                BasicCommandPopupMenuUI.this.commandButtonPanel.invalidate();
                BasicCommandPopupMenuUI.this.commandButtonPanel.validate();
                BasicCommandPopupMenuUI.this.commandButtonPanel.doLayout();
            }
        }
    }

    protected static class ScrollableCommandButtonPanel
    extends JComponent {
        protected Dimension maxDimension;
        protected JCommandButtonPanel buttonPanel;
        protected int maxVisibleButtonRows;
        protected JScrollPane scroll;

        public ScrollableCommandButtonPanel(JCommandButtonPanel iconPanel, int maxButtonColumns, int maxVisibleButtonRows) {
            this.buttonPanel = iconPanel;
            ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).setMaxColumns(maxButtonColumns);
            this.maxVisibleButtonRows = maxVisibleButtonRows;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = iconPanel.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                for (AbstractCommandButton button : iconPanel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            this.updateMaxDimension();
            this.scroll = new JScrollPane(this.buttonPanel, 22, 31);
            this.scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.buttonPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.scroll.setOpaque(false);
            this.scroll.getViewport().setOpaque(false);
            this.setLayout(new IconPopupLayout());
            this.add(this.scroll);
            this.setBorder(new Border(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return new Insets(0, 0, 1, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.setColor(SubstanceColorSchemeUtilities.getColorScheme((Component)c, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.FILL, (ComponentState)ComponentState.ENABLED).getDarkColor());
                    g.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            });
        }

        public void updateMaxDimension() {
            if (this.buttonPanel == null) {
                return;
            }
            this.buttonPanel.setPreferredSize(null);
            Dimension prefIconPanelDim = this.buttonPanel.getPreferredSize();
            BasicCommandButtonPanelUI panelUI = (BasicCommandButtonPanelUI)this.buttonPanel.getUI();
            int titlePanelCount = ((CommandPanelPresentationModel)this.buttonPanel.getProjection().getPresentationModel()).isToShowGroupLabels() ? 1 : 0;
            this.maxDimension = new Dimension(prefIconPanelDim.width, panelUI.getPreferredHeight(this.maxVisibleButtonRows, titlePanelCount));
            this.setPreferredSize(null);
        }

        protected class IconPopupLayout
        implements LayoutManager {
            protected IconPopupLayout() {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets insets = parent.getInsets();
                int left = insets.left;
                int right = insets.right;
                int top = insets.top;
                int bottom = insets.bottom;
                ScrollableCommandButtonPanel.this.scroll.setBounds(left, top, parent.getWidth() - left - right, parent.getHeight() - top - bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Insets insets = parent.getInsets();
                int left = insets.left;
                int right = insets.right;
                int top = insets.top;
                int bottom = insets.bottom;
                Dimension controlPanelDim = ScrollableCommandButtonPanel.this.buttonPanel.getPreferredSize();
                if (controlPanelDim == null) {
                    controlPanelDim = new Dimension(0, 0);
                }
                int w = Math.min(controlPanelDim.width, ScrollableCommandButtonPanel.this.maxDimension.width) + left + right;
                int h = Math.min(controlPanelDim.height, ScrollableCommandButtonPanel.this.maxDimension.height) + top + bottom;
                if (h == ScrollableCommandButtonPanel.this.maxDimension.height + top + bottom) {
                    int scrollBarWidth = SubstanceSizeUtils.getScrollBarWidth((int)SubstanceSizeUtils.getControlFontSize());
                    w += scrollBarWidth;
                }
                return new Dimension(w, h);
            }
        }
    }
}

