/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonLayoutManagerBig;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.neon.icon.ResizableIcon;
import org.pushingpixels.substance.internal.utils.SubstanceMetricsUtilities;

public class CommandButtonLayoutManagerCustom
extends CommandButtonLayoutManagerBig {
    public CommandButtonLayoutManagerCustom(AbstractCommandButton commandButton) {
        super(commandButton);
    }

    @Override
    public int getPreferredIconSize(AbstractCommandButton commandButton) {
        return -1;
    }

    @Override
    public Dimension getPreferredSize(AbstractCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int bx = borderInsets.left + borderInsets.right;
        FontMetrics fm = SubstanceMetricsUtilities.getFontMetrics((Font)commandButton.getFont());
        JSeparator jsep = new JSeparator(0);
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        int layoutVGap = FlamingoUtilities.getVLayoutGap(commandButton);
        int title1Width = this.titlePart1 == null ? 0 : fm.stringWidth(this.titlePart1);
        int title2Width = this.titlePart2 == null ? 0 : fm.stringWidth(this.titlePart2);
        ResizableIcon icon = commandButton.getIcon();
        int iconWidth = icon == null ? 0 : icon.getIconWidth();
        int width = Math.max(iconWidth, Math.max(title1Width, title2Width + 4 * layoutHGap + jsep.getPreferredSize().width + (FlamingoUtilities.hasPopupAction(commandButton) ? 1 + fm.getHeight() / 2 : 0)));
        boolean hasIcon = commandButton.getIcon() != null;
        boolean hasText = this.titlePart1 != null;
        boolean hasPopupIcon = FlamingoUtilities.hasPopupAction(commandButton);
        int height = borderInsets.top;
        if (hasIcon) {
            height += layoutVGap;
            height += icon.getIconHeight();
            height += layoutVGap;
        }
        if (hasText) {
            height += layoutVGap;
            height += 2 * (fm.getAscent() + fm.getDescent());
            height += layoutVGap;
        }
        if (!hasText && hasPopupIcon) {
            height += layoutVGap;
            height += fm.getHeight();
            height += layoutVGap;
        }
        if (hasPopupIcon) {
            height += new JSeparator((int)0).getPreferredSize().height;
        }
        height += borderInsets.bottom;
        return new Dimension(bx + width, height -= 2 * layoutVGap);
    }
}

