/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandAction;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandStripPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonStripUI;

public class BasicCommandButtonStripUI
extends CommandButtonStripUI {
    private JCommandButtonStrip buttonStrip;
    private CommandGroup.CommandGroupListener commandGroupListener;
    private Map<Command, AbstractCommandButton> commandButtonMap = new HashMap<Command, AbstractCommandButton>();

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandButtonStripUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.buttonStrip = (JCommandButtonStrip)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.buttonStrip = null;
    }

    protected void installListeners() {
        this.commandGroupListener = new CommandGroup.CommandGroupListener(){

            @Override
            public void onCommandAdded(Command command) {
                BasicCommandButtonStripUI.this.addButton(command);
                BasicCommandButtonStripUI.this.updateButtonOrder();
            }

            @Override
            public void onCommandRemoved(Command command) {
                AbstractCommandButton commandButton = (AbstractCommandButton)BasicCommandButtonStripUI.this.commandButtonMap.get(command);
                commandButton.removeCommandListener(command.getAction());
                BasicCommandButtonStripUI.this.buttonStrip.remove(commandButton);
                BasicCommandButtonStripUI.this.commandButtonMap.remove(command);
                BasicCommandButtonStripUI.this.updateButtonOrder();
            }

            @Override
            public void onAllCommandsRemoved() {
                for (Map.Entry entry : BasicCommandButtonStripUI.this.commandButtonMap.entrySet()) {
                    ((AbstractCommandButton)entry.getValue()).removeCommandListener(((Command)entry.getKey()).getAction());
                    BasicCommandButtonStripUI.this.buttonStrip.remove((Component)entry.getValue());
                }
                BasicCommandButtonStripUI.this.commandButtonMap.clear();
            }
        };
        ((CommandGroup)this.buttonStrip.getProjection().getContentModel()).addCommandGroupListener(this.commandGroupListener);
    }

    protected void uninstallListeners() {
        ((CommandGroup)this.buttonStrip.getProjection().getContentModel()).removeCommandGroupListener(this.commandGroupListener);
        this.commandGroupListener = null;
    }

    protected void installDefaults() {
        this.buttonStrip.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.buttonStrip.setLayout(this.createLayoutManager());
        CommandGroup commandGroupModel = (CommandGroup)this.buttonStrip.getProjection().getContentModel();
        for (Command command : commandGroupModel.getCommands()) {
            this.addButton(command);
        }
        this.updateButtonOrder();
    }

    protected void uninstallComponents() {
        CommandGroup commandGroupModel = (CommandGroup)this.buttonStrip.getProjection().getContentModel();
        for (Command command : commandGroupModel.getCommands()) {
            AbstractCommandButton commandButton = this.commandButtonMap.get(command);
            CommandAction commandListener = command.getAction();
            if (commandListener != null) {
                commandButton.removeCommandListener(commandListener);
            }
            this.buttonStrip.remove(commandButton);
        }
        this.commandButtonMap.clear();
    }

    private void addButton(Command command) {
        Projection.ComponentSupplier<AbstractCommandButton, Command, CommandButtonPresentationModel> componentSupplier;
        CommandStripPresentationModel stripPresentationModel = (CommandStripPresentationModel)this.buttonStrip.getProjection().getPresentationModel();
        CommandButtonPresentationModel presentation = CommandButtonPresentationModel.withDefaults().overlayWith(CommandButtonPresentationModel.overlay().setPresentationState(stripPresentationModel.getCommandPresentationState()).setHorizontalGapScaleFactor(stripPresentationModel.getHorizontalGapScaleFactor()).setVerticalGapScaleFactor(stripPresentationModel.getVerticalGapScaleFactor()).setFlat(stripPresentationModel.isFlat()).setFocusable(stripPresentationModel.isFocusable()).setToDismissPopupsOnActivation(stripPresentationModel.isToDismissPopupsOnActivation()));
        CommandButtonPresentationModel.Overlay extraOverlay = this.buttonStrip.getProjection().getCommandOverlays().get(command);
        if (extraOverlay != null) {
            presentation = presentation.overlayWith(extraOverlay);
        }
        CommandButtonProjection<Command> commandProjection = command.project(presentation);
        Projection.ComponentCustomizer<AbstractCommandButton> componentCustomizer = this.buttonStrip.getProjection().getCommandComponentCustomizers().get(command);
        if (componentCustomizer != null) {
            commandProjection.setComponentCustomizer(componentCustomizer);
        }
        if ((componentSupplier = this.buttonStrip.getProjection().getCommandComponentSuppliers().get(command)) != null) {
            commandProjection.setComponentSupplier(componentSupplier);
        }
        AbstractCommandButton button = (AbstractCommandButton)commandProjection.buildComponent();
        this.buttonStrip.add(button);
        this.commandButtonMap.put(command, button);
    }

    private void updateButtonOrder() {
        int buttonCount = this.buttonStrip.getButtonCount();
        if (buttonCount == 0) {
            return;
        }
        if (buttonCount == 1) {
            this.buttonStrip.getButton(0).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.ONLY);
        } else {
            this.buttonStrip.getButton(0).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.FIRST);
            for (int i = 1; i < buttonCount - 1; ++i) {
                this.buttonStrip.getButton(i).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE);
            }
            this.buttonStrip.getButton(buttonCount - 1).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.LAST);
        }
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonStripLayout();
    }

    private class ButtonStripLayout
    implements LayoutManager {
        private ButtonStripLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int i;
            int width = 0;
            int height = 0;
            if (((CommandStripPresentationModel)BasicCommandButtonStripUI.this.buttonStrip.getProjection().getPresentationModel()).getOrientation() == CommandStripPresentationModel.StripOrientation.HORIZONTAL) {
                for (i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    width += ((BasicCommandButtonStripUI)BasicCommandButtonStripUI.this).buttonStrip.getButton((int)i).getPreferredSize().width;
                    height = Math.max(height, ((BasicCommandButtonStripUI)BasicCommandButtonStripUI.this).buttonStrip.getButton((int)i).getPreferredSize().height);
                }
            } else {
                for (i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    height += ((BasicCommandButtonStripUI)BasicCommandButtonStripUI.this).buttonStrip.getButton((int)i).getPreferredSize().height;
                    width = Math.max(width, ((BasicCommandButtonStripUI)BasicCommandButtonStripUI.this).buttonStrip.getButton((int)i).getPreferredSize().width);
                }
            }
            Insets ins = c.getInsets();
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            if (BasicCommandButtonStripUI.this.buttonStrip.getButtonCount() == 0) {
                return;
            }
            Insets ins = c.getInsets();
            int height = c.getHeight() - ins.top - ins.bottom;
            int width = c.getWidth() - ins.left - ins.right;
            if (((CommandStripPresentationModel)BasicCommandButtonStripUI.this.buttonStrip.getProjection().getPresentationModel()).getOrientation() == CommandStripPresentationModel.StripOrientation.HORIZONTAL) {
                int totalPreferredWidth = 0;
                for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                    totalPreferredWidth += currButton.getPreferredSize().width;
                }
                int deltaX = (width - totalPreferredWidth) / BasicCommandButtonStripUI.this.buttonStrip.getButtonCount();
                if (BasicCommandButtonStripUI.this.buttonStrip.getComponentOrientation().isLeftToRight()) {
                    int x = ins.left;
                    for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                        AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                        currButton.setBounds(x, ins.top, currButton.getPreferredSize().width + deltaX, height);
                        x += currButton.getPreferredSize().width + deltaX;
                    }
                } else {
                    int x = c.getWidth() - ins.right;
                    for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                        AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                        int buttonWidth = currButton.getPreferredSize().width + deltaX;
                        currButton.setBounds(x - buttonWidth, ins.top, buttonWidth, height);
                        x -= buttonWidth;
                    }
                }
            } else {
                int totalPreferredHeight = 0;
                for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                    totalPreferredHeight += currButton.getPreferredSize().height;
                }
                float deltaY = (float)(height - totalPreferredHeight) / (float)BasicCommandButtonStripUI.this.buttonStrip.getButtonCount();
                float y = ins.top;
                for (int i = 0; i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount(); ++i) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                    float buttonHeight = (float)currButton.getPreferredSize().height + deltaY;
                    currButton.setBounds(ins.left, (int)y, width, (int)Math.ceil(buttonHeight));
                    y += buttonHeight;
                }
            }
        }
    }
}

