/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class RibbonTaskToggleButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> imageCache = new LazyResettableHashMap("Flamingo.RibbonTaskToggleButtonBackgroundDelegate");

    private static synchronized BufferedImage getTaskToggleButtonBackground(JRibbonTaskToggleButton button, int width, int height) {
        JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, button);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)button.getUI();
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        ComponentState currState = ComponentState.getState((ButtonModel)button.getActionModel(), (JComponent)button, (boolean)true);
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)button);
        SubstanceSlices.DecorationAreaType buttonDecorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType((Component)button);
        SubstanceDecorationPainter decorationPainter = skin.getDecorationPainter();
        SubstanceColorScheme baseFillScheme = activeStates.size() == 1 && currState != ComponentState.ENABLED ? SubstanceColorSchemeUtilities.getColorScheme((Component)button, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.FILL, (ComponentState)currState) : skin.getBackgroundColorScheme(buttonDecorationAreaType);
        SubstanceColorScheme baseBorderScheme = skin.getColorScheme((Component)ribbon, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
        SubstanceBorderPainter borderPainter = skin.getBorderPainter();
        JRibbon parent = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, button);
        RibbonTask selectedTask = parent.getSelectedTask();
        AbstractRibbonBand band = selectedTask.getBandCount() == 0 ? null : selectedTask.getBand(0);
        Color bgColor = band != null ? band.getBackground() : parent.getBackground();
        HashMapKey baseKey = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), borderPainter.getDisplayName(), decorationPainter.getDisplayName(), button.getParent().getBackground().getRGB(), button.getActionModel(), button.getContextualGroupHueColor(), button.getActionModel(), ribbon.isMinimized(), bgColor});
        BufferedImage baseLayer = (BufferedImage)imageCache.get(baseKey);
        if (baseLayer == null) {
            baseLayer = RibbonTaskToggleButtonBackgroundDelegate.getSingleLayer(button, width, height, baseFillScheme, baseBorderScheme, borderPainter);
            imageCache.put(baseKey, (Object)baseLayer);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D g2d = result.createGraphics();
        NeonCortex.drawImage((Graphics)g2d, (Image)baseLayer, (int)0, (int)0);
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState == ComponentState.ENABLED || (contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution()) == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)button, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.FILL, (ComponentState)activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)ribbon, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), borderPainter.getDisplayName(), decorationPainter.getDisplayName(), button.getParent().getBackground().getRGB(), button.getActionModel(), button.getContextualGroupHueColor(), button.getActionModel(), ribbon.isMinimized(), bgColor});
            BufferedImage layer = (BufferedImage)imageCache.get(key);
            if (layer == null) {
                layer = RibbonTaskToggleButtonBackgroundDelegate.getSingleLayer(button, width, height, fillScheme, borderScheme, borderPainter);
                imageCache.put(key, (Object)layer);
            }
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            NeonCortex.drawImage((Graphics)g2d, (Image)layer, (int)0, (int)0);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getSingleLayer(JRibbonTaskToggleButton button, int width, int height, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, SubstanceBorderPainter borderPainter) {
        SubstanceSlices.DecorationAreaType buttonDecorationAreaType;
        EnumSet<SubstanceSlices.Side> bottom = EnumSet.of(SubstanceSlices.Side.BOTTOM);
        Color contextualGroupHueColor = button.getContextualGroupHueColor();
        if (contextualGroupHueColor != null) {
            fillScheme = SubstanceColorSchemeUtilities.getShiftedScheme((SubstanceColorScheme)fillScheme, (Color)contextualGroupHueColor, (double)0.25, null, (double)0.0);
        }
        float radius = SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)button), (float)3.0f, (int)6, (float)1.0f);
        float borderDelta = 2.0f * SubstanceSizeUtils.getBorderStrokeWidth();
        float borderInsets = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline((float)width, (float)((float)(height + 2) + borderDelta), (float)radius, bottom, (float)borderInsets);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)width, (int)(height + 2));
        Graphics2D graphics = result.createGraphics();
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin((Component)button);
        if (skin.isRegisteredAsDecorationArea(buttonDecorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType((Component)button))) {
            DecorationPainterUtils.paintDecorationArea((Graphics)graphics, (Component)button, (Shape)contour, (SubstanceSlices.DecorationAreaType)buttonDecorationAreaType, (SubstanceColorScheme)fillScheme, (boolean)false);
        } else {
            graphics.setColor(fillScheme.getBackgroundFillColor());
            graphics.fill(contour);
        }
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline((float)width, (float)((float)(height + 2) + borderDelta), (float)radius, bottom, (float)(borderThickness + borderInsets));
        borderPainter.paintBorder((Graphics)graphics, (Component)button, (float)width, (float)(height + 2), (Shape)contour, (Shape)contourInner, borderScheme);
        graphics.dispose();
        return result;
    }

    public void updateTaskToggleButtonBackground(Graphics g, JRibbonTaskToggleButton button) {
        Graphics2D g2d = (Graphics2D)g.create();
        int width = button.getWidth();
        int height = button.getHeight();
        BufferedImage ribbonBackground = RibbonTaskToggleButtonBackgroundDelegate.getTaskToggleButtonBackground(button, width, height);
        TransitionAwareUI ui = (TransitionAwareUI)button.getUI();
        StateTransitionTracker stateTransitionTracker = ui.getTransitionTracker();
        float extraActionAlpha = 0.0f;
        for (Map.Entry activeEntry : stateTransitionTracker.getModelStateInfo().getStateContributionMap().entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
            extraActionAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
        }
        g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)button, (float)extraActionAlpha, (Graphics)g));
        NeonCortex.drawImage((Graphics)g2d, (Image)ribbonBackground, (int)0, (int)0);
        g2d.dispose();
    }
}

