/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceRibbonUI
extends BasicRibbonUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceRibbonUI();
    }

    private SubstanceRibbonUI() {
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.ribbon, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.HEADER);
        Color backgr = this.ribbon.getBackground();
        if (backgr == null || backgr instanceof UIResource) {
            Color toSet = SubstanceColorSchemeUtilities.getColorScheme((Component)this.ribbon, (ComponentState)ComponentState.ENABLED).getBackgroundFillColor();
            this.ribbon.setBackground(new ColorUIResource(toSet));
        }
    }

    @Override
    protected void uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType((JComponent)this.ribbon);
        super.uninstallDefaults();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.ribbon, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.HEADER);
        SubstanceCortex.ComponentOrParentChainScope.setDecorationType((JComponent)this.bandScrollablePanel, (SubstanceSlices.DecorationAreaType)SubstanceSlices.DecorationAreaType.GENERAL);
    }

    @Override
    protected BasicRibbonUI.TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new SubstanceTaskToggleButtonsHostPanel();
    }

    @Override
    protected void paintBackground(Graphics g) {
        BackgroundPaintingUtils.update((Graphics)g, (JComponent)this.ribbon, (boolean)false);
    }

    @Override
    protected int getTabButtonGap() {
        return SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)this.ribbon), (int)super.getTabButtonGap(), (int)3, (int)1, (boolean)false);
    }

    @Override
    protected void syncApplicationMenuTips() {
        if (this.applicationMenuButton == null || !this.applicationMenuButton.isVisible()) {
            return;
        }
        JRibbonRootPane ribbonRootPane = (JRibbonRootPane)SwingUtilities.getRootPane(this.ribbon);
        if (ribbonRootPane == null) {
            return;
        }
        JRibbonFrame ribbonFrame = (JRibbonFrame)ribbonRootPane.getParent();
        JRibbon ribbon = ribbonFrame.getRibbon();
        if (ribbon != null) {
            this.applicationMenuButton.setPopupRichTooltip(((Command)ribbon.getApplicationMenuCommandProjection().getContentModel()).getSecondaryRichTooltip());
            this.applicationMenuButton.setPopupKeyTip(((CommandButtonPresentationModel)ribbon.getApplicationMenuCommandProjection().getPresentationModel()).getPopupKeyTip());
        }
    }

    @Override
    protected void paintMinimizedRibbonSeparator(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(0, this.ribbon.getHeight() - 1);
        SeparatorPainterUtils.paintSeparator((Component)this.ribbon, (Graphics)g2d, (int)this.ribbon.getWidth(), (int)0, (int)0, (boolean)false, (int)0);
        g2d.dispose();
    }

    protected class SubstanceTaskToggleButtonsHostPanel
    extends BasicRibbonUI.TaskToggleButtonsHostPanel {
        protected SubstanceTaskToggleButtonsHostPanel() {
            super(SubstanceRibbonUI.this);
        }

        @Override
        protected void paintContextualTaskGroupOutlines(Graphics g, RibbonContextualTaskGroup group, Rectangle groupBounds) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(groupBounds.x, 0);
            SeparatorPainterUtils.paintSeparator((Component)SubstanceRibbonUI.this.ribbon, (Graphics)g2d, (int)2, (int)(groupBounds.height * 3 / 4), (int)1, (boolean)false, (int)0, (int)(groupBounds.height / 3), (boolean)true);
            g2d.translate(groupBounds.width - 1, 0);
            SeparatorPainterUtils.paintSeparator((Component)SubstanceRibbonUI.this.ribbon, (Graphics)g2d, (int)2, (int)(groupBounds.height * 3 / 4), (int)1, (boolean)false, (int)0, (int)(groupBounds.height / 3), (boolean)true);
            g2d.dispose();
        }

        @Override
        protected void paintTaskOutlines(Graphics g) {
            int i;
            Graphics2D g2d = (Graphics2D)g.create();
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)SubstanceRibbonUI.this.ribbon, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.ENABLED);
            HashSet<RibbonTask> tasksWithTrailingSeparators = new HashSet<RibbonTask>();
            for (i = 0; i < SubstanceRibbonUI.this.ribbon.getTaskCount() - 1; ++i) {
                RibbonTask task = SubstanceRibbonUI.this.ribbon.getTask(i);
                tasksWithTrailingSeparators.add(task);
            }
            for (i = 0; i < SubstanceRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = SubstanceRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (!SubstanceRibbonUI.this.ribbon.isVisible(group)) continue;
                for (int j = 0; j < group.getTaskCount() - 1; ++j) {
                    RibbonTask task = group.getTask(j);
                    tasksWithTrailingSeparators.add(task);
                }
            }
            for (RibbonTask taskWithTrailingSeparator : tasksWithTrailingSeparators) {
                JComponent taskToggleButton = (JComponent)SubstanceRibbonUI.this.taskToggleButtons.get(taskWithTrailingSeparator);
                Rectangle bounds = taskToggleButton.getBounds();
                int x = bounds.x + bounds.width + SubstanceRibbonUI.this.getTabButtonGap() / 2 - 1;
                g2d.translate(x, 0);
                SeparatorPainterUtils.paintSeparator((Component)SubstanceRibbonUI.this.ribbon, (Graphics)g2d, (SubstanceColorScheme)scheme, (int)2, (int)this.getHeight(), (int)1, (boolean)false, (int)(this.getHeight() / 3), (int)0, (boolean)true);
                g2d.translate(-x, 0);
            }
            g2d.dispose();
        }
    }
}

