/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandToggleButtonUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceCommandToggleMenuButtonUI
extends SubstanceCommandToggleButtonUI {
    public static ComponentUI createUI(JComponent c) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)c);
        SubstanceCortex.ComponentScope.setButtonStraightSides((JComponent)c, EnumSet.allOf(SubstanceSlices.Side.class));
        return new SubstanceCommandToggleMenuButtonUI();
    }

    private SubstanceCommandToggleMenuButtonUI() {
    }

    @Override
    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        boolean isSelected = this.commandButton.getActionModel().isSelected();
        if (isSelected) {
            Graphics2D g2d = (Graphics2D)g.create();
            float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth();
            Rectangle2D.Float extended = new Rectangle2D.Float((float)iconRect.x - borderDelta / 2.0f, (float)iconRect.y - borderDelta / 2.0f, (float)iconRect.width + borderDelta, (float)iconRect.height + borderDelta);
            ComponentState currState = this.commandButton.getActionModel().isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)this.commandButton);
            fillPainter.paintContourBackground((Graphics)g2d, (Component)this.commandButton, extended.x + extended.width, extended.y + extended.height, (Shape)extended, false, fillScheme, false);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)currState);
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)this.commandButton);
            borderPainter.paintBorder((Graphics)g2d, (Component)this.commandButton, extended.x + extended.width, extended.y + extended.height, (Shape)extended, null, borderScheme);
            g2d.dispose();
        }
        super.paintButtonIcon(g, iconRect);
        Icon iconToPaint = this.getIconToPaint();
        if (isSelected && iconToPaint == null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            ComponentState currState = this.commandButton.getActionModel().isEnabled() ? ComponentState.SELECTED : ComponentState.DISABLED_SELECTED;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            g2d.setColor(fillScheme.getForegroundColor());
            int iw = iconRect.width;
            int ih = iconRect.height;
            GeneralPath path = new GeneralPath();
            path.moveTo(0.2f * (float)iw, 0.5f * (float)ih);
            path.lineTo(0.42f * (float)iw, 0.8f * (float)ih);
            path.lineTo(0.8f * (float)iw, 0.2f * (float)ih);
            g2d.translate(iconRect.x, iconRect.y);
            BasicStroke stroke = new BasicStroke(0.12f * (float)iw, 1, 1);
            g2d.setStroke(stroke);
            g2d.draw(path);
            g2d.dispose();
        }
    }

    @Override
    protected boolean isPaintingBackground() {
        boolean isActionRollover = this.commandButton.getActionModel().isRollover();
        if (isActionRollover || !this.commandButton.isFlat()) {
            return true;
        }
        return this.getActionTransitionTracker().getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected Color getForegroundColor(StateTransitionTracker.ModelStateInfo modelStateInfo) {
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)modelStateInfo.getCurrModelState());
            fgColor = SubstanceCommandToggleMenuButtonUI.getMenuButtonForegroundColor(this.commandButton, modelStateInfo);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                fgColor = SubstanceColorUtilities.getInterpolatedColor((Color)fgColor, (Color)bgFillColor, (double)buttonAlpha);
            }
        }
        return fgColor;
    }

    private static Color getMenuButtonForegroundColor(AbstractCommandButton menuButton, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        Map activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        SubstanceSlices.ColorSchemeAssociationKind currAssocKind = SubstanceSlices.ColorSchemeAssociationKind.FILL;
        if (!currState.isDisabled() && currState != ComponentState.ENABLED && !currState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER)) {
            currAssocKind = SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT;
        }
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)menuButton, (SubstanceSlices.ColorSchemeAssociationKind)currAssocKind, (ComponentState)currState);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return colorScheme.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            float alpha = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
            SubstanceSlices.ColorSchemeAssociationKind assocKind = SubstanceSlices.ColorSchemeAssociationKind.FILL;
            if (!activeState.isDisabled() && activeState != ComponentState.ENABLED && !activeState.isFacetActive(SubstanceSlices.ComponentStateFacet.ROLLOVER)) {
                assocKind = SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT;
            }
            SubstanceColorScheme activeColorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)menuButton, (SubstanceSlices.ColorSchemeAssociationKind)assocKind, (ComponentState)activeState);
            Color activeForeground = activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }
}

