/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.substance.common.GlowingResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.TransitionAwareResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.flamingo.internal.substance.utils.CommandButtonBackgroundDelegate;
import org.pushingpixels.flamingo.internal.substance.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.flamingo.internal.substance.utils.SubstanceDisabledResizableIcon;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.neon.icon.ResizableIcon;
import org.pushingpixels.neon.icon.ResizableIconUIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.ImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.substance.internal.widget.animation.effects.GhostingListener;

public class SubstanceCommandButtonUI
extends BasicCommandButtonUI
implements ActionPopupTransitionAwareUI {
    private PropertyChangeListener substancePropertyListener;
    private GhostingListener substanceModelChangeListener;
    private CommandButtonVisualStateTracker substanceVisualStateTracker;
    private ButtonModel overallRolloverModel = new DefaultButtonModel();
    private RolloverControlListener substanceOverallRolloverListener;
    private StateTransitionTracker overallStateTransitionTracker;
    private GlowingResizableIcon glowingIcon;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceCommandButtonUI((JCommandButton)comp);
    }

    SubstanceCommandButtonUI(JCommandButton button) {
        this.overallRolloverModel.setArmed(false);
        this.overallRolloverModel.setSelected(false);
        this.overallRolloverModel.setPressed(false);
        this.overallRolloverModel.setRollover(false);
        this.overallRolloverModel.setEnabled(button.isEnabled());
        this.overallStateTransitionTracker = new StateTransitionTracker((JComponent)button, this.overallRolloverModel);
        this.substanceVisualStateTracker = new CommandButtonVisualStateTracker();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        SubstanceCortex.ComponentScope.setButtonShaper((JComponent)this.commandButton, (SubstanceButtonShaper)ClassicButtonShaper.INSTANCE);
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void updateBorder() {
        Border currBorder = this.commandButton.getBorder();
        if (currBorder == null || currBorder instanceof UIResource) {
            Insets extra = SubstanceSizeUtils.getDefaultBorderInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton));
            double hgapScaleFactor = this.commandButton.getHGapScaleFactor();
            double vgapScaleFactor = this.commandButton.getVGapScaleFactor();
            int top = 1 + (int)(vgapScaleFactor * (double)extra.top);
            int left = 2 + (int)(hgapScaleFactor * (double)(1 + extra.left));
            int bottom = 0 + (int)(vgapScaleFactor * (double)extra.bottom);
            int right = 2 + (int)(hgapScaleFactor * (double)(1 + extra.right));
            this.commandButton.setBorder(new BorderUIResource.EmptyBorderUIResource(top, left, bottom, right));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceVisualStateTracker.installListeners(this.commandButton);
        this.substancePropertyListener = evt -> {
            if ("actionModel".equals(evt.getPropertyName())) {
                if (this.substanceModelChangeListener != null) {
                    this.substanceModelChangeListener.unregisterListeners();
                }
                this.substanceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
                this.substanceModelChangeListener.registerListeners();
            }
            if ("icon".equals(evt.getPropertyName())) {
                this.trackGlowingIcon();
            }
        };
        this.commandButton.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceModelChangeListener = new GhostingListener((JComponent)this.commandButton, (ButtonModel)this.commandButton.getActionModel());
        this.substanceModelChangeListener.registerListeners();
        this.substanceOverallRolloverListener = new RolloverControlListener((TransitionAwareUI)this, this.overallRolloverModel);
        this.commandButton.addMouseListener((MouseListener)this.substanceOverallRolloverListener);
        this.commandButton.addMouseMotionListener((MouseMotionListener)this.substanceOverallRolloverListener);
        this.overallStateTransitionTracker.registerModelListeners();
        this.trackGlowingIcon();
    }

    @Override
    protected void uninstallListeners() {
        this.substanceVisualStateTracker.uninstallListeners(this.commandButton);
        this.substanceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceModelChangeListener.unregisterListeners();
        this.substanceModelChangeListener = null;
        this.commandButton.removeMouseListener((MouseListener)this.substanceOverallRolloverListener);
        this.commandButton.removeMouseMotionListener((MouseMotionListener)this.substanceOverallRolloverListener);
        this.substanceOverallRolloverListener = null;
        this.overallStateTransitionTracker.unregisterModelListeners();
        super.uninstallListeners();
    }

    private void trackGlowingIcon() {
        ResizableIcon currIcon = this.commandButton.getIcon();
        if (currIcon instanceof GlowingResizableIcon) {
            return;
        }
        if (currIcon == null) {
            return;
        }
        boolean isPopupOnly = ((JCommandButton)this.commandButton).getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY;
        StateTransitionTracker tracker = isPopupOnly ? this.substanceVisualStateTracker.getPopupStateTransitionTracker() : this.substanceVisualStateTracker.getActionStateTransitionTracker();
        this.glowingIcon = new GlowingResizableIcon(currIcon, tracker.getIconGlowTracker());
    }

    private void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        if (SubstanceCoreUtilities.isButtonNeverPainted((JComponent)this.commandButton)) {
            return;
        }
        ActionButtonModel actionModel = this.commandButton.getActionModel();
        PopupButtonModel popupModel = ((JCommandButton)this.commandButton).getPopupModel();
        Rectangle actionArea = this.getLayoutInfo().actionClickArea;
        Rectangle popupArea = this.getLayoutInfo().popupClickArea;
        BufferedImage fullAlphaBackground = CommandButtonBackgroundDelegate.getCombinedCommandButtonBackground(this.commandButton, actionModel, actionArea, popupModel, popupArea);
        boolean isFlat = this.commandButton.isFlat() && !((JCommandButton)this.commandButton).getPopupModel().isPopupShowing();
        boolean isSpecial = isFlat || !this.commandButton.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                float extraActionAlpha = 0.0f;
                for (Map.Entry activeEntry : this.getActionTransitionTracker().getModelStateInfo().getStateContributionMap().entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraActionAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
                float extraPopupAlpha = 0.0f;
                for (Map.Entry activeEntry : this.getPopupTransitionTracker().getModelStateInfo().getStateContributionMap().entrySet()) {
                    ComponentState activeState = (ComponentState)activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraPopupAlpha += ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                }
                extraAlpha = Math.max(extraActionAlpha, extraPopupAlpha);
            } else {
                ComponentState actionAreaState = ComponentState.getState((ButtonModel)actionModel, (JComponent)this.commandButton);
                if (actionAreaState.isDisabled()) {
                    extraAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)actionAreaState);
                }
            }
        }
        if ((extraAlpha = Math.min(1.0f, extraAlpha)) > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)this.commandButton, (float)extraAlpha, (Graphics)graphics));
            NeonCortex.drawImage((Graphics)g2d, (Image)fullAlphaBackground, (int)0, (int)0);
            g2d.dispose();
        }
    }

    private void paintButtonIcon(Graphics g, Rectangle iconRect) {
        JCommandButton jcb = (JCommandButton)this.commandButton;
        ResizableIcon regular = jcb.getIcon();
        if (this.toUseDisabledIcon() && jcb.getDisabledIcon() != null && regular != null && !regular.getClass().isAnnotationPresent(TransitionAware.class)) {
            regular = jcb.getDisabledIcon();
        }
        if (iconRect == null || regular == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        if (regular != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            GhostPaintingUtils.paintGhostIcon((Graphics2D)g2d, (Component)jcb, (Icon)regular, (Rectangle)iconRect);
            g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)jcb, (Graphics)g));
            StateTransitionTracker tracker = this.substanceVisualStateTracker.getActionStateTransitionTracker();
            ButtonModel model = this.commandButton.getActionModel();
            if (jcb.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY) {
                tracker = this.substanceVisualStateTracker.getPopupStateTransitionTracker();
                model = jcb.getPopupModel();
            }
            CommandButtonBackgroundDelegate.paintCommandButtonIcon(g2d, iconRect, jcb, (Icon)regular, this.glowingIcon, model, tracker);
            g2d.dispose();
        }
    }

    private void paintButtonHorizontalSeparator(Graphics graphics, Rectangle separatorArea) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(0, separatorArea.y);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.getState((ButtonModel)this.commandButton.getActionModel(), (JComponent)this.commandButton));
        float fadeAlpha = this.getSeparatorAlpha();
        g2d.setComposite(AlphaComposite.SrcOver.derive(fadeAlpha));
        SeparatorPainterUtils.paintSeparator((Component)this.commandButton, (Graphics)g2d, (SubstanceColorScheme)colorScheme, (int)this.commandButton.getWidth(), (int)1, (int)0, (boolean)true, (int)4, (int)4, (boolean)true);
        g2d.dispose();
    }

    private void paintButtonVerticalSeparator(Graphics graphics, Rectangle separatorArea) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.translate(separatorArea.x, 0);
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, (ComponentState)ComponentState.getState((ButtonModel)this.commandButton.getActionModel(), (JComponent)this.commandButton));
        float fadeAlpha = this.getSeparatorAlpha();
        g2d.setComposite(AlphaComposite.SrcOver.derive(fadeAlpha));
        SeparatorPainterUtils.paintSeparator((Component)this.commandButton, (Graphics)g2d, (SubstanceColorScheme)colorScheme, (int)1, (int)this.commandButton.getHeight(), (int)1, (boolean)true, (int)4, (int)4, (boolean)true);
        g2d.dispose();
    }

    @Override
    protected boolean isPaintingBackground() {
        if (super.isPaintingBackground()) {
            return true;
        }
        return this.overallStateTransitionTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected boolean isPaintingSeparators() {
        if (super.isPaintingSeparators()) {
            return true;
        }
        boolean hasIcon = this.commandButton.getIcon() != null;
        return hasIcon && this.overallStateTransitionTracker.getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected ResizableIcon createPopupActionIcon() {
        int fontSize = SubstanceSizeUtils.getComponentFontSize((Component)this.commandButton);
        int arrowIconHeight = (int)SubstanceSizeUtils.getArrowIconHeight((int)fontSize);
        int arrowIconWidth = (int)SubstanceSizeUtils.getArrowIconWidth((int)fontSize);
        TransitionAwareResizableIcon icon = new TransitionAwareResizableIcon(this.commandButton, () -> this.getPopupTransitionTracker(), (scheme, width, height) -> {
            CommandButtonPresentationModel.PopupOrientationKind orientation = ((JCommandButton)this.commandButton).getPopupOrientationKind();
            int direction = orientation == CommandButtonPresentationModel.PopupOrientationKind.DOWNWARD ? 5 : (this.commandButton.getComponentOrientation().isLeftToRight() ? 3 : 7);
            ImageWrapperIcon result = SubstanceImageCreator.getArrowIcon((float)width, (float)height, (float)(SubstanceSizeUtils.getArrowStrokeWidth((int)fontSize) - 0.5f), (int)direction, (SubstanceColorScheme)scheme);
            return result;
        }, new Dimension(arrowIconWidth, arrowIconHeight));
        return icon;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean useActionAreaForFg;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(this.commandButton.getFont());
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton);
        this.commandButton.putClientProperty("icon.bounds", this.layoutInfo.iconRect);
        if (this.isPaintingBackground()) {
            this.paintButtonBackground(g2d, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        }
        StateTransitionTracker transitionTrackerForFg = (useActionAreaForFg = this.layoutInfo.isTextInActionArea) ? this.getActionTransitionTracker() : this.getPopupTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfoForFg = transitionTrackerForFg.getModelStateInfo();
        ComponentState currStateForFg = modelStateInfoForFg.getCurrModelState();
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)currStateForFg);
            fgColor = SubstanceTextUtilities.getForegroundColor((JComponent)this.commandButton, (String)this.commandButton.getText(), (StateTransitionTracker.ModelStateInfo)modelStateInfoForFg, (float)buttonAlpha);
        }
        if (this.layoutInfo.textLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo mainTextLayoutInfo : this.layoutInfo.textLayoutInfoList) {
                if (mainTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)c, (Rectangle)mainTextLayoutInfo.textRect, (String)mainTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)fgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.extraTextLayoutInfoList != null) {
            Color disabledFgColor = SubstanceColorSchemeUtilities.getColorScheme((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED).getForegroundColor();
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.commandButton, (ComponentState)ComponentState.DISABLED_UNSELECTED);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor((Component)this.commandButton);
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)bgFillColor, (double)buttonAlpha);
            }
            if (currStateForFg.isDisabled()) {
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)SubstanceColorUtilities.getBackgroundFillColor((Component)c), (double)0.5);
            }
            disabledFgColor = SubstanceColorUtilities.getInterpolatedColor((Color)disabledFgColor, (Color)fgColor, (double)0.5);
            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : this.layoutInfo.extraTextLayoutInfoList) {
                if (extraTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText((Graphics)g2d, (JComponent)c, (Rectangle)extraTextLayoutInfo.textRect, (String)extraTextLayoutInfo.text, (int)-1, (Font)g2d.getFont(), (Color)disabledFgColor, (Rectangle)g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.iconRect != null) {
            this.paintButtonIcon(g2d, this.layoutInfo.iconRect);
        }
        if (this.layoutInfo.popupActionRect.getWidth() > 0.0) {
            this.paintPopupActionIcon(g2d, this.layoutInfo.popupActionRect);
        }
        if (this.isPaintingSeparators() && this.layoutInfo.separatorArea != null) {
            if (this.layoutInfo.separatorOrientation == CommandButtonLayoutManager.CommandButtonSeparatorOrientation.HORIZONTAL) {
                this.paintButtonHorizontalSeparator(g2d, this.layoutInfo.separatorArea);
            } else {
                this.paintButtonVerticalSeparator(g2d, this.layoutInfo.separatorArea);
            }
        }
        g2d.dispose();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.commandButton.getFont());
        this.paint(g2d, c);
        g2d.dispose();
    }

    private void paintPopupActionIcon(Graphics g, Rectangle popupActionRect) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.popupActionIcon.paintIcon((Component)this.commandButton, (Graphics)g2d, popupActionRect.x + (popupActionRect.width - this.popupActionIcon.getIconWidth()) / 2, popupActionRect.y + (popupActionRect.height - this.popupActionIcon.getIconHeight()) / 2);
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractCommandButton button = (AbstractCommandButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper((Component)button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        if (button.getPresentationState() == CommandButtonPresentationState.MEDIUM && SwingUtilities.getAncestorOfClass(JRibbon.class, button) == null && SwingUtilities.getAncestorOfClass(JBreadcrumbBar.class, button) == null && SwingUtilities.getAncestorOfClass(JCommandPopupMenu.class, button) == null) {
            JButton dummy = new JButton(button.getText(), (Icon)button.getIcon());
            Dimension result = shaper.getPreferredSize((AbstractButton)dummy, superPref);
            if (FlamingoUtilities.hasPopupAction(button)) {
                result.width = superPref.width;
            }
            return result;
        }
        return superPref;
    }

    private float getSeparatorAlpha() {
        ComponentState actionAreaState = this.getActionTransitionTracker().getModelStateInfo().getCurrModelState();
        if (!actionAreaState.isFacetActive(SubstanceSlices.ComponentStateFacet.SELECTION) && !actionAreaState.isDisabled()) {
            float actionRolloverCycle = this.getActionTransitionTracker().getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER);
            float popupRolloverCycle = this.getPopupTransitionTracker().getFacetStrength(SubstanceSlices.ComponentStateFacet.ROLLOVER);
            return Math.min(1.0f, actionRolloverCycle + popupRolloverCycle);
        }
        return 1.0f;
    }

    @Override
    protected void syncDisabledIcon() {
        ResizableIcon currDisabledIcon = this.commandButton.getDisabledIcon();
        ResizableIcon icon = this.commandButton.getIcon();
        if (currDisabledIcon == null || currDisabledIcon instanceof UIResource && !currDisabledIcon.getClass().isAnnotationPresent(TransitionAware.class)) {
            if (icon != null) {
                this.commandButton.setDisabledIcon((ResizableIcon)new ResizableIconUIResource((ResizableIcon)new SubstanceDisabledResizableIcon(icon)));
            } else {
                this.commandButton.setDisabledIcon(null);
            }
        } else if (icon != null) {
            this.commandButton.getDisabledIcon().setDimension(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.overallStateTransitionTracker;
    }

    public boolean isInside(MouseEvent me) {
        boolean inAction = this.layoutInfo.actionClickArea != null && this.layoutInfo.actionClickArea.contains(me.getPoint());
        boolean inPopup = this.layoutInfo.popupClickArea != null && this.layoutInfo.popupClickArea.contains(me.getPoint());
        return inAction || inPopup;
    }

    @Override
    public StateTransitionTracker getActionTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    @Override
    public StateTransitionTracker getPopupTransitionTracker() {
        return this.substanceVisualStateTracker.getPopupStateTransitionTracker();
    }
}

