/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonPanelUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceCommandButtonPanelUI
extends BasicCommandButtonPanelUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceCommandButtonPanelUI();
    }

    private SubstanceCommandButtonPanelUI() {
    }

    @Override
    protected Insets getGroupInsets() {
        int extraPadding = SubstanceSizeUtils.getExtraPadding((int)SubstanceSizeUtils.getComponentFontSize((Component)this.buttonPanel));
        Insets result = BasicCommandButtonPanelUI.GROUP_INSETS;
        return new Insets(result.top + extraPadding, result.left + extraPadding, result.bottom + extraPadding, result.right + extraPadding);
    }

    @Override
    protected int getGroupTitleHeight(int groupIndex) {
        int extraPadding = SubstanceSizeUtils.getExtraPadding((int)SubstanceSizeUtils.getComponentFontSize((Component)this.buttonPanel));
        return this.groupLabels[groupIndex].getPreferredSize().height + 2 * extraPadding;
    }

    @Override
    protected void paintGroupBackground(Graphics g, int groupIndex, int x, int y, int width, int height) {
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.buttonPanel, (ComponentState)ComponentState.ENABLED);
        Color background = scheme.getBackgroundFillColor();
        if (groupIndex % 2 == 1) {
            background = SubstanceColorUtilities.getDarkerColor((Color)background, (double)0.06);
        }
        BackgroundPaintingUtils.fillAndWatermark((Graphics)g, (JComponent)this.buttonPanel, (Color)background, (Rectangle)new Rectangle(x, y, width, height));
    }

    @Override
    protected void paintGroupTitleBackground(Graphics g, int groupIndex, int x, int y, int width, int height) {
        EnumSet<SubstanceSlices.Side> openSides = EnumSet.of(SubstanceSlices.Side.LEFT, SubstanceSlices.Side.RIGHT);
        if (groupIndex == 0) {
            openSides.add(SubstanceSlices.Side.TOP);
        }
        SubstanceColorScheme bgFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.buttonPanel, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)ComponentState.ENABLED);
        SubstanceColorScheme bgBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.buttonPanel, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)ComponentState.ENABLED);
        HighlightPainterUtils.paintHighlight((Graphics)g, null, (Component)this.buttonPanel, (Rectangle)new Rectangle(x, y, width, height), (float)1.0f, openSides, (SubstanceColorScheme)bgFillScheme, (SubstanceColorScheme)bgBorderScheme);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque((Graphics)g, (JComponent)c);
        this.paint(g, c);
    }
}

