/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.common.ui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicColorSelectorComponentUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceColorSelectorComponentUI
extends BasicColorSelectorComponentUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceColorSelectorComponentUI();
    }

    private SubstanceColorSelectorComponentUI() {
    }

    @Override
    protected void paintRolloverIndication(Graphics g) {
        int w = this.colorSelectorComponent.getWidth();
        int h = this.colorSelectorComponent.getHeight();
        Graphics2D g2d = (Graphics2D)g.create();
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        g2d.setComposite(AlphaComposite.SrcOver.derive(this.rollover));
        SubstanceColorScheme highlightBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.colorSelectorComponent, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)ComponentState.ROLLOVER_UNSELECTED);
        g2d.setColor(highlightBorderScheme.getMidColor());
        g2d.draw(new Rectangle2D.Double(0.0, 0.0, (float)w - borderThickness, (float)h - borderThickness));
        g2d.setColor(highlightBorderScheme.getUltraDarkColor());
        g2d.draw(new Rectangle2D.Double(borderThickness, borderThickness, (float)w - 3.0f * borderThickness, (float)h - 3.0f * borderThickness));
        g2d.dispose();
    }
}

