/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon.synapse.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.ribbon.synapse.model.RibbonComboBoxContentModel;
import org.pushingpixels.neon.icon.ResizableIcon;

public class RibbonDefaultComboBoxContentModel<E>
extends DefaultComboBoxModel<E>
implements RibbonComboBoxContentModel<E> {
    private boolean isEnabled;
    private ResizableIcon.Factory iconFactory;
    private String caption;
    private RichTooltip richTooltip;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    private RibbonDefaultComboBoxContentModel(E[] items) {
        super(items);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            this.pcs.firePropertyChange("enabled", !this.isEnabled, this.isEnabled);
        }
    }

    @Override
    public ResizableIcon.Factory getIconFactory() {
        return this.iconFactory;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public RichTooltip getRichTooltip() {
        return this.richTooltip;
    }

    public static class Builder<E> {
        private boolean isEnabled = true;
        private E[] items;
        private ResizableIcon.Factory iconFactory;
        private String caption;
        private RichTooltip richTooltip;

        public Builder<E> setItems(E[] items) {
            this.items = items;
            return this;
        }

        public Builder<E> setEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder<E> setIconFactory(ResizableIcon.Factory iconFactory) {
            this.iconFactory = iconFactory;
            return this;
        }

        public Builder<E> setCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder<E> setRichTooltip(RichTooltip richTooltip) {
            this.richTooltip = richTooltip;
            return this;
        }

        public RibbonDefaultComboBoxContentModel<E> build() {
            RibbonDefaultComboBoxContentModel model = new RibbonDefaultComboBoxContentModel(this.items);
            model.isEnabled = this.isEnabled;
            model.iconFactory = this.iconFactory;
            model.caption = this.caption;
            model.richTooltip = this.richTooltip;
            return model;
        }
    }
}

