/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.RichTooltipManager;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.CommandPopupMenuProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.projection.RibbonGalleryProjection;
import org.pushingpixels.flamingo.api.ribbon.synapse.projection.ComponentProjection;
import org.pushingpixels.flamingo.internal.substance.ribbon.ui.SubstanceRibbonFrameTitlePane;
import org.pushingpixels.flamingo.internal.ui.common.FlamingoInternalButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.flamingo.internal.utils.KeyTipRenderingUtilities;
import org.pushingpixels.neon.AsynchronousLoadListener;
import org.pushingpixels.neon.AsynchronousLoading;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.neon.icon.ResizableIcon;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class JRibbonFrame
extends JFrame {
    private JRibbon ribbon;
    private boolean wasSetIconImagesCalled;

    public JRibbonFrame() throws HeadlessException {
        this.initRibbon();
    }

    public JRibbonFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initRibbon();
    }

    public JRibbonFrame(String title) throws HeadlessException {
        super(title);
        this.initRibbon();
    }

    public JRibbonFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initRibbon();
    }

    @Override
    public void setLayout(LayoutManager manager) {
        LayoutManager currManager;
        if (manager.getClass() != RibbonFrameLayout.class && (currManager = this.getLayout()) != null) {
            throw new IllegalArgumentException("Can't set a custom layout manager on JRibbonFrame");
        }
        super.setLayout(manager);
    }

    @Override
    public void setJMenuBar(JMenuBar menubar) {
        throw new IllegalArgumentException("Can't set a menu bar on JRibbonFrame");
    }

    @Override
    public void setContentPane(Container contentPane) {
        throw new IllegalArgumentException("Can't set the content pane on JRibbonFrame");
    }

    private void initRibbon() {
        this.setLayout(new RibbonFrameLayout());
        this.ribbon = new JRibbon(this);
        this.add((Component)this.ribbon, "North");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            private boolean prevAltModif = false;

            @Override
            public void eventDispatched(AWTEvent event) {
                Component c;
                Object src = event.getSource();
                if (src instanceof Component && ((c = (Component)src) == JRibbonFrame.this || SwingUtilities.getWindowAncestor(c) == JRibbonFrame.this)) {
                    if (event instanceof KeyEvent) {
                        KeyEvent keyEvent = (KeyEvent)event;
                        switch (keyEvent.getID()) {
                            case 402: {
                                boolean wasAltModif = this.prevAltModif;
                                boolean bl = this.prevAltModif = keyEvent.getModifiersEx() == 512;
                                if (wasAltModif && keyEvent.getKeyCode() == 18) break;
                                char keyChar = keyEvent.getKeyChar();
                                if (Character.isLetter(keyChar) || Character.isDigit(keyChar)) {
                                    KeyTipManager.defaultManager().handleKeyPress(keyChar);
                                }
                                if (keyEvent.getKeyCode() == 18 || keyEvent.getKeyCode() == 121) {
                                    if (keyEvent.getModifiersEx() != 0) break;
                                    boolean hadPopups = !PopupPanelManager.defaultManager().getShownPath().isEmpty();
                                    PopupPanelManager.defaultManager().hidePopups(null);
                                    if (hadPopups || KeyTipManager.defaultManager().isShowingKeyTips()) {
                                        KeyTipManager.defaultManager().hideAllKeyTips();
                                    } else {
                                        KeyTipManager.defaultManager().showRootKeyTipChain(JRibbonFrame.this);
                                    }
                                }
                                if (keyEvent.getKeyCode() != 27) break;
                                KeyTipManager.defaultManager().showPreviousChain();
                            }
                        }
                    }
                    if (event instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)event;
                        switch (mouseEvent.getID()) {
                            case 500: 
                            case 506: {
                                KeyTipManager.defaultManager().hideAllKeyTips();
                                break;
                            }
                            case 501: 
                            case 502: {
                                KeyTipManager.defaultManager().hideAllKeyTips();
                                if (!mouseEvent.isPopupTrigger()) break;
                                JRibbonFrame.this.handlePopupTrigger(mouseEvent, SwingUtilities.getDeepestComponentAt(c, mouseEvent.getX(), mouseEvent.getY()));
                            }
                        }
                    }
                }
            }
        }, 24L);
        final KeyTipLayer keyTipLayer = new KeyTipLayer();
        JRootPane rootPane = this.getRootPane();
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        final LayoutManager currLM = rootPane.getLayout();
        rootPane.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
                currLM.addLayoutComponent(name, comp);
            }

            @Override
            public void layoutContainer(Container parent) {
                currLM.layoutContainer(parent);
                JRibbonFrame ribbonFrame = JRibbonFrame.this;
                if (ribbonFrame.getRootPane().getWindowDecorationStyle() != 0) {
                    keyTipLayer.setBounds(ribbonFrame.getRootPane().getBounds());
                } else {
                    keyTipLayer.setBounds(ribbonFrame.getRootPane().getContentPane().getBounds());
                }
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return currLM.minimumLayoutSize(parent);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return currLM.preferredLayoutSize(parent);
            }

            @Override
            public void removeLayoutComponent(Component comp) {
                currLM.removeLayoutComponent(comp);
            }
        });
        layeredPane.add((Component)keyTipLayer, (Object)(JLayeredPane.DEFAULT_LAYER + 60));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                KeyTipManager keyTipManager = KeyTipManager.defaultManager();
                if (keyTipManager.isShowingKeyTips()) {
                    keyTipManager.hideAllKeyTips();
                }
            }
        });
        KeyTipManager.defaultManager().addKeyTipListener(new KeyTipManager.KeyTipListener(){

            @Override
            public void keyTipsHidden(KeyTipManager.KeyTipEvent event) {
                if (event.getSource() == JRibbonFrame.this) {
                    keyTipLayer.setVisible(false);
                }
            }

            @Override
            public void keyTipsShown(KeyTipManager.KeyTipEvent event) {
                if (event.getSource() == JRibbonFrame.this) {
                    keyTipLayer.setVisible(true);
                }
            }
        });
        RichTooltipManager.sharedInstance();
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        super.setIconImages(Collections.singletonList(SubstanceCoreUtilities.getBlankImage((int)16, (int)16)));
    }

    private boolean isValidPopupTriggerSource(Component c) {
        JComponent popupInvoker;
        if (SwingUtilities.getAncestorOfClass(GlobalPopupMenu.class, c) != null) {
            return false;
        }
        if (SwingUtilities.getAncestorOfClass(JRibbon.class, c) != null || SwingUtilities.getAncestorOfClass(SubstanceRibbonFrameTitlePane.class, c) != null) {
            return true;
        }
        JPopupPanel popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, c);
        if (popupPanel == null) {
            return false;
        }
        do {
            if ((popupInvoker = popupPanel.getInvoker()) != null) continue;
            return false;
        } while ((popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, popupInvoker)) != null);
        boolean isValidChainRoot = SwingUtilities.getAncestorOfClass(JRibbon.class, popupInvoker) != null || SwingUtilities.getAncestorOfClass(SubstanceRibbonFrameTitlePane.class, popupInvoker) != null;
        return isValidChainRoot;
    }

    private boolean isInTaskbar(Component c) {
        JComponent popupInvoker;
        if (SwingUtilities.getAncestorOfClass(SubstanceRibbonFrameTitlePane.class, c) != null) {
            return true;
        }
        JPopupPanel popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, c);
        if (popupPanel == null) {
            return false;
        }
        do {
            if ((popupInvoker = popupPanel.getInvoker()) != null) continue;
            return false;
        } while ((popupPanel = (JPopupPanel)SwingUtilities.getAncestorOfClass(JPopupPanel.class, popupInvoker)) != null);
        return SwingUtilities.getAncestorOfClass(SubstanceRibbonFrameTitlePane.class, popupInvoker) != null;
    }

    private void handlePopupTrigger(MouseEvent event, Component c) {
        int ph;
        if (!this.isValidPopupTriggerSource(c)) {
            return;
        }
        JRibbon.OnShowContextualMenuListener onShowContextualMenuListener = this.ribbon.getOnShowContextualMenuListener();
        if (onShowContextualMenuListener == null) {
            return;
        }
        CommandMenuContentModel menuContentModel = null;
        if (this.isInTaskbar(c)) {
            Object projection2 = null;
            JRibbonComponent taskbarWrapped = (JRibbonComponent)SwingUtilities.getAncestorOfClass(JRibbonComponent.class, c);
            projection2 = taskbarWrapped != null ? taskbarWrapped.getClientProperty("radiance.flamingo.internal.ribbon.taskbarProjection") : ((JComponent)c).getClientProperty("radiance.flamingo.internal.ribbon.taskbarProjection");
            if (projection2 instanceof RibbonGalleryProjection) {
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel((RibbonGalleryProjection)projection2);
            } else if (projection2 instanceof ComponentProjection) {
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel((ComponentProjection)projection2);
            } else if (projection2 instanceof CommandButtonProjection) {
                CommandButtonProjection commandButtonProjection = (CommandButtonProjection)projection2;
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel((Command)commandButtonProjection.getContentModel());
            } else {
                Command command = (Command)((JComponent)c).getClientProperty("radiance.flamingo.internal.ribbon.taskbarCommand");
                menuContentModel = command != null ? onShowContextualMenuListener.getContextualMenuContentModel(command) : onShowContextualMenuListener.getContextualMenuContentModel();
            }
        } else {
            JRibbonGallery gallery = (JRibbonGallery)SwingUtilities.getAncestorOfClass(JRibbonGallery.class, c);
            if (gallery != null) {
                menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(gallery.getProjection());
            } else {
                JRibbonComponent component = (JRibbonComponent)SwingUtilities.getAncestorOfClass(JRibbonComponent.class, c);
                if (component != null) {
                    menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel(component.getProjection());
                } else if (c instanceof AbstractCommandButton && !(c instanceof FlamingoInternalButton)) {
                    menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel((Command)((AbstractCommandButton)c).getProjection().getContentModel());
                }
            }
        }
        if (menuContentModel == null) {
            menuContentModel = onShowContextualMenuListener.getContextualMenuContentModel();
        }
        CommandPopupMenuProjection globalContextMenuProjection = new CommandPopupMenuProjection(menuContentModel, CommandPopupMenuPresentationModel.builder().setMenuPresentationState(CommandButtonPresentationState.MEDIUM).build());
        globalContextMenuProjection.setComponentSupplier(projection -> GlobalPopupMenu::new);
        JCommandPopupMenu menu = (JCommandPopupMenu)globalContextMenuProjection.buildComponent();
        int x = event.getXOnScreen();
        int y = event.getYOnScreen();
        Rectangle scrBounds = this.ribbon.getGraphicsConfiguration().getBounds();
        int pw = menu.getPreferredSize().width;
        if (x + pw > scrBounds.x + scrBounds.width) {
            x = scrBounds.x + scrBounds.width - pw;
        }
        if (y + (ph = menu.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
            y = scrBounds.y + scrBounds.height - ph;
        }
        PopupPanelManager.defaultManager().hidePopups(c);
        Popup popup = PopupFactory.getSharedInstance().getPopup(this.ribbon, menu, x, y);
        PopupPanelManager.defaultManager().addPopup((JComponent)c, popup, menu);
    }

    public JRibbon getRibbon() {
        return this.ribbon;
    }

    @Override
    protected JRootPane createRootPane() {
        JRibbonRootPane rp = new JRibbonRootPane();
        rp.setOpaque(true);
        return rp;
    }

    @Override
    public synchronized void setIconImages(List<? extends Image> icons) {
        super.setIconImages(icons);
        this.wasSetIconImagesCalled = true;
    }

    public synchronized void setApplicationIcon(ResizableIcon.Factory iconFactory) {
        if (iconFactory == null) {
            return;
        }
        new Thread(() -> this.setApplicationAndMenuButtonIcon(iconFactory)).start();
    }

    private void setApplicationAndMenuButtonIcon(ResizableIcon.Factory iconFactory) {
        Image icon16 = JRibbonFrame.getImage(iconFactory, 16);
        if (NeonCortex.getPlatform() == NeonCortex.Platform.MACOS) {
            SwingUtilities.invokeLater(() -> this.setLegacyIconImages(Collections.singletonList(icon16)));
        } else {
            SwingUtilities.invokeLater(() -> this.setLegacyIconImages(Arrays.asList(icon16, JRibbonFrame.getImage(iconFactory, 32), JRibbonFrame.getImage(iconFactory, 64))));
        }
    }

    private void setLegacyIconImages(List<Image> images) {
        if (this.wasSetIconImagesCalled) {
            return;
        }
        super.setIconImages(images);
    }

    private static Image getImage(ResizableIcon.Factory iconFactory, int size) {
        AsynchronousLoading async;
        ResizableIcon icon = iconFactory.createNewIcon();
        icon.setDimension(new Dimension(size, size));
        if (icon instanceof AsynchronousLoading && (async = (AsynchronousLoading)icon).isLoading()) {
            CountDownLatch latch = new CountDownLatch(1);
            boolean[] status = new boolean[1];
            AsynchronousLoadListener all = success -> {
                status[0] = success;
                latch.countDown();
            };
            async.addAsynchronousLoadListener(all);
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            async.removeAsynchronousLoadListener(all);
            if (!status[0]) {
                return null;
            }
            if (async.isLoading()) {
                return null;
            }
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)size, (int)size);
        Graphics2D g2d = (Graphics2D)((Image)result).getGraphics().create();
        icon.paintIcon(null, (Graphics)g2d, 0, 0);
        g2d.dispose();
        return result;
    }

    public boolean isShowingKeyTips() {
        return KeyTipManager.defaultManager().isShowingKeyTips();
    }

    public static class GlobalPopupMenu
    extends JCommandPopupMenu {
        public GlobalPopupMenu(Projection<JCommandPopupMenu, CommandMenuContentModel, CommandPopupMenuPresentationModel> projection) {
            super(projection);
        }
    }

    private class KeyTipLayer
    extends JComponent {
        public KeyTipLayer() {
            this.setOpaque(false);
            try {
                Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
                Method mSetComponentMixing = awtUtilitiesClass.getMethod("setComponentMixingCutoutShape", Component.class, Shape.class);
                mSetComponentMixing.invoke(null, this, new Rectangle());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
        }

        @Override
        public synchronized void addMouseMotionListener(MouseMotionListener l) {
        }

        @Override
        public synchronized void addMouseWheelListener(MouseWheelListener l) {
        }

        @Override
        public synchronized void addKeyListener(KeyListener l) {
        }

        @Override
        protected void paintComponent(Graphics g) {
            JRibbonFrame ribbonFrame = (JRibbonFrame)SwingUtilities.getWindowAncestor(this);
            if (!ribbonFrame.isShowingKeyTips()) {
                return;
            }
            if (!ribbonFrame.isActive()) {
                return;
            }
            Collection<KeyTipManager.KeyTipLink> keyTips = KeyTipManager.defaultManager().getCurrentlyShownKeyTips();
            if (keyTips != null) {
                Graphics2D g2d = (Graphics2D)g.create();
                NeonCortex.installDesktopHints((Graphics2D)g2d, (Font)this.getFont());
                for (KeyTipManager.KeyTipLink keyTip : keyTips) {
                    Container titlePane;
                    Container taskbarOverflowPanel;
                    boolean isInPopup;
                    boolean bl = isInPopup = SwingUtilities.getAncestorOfClass(JPopupPanel.class, keyTip.comp) != null;
                    if (isInPopup && SwingUtilities.getAncestorOfClass(SubstanceRibbonFrameTitlePane.TaskbarOverflowPopupPanel.class, keyTip.comp) == null) continue;
                    Rectangle compBounds = keyTip.comp.getBounds();
                    if (!keyTip.comp.isShowing() || compBounds.getWidth() == 0.0 || compBounds.getHeight() == 0.0) continue;
                    Dimension pref = KeyTipRenderingUtilities.getPrefSize(g2d.getFontMetrics(), keyTip.keyTipString);
                    Point prefCenter = keyTip.prefAnchorPoint;
                    Point loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, this);
                    Container bandControlPanel = SwingUtilities.getAncestorOfClass(AbstractBandControlPanel.class, keyTip.comp);
                    if (bandControlPanel != null) {
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.topRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = 0;
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.midRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = bandControlPanel.getHeight() / 2;
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                        if (this.hasClientPropertySetToTrue(keyTip.comp, "flamingo.internal.ribbonBandControlPanel.bottomRow")) {
                            loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, bandControlPanel);
                            loc.y = bandControlPanel.getHeight();
                            loc = SwingUtilities.convertPoint(bandControlPanel, loc, this);
                        }
                    }
                    if ((taskbarOverflowPanel = SwingUtilities.getAncestorOfClass(SubstanceRibbonFrameTitlePane.TaskbarOverflowPopupPanel.class, keyTip.comp)) != null) {
                        loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, taskbarOverflowPanel);
                        loc.y = pref.height / 2 + taskbarOverflowPanel.getHeight();
                        loc = SwingUtilities.convertPoint(taskbarOverflowPanel, loc, this);
                    }
                    if ((titlePane = SwingUtilities.getAncestorOfClass(SubstanceRibbonFrameTitlePane.class, keyTip.comp)) != null) {
                        loc = SwingUtilities.convertPoint(keyTip.comp, prefCenter, titlePane);
                        loc.y = pref.height / 2 + titlePane.getHeight() / 2;
                        loc = SwingUtilities.convertPoint(titlePane, loc, this);
                    }
                    KeyTipRenderingUtilities.renderKeyTip(g2d, this, new Rectangle(loc.x - pref.width / 2, loc.y - pref.height / 2, pref.width, pref.height), keyTip.keyTipString, keyTip.enabled);
                }
                g2d.dispose();
            }
        }

        private boolean hasClientPropertySetToTrue(Component c, String clientPropName) {
            while (c != null) {
                JComponent jc;
                if (c instanceof JComponent && Boolean.TRUE.equals((jc = (JComponent)c).getClientProperty(clientPropName))) {
                    return true;
                }
                c = c.getParent();
            }
            return false;
        }

        @Override
        public boolean contains(int x, int y) {
            return false;
        }
    }

    private class RibbonFrameLayout
    extends BorderLayout {
        private RibbonFrameLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints != null && constraints.equals("North")) {
                if (this.getLayoutComponent("North") != null) {
                    throw new IllegalArgumentException("Already has a NORTH JRibbon component");
                }
                if (!(comp instanceof JRibbon)) {
                    throw new IllegalArgumentException("Can't add non-JRibbon component to NORTH location");
                }
            }
            super.addLayoutComponent(comp, constraints);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp instanceof JRibbon) {
                throw new IllegalArgumentException("Can't remove JRibbon component");
            }
            super.removeLayoutComponent(comp);
        }
    }
}

