/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.util.Collections;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandAction;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.projection.RibbonGalleryProjection;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.synapse.model.ComponentContentModel;
import org.pushingpixels.flamingo.api.ribbon.synapse.projection.ComponentProjection;
import org.pushingpixels.flamingo.internal.ui.ribbon.CommandButtonLayoutManagerBigFixed;
import org.pushingpixels.flamingo.internal.ui.ribbon.CommandButtonLayoutManagerBigFixedLandscape;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;
import org.pushingpixels.neon.icon.ResizableIcon;

public class JRibbonBand
extends AbstractRibbonBand {
    public static final CommandButtonPresentationState BIG_FIXED_LANDSCAPE = new CommandButtonPresentationState("Big Fixed Landscape", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton button) {
            return new CommandButtonLayoutManagerBigFixedLandscape();
        }
    };
    public static final CommandButtonPresentationState BIG_FIXED = new CommandButtonPresentationState("Big Fixed", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton button) {
            return new CommandButtonLayoutManagerBigFixed();
        }
    };

    public JRibbonBand(String title, ResizableIcon.Factory iconFactory) {
        this(title, iconFactory, null);
    }

    public JRibbonBand(String title, ResizableIcon.Factory iconFactory, CommandAction expandCommandListener) {
        super(title, iconFactory, expandCommandListener, new JBandControlPanel());
        this.resizePolicies = Collections.unmodifiableList(CoreRibbonResizePolicies.getCorePoliciesPermissive(this));
        this.updateUI();
    }

    public AbstractCommandButton addRibbonCommand(CommandButtonProjection<? extends Command> projection, PresentationPriority priority) {
        AbstractCommandButton commandButton = (AbstractCommandButton)projection.buildComponent();
        ((JBandControlPanel)this.getControlPanel()).addCommandButton(commandButton, priority);
        return commandButton;
    }

    public void addRibbonGallery(RibbonGalleryProjection galleryProjection, PresentationPriority priority) {
        JRibbonGallery gallery = new JRibbonGallery(galleryProjection);
        ((JBandControlPanel)this.getControlPanel()).addRibbonGallery(gallery, priority);
    }

    public void addRibbonComponent(ComponentProjection<? extends JComponent, ? extends ComponentContentModel> projection) {
        JRibbonComponent ribbonComponent = new JRibbonComponent(projection);
        ((JBandControlPanel)this.getControlPanel()).addRibbonComponent(ribbonComponent);
    }

    public int startGroup() {
        return ((JBandControlPanel)this.getControlPanel()).startGroup();
    }

    public int startGroup(String groupTitle) {
        return ((JBandControlPanel)this.getControlPanel()).startGroup(groupTitle);
    }

    public void setGroupTitle(int groupIndex, String groupTitle) {
        ((JBandControlPanel)this.getControlPanel()).setGroupTitle(groupIndex, groupTitle);
    }

    @Override
    public AbstractRibbonBand cloneBand() {
        JRibbonBand result = new JRibbonBand(this.getTitle(), this.getIconFactory(), this.getExpandCommandListener());
        result.applyComponentOrientation(this.getComponentOrientation());
        return result;
    }

    public static enum PresentationPriority {
        TOP,
        MEDIUM,
        LOW;

    }
}

