/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.KeyValuePair;
import org.pushingpixels.flamingo.api.common.model.Command;

public class ColorSelectorPopupMenuGroupModel {
    private List<KeyValuePair<GroupEntryKind, Object>> groupContent;
    private EventListenerList listenerList = new EventListenerList();

    public static Builder builder() {
        return new Builder();
    }

    public List<KeyValuePair<GroupEntryKind, Object>> getGroupContent() {
        return Collections.unmodifiableList(this.groupContent);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static class Builder {
        private List<KeyValuePair<GroupEntryKind, Object>> groupContent = new ArrayList<KeyValuePair<GroupEntryKind, Object>>();

        public Builder addCommand(Command command) {
            this.groupContent.add(new KeyValuePair<GroupEntryKind, Command>(GroupEntryKind.COMMAND, command));
            return this;
        }

        public Builder addColorSection(ColorSectionModel colorSectionModel) {
            this.groupContent.add(new KeyValuePair<GroupEntryKind, ColorSectionModel>(GroupEntryKind.COLOR_SECTION, colorSectionModel));
            return this;
        }

        public Builder addColorSectionWithDerived(ColorSectionModel colorSectionModel) {
            this.groupContent.add(new KeyValuePair<GroupEntryKind, ColorSectionModel>(GroupEntryKind.COLOR_SECTION_WITH_DERIVED, colorSectionModel));
            return this;
        }

        public Builder addRecentsSection(ColorSectionModel colorSectionModel) {
            this.groupContent.add(new KeyValuePair<GroupEntryKind, ColorSectionModel>(GroupEntryKind.RECENTS_SECTION, colorSectionModel));
            return this;
        }

        public ColorSelectorPopupMenuGroupModel build() {
            ColorSelectorPopupMenuGroupModel menuGroupModel = new ColorSelectorPopupMenuGroupModel();
            menuGroupModel.groupContent = Collections.unmodifiableList(this.groupContent);
            return menuGroupModel;
        }
    }

    public static class ColorSectionModel {
        private String title;
        private Color[] colors;

        public ColorSectionModel(String title) {
            this.title = title;
        }

        public ColorSectionModel(String title, Color[] colors) {
            this.title = title;
            this.colors = colors;
        }

        public final String getTitle() {
            return this.title;
        }

        public final Color[] getColors() {
            return Arrays.copyOf(this.colors, this.colors.length);
        }
    }

    public static enum GroupEntryKind {
        COMMAND,
        COLOR_SECTION,
        COLOR_SECTION_WITH_DERIVED,
        RECENTS_SECTION;

    }
}

