/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.KeyValuePair;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.AbstractPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuGroupModel;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceColorSelectorPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicColorSelectorPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorComponent;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorPanel;

public class JColorSelectorPopupMenu
extends AbstractPopupMenu {
    public static final String uiClassID = "ColorSelectorPopupMenuUI";
    private Projection<JColorSelectorPopupMenu, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> projection;
    private ColorSelectorPopupMenuContentModel contentModel;
    private ColorSelectorPopupMenuPresentationModel presentationModel;
    private ColorSelectorPopupMenuContentModel.ColorPreviewListener colorPreviewListener;
    private ColorSelectorPopupMenuContentModel.ColorActivationListener colorActivationListener;
    private int colorColumns;
    private JColorSelectorPanel lastColorSelectorPanel;
    private static LinkedList<Color> recentlySelected = new LinkedList();

    public JColorSelectorPopupMenu(Projection<JColorSelectorPopupMenu, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> projection) {
        this.projection = projection;
        this.contentModel = (ColorSelectorPopupMenuContentModel)projection.getContentModel();
        this.presentationModel = (ColorSelectorPopupMenuPresentationModel)projection.getPresentationModel();
        this.colorPreviewListener = this.contentModel.getColorPreviewListener();
        this.colorActivationListener = this.contentModel.getColorActivationListener();
        this.colorColumns = this.presentationModel.getColorColumns();
        this.populateContent();
        this.contentModel.addChangeListener(event -> this.populateContent());
        this.updateUI();
    }

    public Projection<JColorSelectorPopupMenu, ColorSelectorPopupMenuContentModel, ColorSelectorPopupMenuPresentationModel> getProjection() {
        return this.projection;
    }

    private void populateContent() {
        CommandButtonPresentationModel presentation = CommandButtonPresentationModel.builder().setPresentationState(this.presentationModel.getMenuPresentationState()).setMenu(true).build();
        List<ColorSelectorPopupMenuGroupModel> menuGroups = this.contentModel.getMenuGroups();
        for (int i = 0; i < menuGroups.size(); ++i) {
            ColorSelectorPopupMenuGroupModel menuGroup = menuGroups.get(i);
            for (KeyValuePair<ColorSelectorPopupMenuGroupModel.GroupEntryKind, Object> groupEntry : menuGroup.getGroupContent()) {
                switch (groupEntry.getKey()) {
                    case COMMAND: {
                        Command command = (Command)groupEntry.getValue();
                        AbstractCommandButton commandButton = (AbstractCommandButton)command.project(presentation).buildComponent();
                        if (commandButton instanceof JCommandMenuButton) {
                            this.addMenuButton((JCommandMenuButton)commandButton);
                        }
                        if (!(commandButton instanceof JCommandToggleMenuButton)) break;
                        this.addMenuButton((JCommandToggleMenuButton)commandButton);
                        break;
                    }
                    case COLOR_SECTION: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModel colorSectionModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModel)groupEntry.getValue();
                        this.addColorSection(colorSectionModel.getTitle(), colorSectionModel.getColors());
                        break;
                    }
                    case COLOR_SECTION_WITH_DERIVED: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModel colorSectionWithDerivedModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModel)groupEntry.getValue();
                        this.addColorSectionWithDerived(colorSectionWithDerivedModel.getTitle(), colorSectionWithDerivedModel.getColors());
                        break;
                    }
                    case RECENTS_SECTION: {
                        ColorSelectorPopupMenuGroupModel.ColorSectionModel recentsSectionModel = (ColorSelectorPopupMenuGroupModel.ColorSectionModel)groupEntry.getValue();
                        this.addRecentSection(recentsSectionModel.getTitle());
                    }
                }
            }
            if (i >= menuGroups.size() - 1) continue;
            this.addMenuSeparator();
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceColorSelectorPopupMenuUI.createUI(this));
    }

    private void addColorSectionWithDerived(String label, Color[] primaryColors) {
        if (primaryColors == null || primaryColors.length != this.colorColumns) {
            throw new IllegalArgumentException("Must pass exactly " + this.colorColumns + " colors");
        }
        MultiRowSelector selectorContainer = new MultiRowSelector(this, primaryColors);
        JColorSelectorPanel selector = new JColorSelectorPanel(label, selectorContainer);
        this.addMenuPanel(selector);
        this.lastColorSelectorPanel = selector;
    }

    private void addColorSection(String label, Color[] primaryColors) {
        if (primaryColors == null || primaryColors.length != this.colorColumns) {
            throw new IllegalArgumentException("Must pass exactly " + this.colorColumns + " colors");
        }
        SingleRowSelector selectorContainer = new SingleRowSelector(this, primaryColors);
        JColorSelectorPanel selector = new JColorSelectorPanel(label, selectorContainer);
        this.addMenuPanel(selector);
        this.lastColorSelectorPanel = selector;
    }

    private void addRecentSection(String label) {
        SingleRowSelector recent = new SingleRowSelector(this, recentlySelected.toArray(new Color[0]));
        JColorSelectorPanel recentPanel = new JColorSelectorPanel(label, recent);
        recentPanel.setLastPanel(true);
        this.addMenuPanel(recentPanel);
        this.lastColorSelectorPanel = recentPanel;
    }

    @Override
    void addMenuButton(JCommandMenuButton menuButton) {
        super.addMenuButton(menuButton);
        this.updateLastColorSelectorPanel();
    }

    @Override
    void addMenuButton(JCommandToggleMenuButton menuButton) {
        super.addMenuButton(menuButton);
        this.updateLastColorSelectorPanel();
    }

    @Override
    void addMenuSeparator() {
        super.addMenuSeparator();
        this.updateLastColorSelectorPanel();
    }

    private void updateLastColorSelectorPanel() {
        if (this.lastColorSelectorPanel != null) {
            this.lastColorSelectorPanel.setLastPanel(true);
            this.lastColorSelectorPanel = null;
        }
    }

    private static void wireToLRU(JColorSelectorComponent colorSelector) {
        colorSelector.addColorActivationListener(color -> JColorSelectorPopupMenu.addColorToRecentlyUsed(color));
    }

    public static synchronized List<Color> getRecentlyUsedColors() {
        return Collections.unmodifiableList(recentlySelected);
    }

    public static synchronized void addColorToRecentlyUsed(Color color) {
        if (recentlySelected.contains(color)) {
            recentlySelected.remove(color);
            recentlySelected.addLast(color);
            return;
        }
        if (recentlySelected.size() == 100) {
            recentlySelected.removeFirst();
        }
        recentlySelected.addLast(color);
    }

    private class MultiRowSelector
    extends JPanel {
        private static final int SECONDARY_ROWS = 5;

        private MultiRowSelector(final JColorSelectorPopupMenu colorSelectorPopupMenu, final Color ... colors) {
            final JColorSelectorComponent[][] comps = new JColorSelectorComponent[colors.length][6];
            for (int i = 0; i < colors.length; ++i) {
                Color primary = colors[i];
                comps[i][0] = new JColorSelectorComponent(primary, JColorSelectorPopupMenu.this.colorPreviewListener, JColorSelectorPopupMenu.this.colorActivationListener);
                JColorSelectorPopupMenu.wireToLRU(comps[i][0]);
                this.add(comps[i][0]);
                float[] primaryHsb = new float[3];
                Color.RGBtoHSB(primary.getRed(), primary.getGreen(), primary.getBlue(), primaryHsb);
                for (int row = 1; row <= 5; ++row) {
                    float bFactor = (float)(row - 1) / 5.0f;
                    bFactor = (float)Math.pow(bFactor, 1.4f);
                    float brightness = 1.0f - bFactor;
                    if (primaryHsb[1] == 0.0f) {
                        float max = 0.5f + 0.5f * primaryHsb[2];
                        brightness = max * (float)(5 - row + 1) / 5.0f;
                    }
                    Color secondary = new Color(Color.HSBtoRGB(primaryHsb[0], primaryHsb[1] * (float)(row + 1) / 6.0f, brightness));
                    comps[i][row] = new JColorSelectorComponent(secondary, JColorSelectorPopupMenu.this.colorPreviewListener, JColorSelectorPopupMenu.this.colorActivationListener);
                    comps[i][row].setTopOpen(row > 1);
                    comps[i][row].setBottomOpen(row < 5);
                    JColorSelectorPopupMenu.wireToLRU(comps[i][row]);
                    this.add(comps[i][row]);
                }
            }
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return new Dimension(10, 10);
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    BasicColorSelectorPopupMenuUI ui = (BasicColorSelectorPopupMenuUI)colorSelectorPopupMenu.getUI();
                    int gap = ui.getColorSelectorCellGap();
                    int size = ui.getColorSelectorCellSize();
                    return new Dimension(colors.length * size + (colors.length + 1) * gap, gap + size + gap + 5 * size + gap);
                }

                @Override
                public void layoutContainer(Container parent) {
                    BasicColorSelectorPopupMenuUI ui = (BasicColorSelectorPopupMenuUI)colorSelectorPopupMenu.getUI();
                    int gap = ui.getColorSelectorCellGap();
                    int size = ui.getColorSelectorCellSize();
                    if (parent.getComponentOrientation().isLeftToRight()) {
                        int y = gap;
                        for (int row = 0; row <= 5; ++row) {
                            int x = gap;
                            for (int i = 0; i < colors.length; ++i) {
                                comps[i][row].setBounds(x, y, size, size);
                                x += size + gap;
                            }
                            y += size;
                            if (row != 0) continue;
                            y += gap;
                        }
                    } else {
                        int y = gap;
                        for (int row = 0; row <= 5; ++row) {
                            int x = MultiRowSelector.this.getWidth() - gap;
                            for (int i = 0; i < colors.length; ++i) {
                                comps[i][row].setBounds(x - size, y, size, size);
                                x -= size + gap;
                            }
                            y += size;
                            if (row != 0) continue;
                            y += gap;
                        }
                    }
                }
            });
        }
    }

    private class SingleRowSelector
    extends JPanel {
        private SingleRowSelector(final JColorSelectorPopupMenu colorSelectorPopupMenu, final Color ... colors) {
            final JColorSelectorComponent[] comps = new JColorSelectorComponent[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                comps[i] = new JColorSelectorComponent(colors[i], JColorSelectorPopupMenu.this.colorPreviewListener, JColorSelectorPopupMenu.this.colorActivationListener);
                JColorSelectorPopupMenu.wireToLRU(comps[i]);
                this.add(comps[i]);
            }
            this.setLayout(new LayoutManager(){

                @Override
                public void addLayoutComponent(String name, Component comp) {
                }

                @Override
                public void removeLayoutComponent(Component comp) {
                }

                @Override
                public Dimension minimumLayoutSize(Container parent) {
                    return new Dimension(10, 10);
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    BasicColorSelectorPopupMenuUI ui = (BasicColorSelectorPopupMenuUI)colorSelectorPopupMenu.getUI();
                    int gap = ui.getColorSelectorCellGap();
                    int size = ui.getColorSelectorCellSize();
                    return new Dimension(colors.length * size + (colors.length + 1) * gap, size + 2 * gap);
                }

                @Override
                public void layoutContainer(Container parent) {
                    BasicColorSelectorPopupMenuUI ui = (BasicColorSelectorPopupMenuUI)colorSelectorPopupMenu.getUI();
                    int gap = ui.getColorSelectorCellGap();
                    int size = ui.getColorSelectorCellSize();
                    if (parent.getComponentOrientation().isLeftToRight()) {
                        int x = gap;
                        int y = gap;
                        for (int i = 0; i < colors.length; ++i) {
                            comps[i].setBounds(x, y, size, size);
                            x += size + gap;
                        }
                    } else {
                        int x = SingleRowSelector.this.getWidth() - gap;
                        int y = gap;
                        for (int i = 0; i < colors.length; ++i) {
                            comps[i].setBounds(x - size, y, size, size);
                            x -= size + gap;
                        }
                    }
                }
            });
        }
    }
}

