/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.ContentModel;

public class CommandGroup
implements ContentModel {
    private String title;
    private List<Command> commands;
    private EventListenerList listenerList = new EventListenerList();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CommandGroup(Command ... commands) {
        this((String)null, commands);
    }

    public CommandGroup(List<Command> commands) {
        this(null, commands);
    }

    public CommandGroup(String title, Command ... commands) {
        this(title, Arrays.asList(commands));
    }

    public CommandGroup(String title, List<Command> commands) {
        this.title = title;
        this.commands = new ArrayList<Command>(commands);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (!this.title.equals(title)) {
            String old = this.title;
            this.title = title;
            this.pcs.firePropertyChange("title", old, this.title);
        }
    }

    public List<Command> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public void addCommand(Command command) {
        if (command != null && !this.commands.contains(command)) {
            this.commands.add(command);
            this.fireCommandAdded(command);
        }
    }

    public void removeCommand(Command command) {
        if (this.commands.remove(command)) {
            this.fireCommandRemoved(command);
        }
    }

    public void removeAllCommands() {
        this.commands.clear();
        this.fireAllCommandsRemoved();
    }

    public void addCommandGroupListener(CommandGroupListener l) {
        this.listenerList.add(CommandGroupListener.class, l);
    }

    public void removeCommandGroupListener(CommandGroupListener l) {
        this.listenerList.remove(CommandGroupListener.class, l);
    }

    private void fireCommandAdded(Command command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandGroupListener.class) continue;
            ((CommandGroupListener)listeners[i + 1]).onCommandAdded(command);
        }
    }

    private void fireCommandRemoved(Command command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandGroupListener.class) continue;
            ((CommandGroupListener)listeners[i + 1]).onCommandRemoved(command);
        }
    }

    private void fireAllCommandsRemoved() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandGroupListener.class) continue;
            ((CommandGroupListener)listeners[i + 1]).onAllCommandsRemoved();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public static interface CommandGroupListener
    extends EventListener {
        public void onCommandAdded(Command var1);

        public void onCommandRemoved(Command var1);

        public void onAllCommandsRemoved();
    }
}

