/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.model;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import javax.swing.JToggleButton;
import org.pushingpixels.flamingo.api.common.CommandActionEvent;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.Command;

public class ActionToggleButtonModel
extends JToggleButton.ToggleButtonModel
implements ActionButtonModel {
    private JCommandToggleButton commandButton;
    private boolean toFireActionOnPress;

    public ActionToggleButtonModel(JCommandToggleButton commandButton, boolean toFireActionOnPress) {
        this.commandButton = commandButton;
        this.toFireActionOnPress = toFireActionOnPress;
    }

    @Override
    public boolean isFireActionOnPress() {
        return this.toFireActionOnPress;
    }

    @Override
    public void setFireActionOnPress(boolean toFireActionOnPress) {
        this.toFireActionOnPress = toFireActionOnPress;
    }

    @Override
    public void setPressed(boolean b) {
        if (this.isPressed() == b || !this.isEnabled()) {
            return;
        }
        if (this.isArmed()) {
            if (!this.isFireActionOnPress()) {
                if (!b) {
                    this.setSelected(!this.isSelected());
                }
            } else if (b) {
                this.setSelected(!this.isSelected());
            }
        }
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        this.fireStateChanged();
        boolean toFireAction = false;
        if (this.isFireActionOnPress()) {
            toFireAction = this.isPressed() && this.isArmed();
        } else {
            boolean bl = toFireAction = !this.isPressed() && this.isArmed();
        }
        if (toFireAction) {
            int modifiers = 0;
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof InputEvent) {
                modifiers = ((InputEvent)currentEvent).getModifiersEx();
            } else if (currentEvent instanceof ActionEvent) {
                modifiers = ((ActionEvent)currentEvent).getModifiers();
            }
            Command originalCommand = (Command)this.commandButton.getProjection().getContentModel();
            originalCommand.setToggleSelected(!originalCommand.isToggleSelected());
            this.fireActionPerformed(new CommandActionEvent(this.commandButton, 1001, originalCommand, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
        }
    }
}

