/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import org.pushingpixels.neon.icon.ResizableIcon;

public class ColorResizableIcon
implements ResizableIcon {
    protected int width;
    protected int height;
    private final Color color;

    public ColorResizableIcon(Dimension initialDim, Color color) {
        this.width = initialDim.width;
        this.height = initialDim.height;
        this.color = color;
    }

    public ColorResizableIcon(int initialDim, Color color) {
        this(new Dimension(initialDim, initialDim), color);
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
    }

    public static ResizableIcon.Factory factory(Color color) {
        return () -> new ColorResizableIcon(16, color);
    }
}

