/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.pushingpixels.neon.icon.ResizableIcon;

public class RichTooltip {
    private String title;
    private ResizableIcon mainIcon;
    private List<String> descriptionSections;
    private ResizableIcon footerIcon;
    private List<String> footerSections;

    private RichTooltip() {
    }

    public String getTitle() {
        return this.title;
    }

    public ResizableIcon getMainIcon() {
        return this.mainIcon;
    }

    public List<String> getDescriptionSections() {
        return this.descriptionSections;
    }

    public ResizableIcon getFooterIcon() {
        return this.footerIcon;
    }

    public List<String> getFooterSections() {
        return this.footerSections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private ResizableIcon.Factory mainIconFactory;
        private List<String> descriptionSections;
        private ResizableIcon.Factory footerIconFactory;
        private List<String> footerSections;

        public RichTooltip build() {
            RichTooltip richTooltip = new RichTooltip();
            richTooltip.title = this.title;
            richTooltip.mainIcon = this.mainIconFactory != null ? this.mainIconFactory.createNewIcon() : null;
            richTooltip.descriptionSections = this.descriptionSections != null ? Collections.unmodifiableList(this.descriptionSections) : Collections.EMPTY_LIST;
            richTooltip.footerIcon = this.footerIconFactory != null ? this.footerIconFactory.createNewIcon() : null;
            richTooltip.footerSections = this.footerSections != null ? Collections.unmodifiableList(this.footerSections) : Collections.EMPTY_LIST;
            return richTooltip;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setMainIconFactory(ResizableIcon.Factory mainIconFactory) {
            this.mainIconFactory = mainIconFactory;
            return this;
        }

        public Builder addDescriptionSection(String section) {
            if (this.descriptionSections == null) {
                this.descriptionSections = new LinkedList<String>();
            }
            this.descriptionSections.add(section);
            return this;
        }

        public Builder setFooterIconFactory(ResizableIcon.Factory footerIconFactory) {
            this.footerIconFactory = footerIconFactory;
            return this;
        }

        public Builder addFooterSection(String section) {
            if (this.footerSections == null) {
                this.footerSections = new LinkedList<String>();
            }
            this.footerSections.add(section);
            return this;
        }
    }
}

