/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.CommandAction;
import org.pushingpixels.flamingo.api.common.CommandActionEvent;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.RichTooltipManager;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;
import org.pushingpixels.neon.icon.ResizableIcon;

public abstract class AbstractCommandButton
extends RichTooltipManager.JTrackableComponent {
    public static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    public static final double DEFAULT_GAP_SCALE_FACTOR = 1.0;
    protected Projection<AbstractCommandButton, ? extends Command, CommandButtonPresentationModel> projection;
    protected Command command;
    protected CommandButtonPresentationModel commandPresentation;
    protected ResizableIcon icon;
    private ResizableIcon disabledIcon;
    private String text;
    private ActionButtonModel actionModel;
    protected String extraText;
    protected CommandButtonPresentationState presentationState;
    private int iconDimension;
    protected boolean isFlat;
    private int horizontalAlignment;
    private double hgapScaleFactor;
    private double vgapScaleFactor;
    private RichTooltip actionRichTooltip;
    private CommandButtonLocationOrderKind locationOrderKind;
    protected ActionHandler actionHandler;
    protected String actionKeyTip;

    public AbstractCommandButton(Projection<AbstractCommandButton, ? extends Command, CommandButtonPresentationModel> projection) {
        boolean hasAction;
        this.projection = projection;
        this.command = (Command)projection.getContentModel();
        this.commandPresentation = (CommandButtonPresentationModel)projection.getPresentationModel();
        this.setText(this.command.getText());
        this.setExtraText(this.command.getExtraText());
        this.setIcon(this.command.getIconFactory() != null ? this.command.getIconFactory().createNewIcon() : null);
        this.setDisabledIcon(this.command.getDisabledIconFactory() != null ? this.command.getDisabledIconFactory().createNewIcon() : null);
        boolean bl = hasAction = this.command.getAction() != null;
        if (hasAction) {
            this.addCommandListener(this.command.getAction());
            this.setActionRichTooltip(this.command.getActionRichTooltip());
            this.setActionKeyTip(this.commandPresentation.getActionKeyTip());
        }
        if (!this.commandPresentation.isToDismissPopupsOnActivation()) {
            this.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        }
        this.setPresentationState(this.commandPresentation.getPresentationState());
        this.setHorizontalAlignment(this.commandPresentation.getHorizontalAlignment());
        this.setHGapScaleFactor(this.commandPresentation.getHorizontalGapScaleFactor());
        this.setVGapScaleFactor(this.commandPresentation.getVerticalGapScaleFactor());
        this.setFlat(this.commandPresentation.isFlat());
        this.setFocusable(this.commandPresentation.isFocusable());
        if (this.commandPresentation.getIconDimension() != null) {
            this.setIconDimension(this.commandPresentation.getIconDimension());
        }
        this.actionHandler = new ActionHandler();
        this.setOpaque(false);
    }

    public AbstractCommandButton(Command command, CommandButtonPresentationModel commandPresentation) {
        boolean hasAction;
        this.command = command;
        this.commandPresentation = commandPresentation;
        this.setText(command.getText());
        this.setExtraText(command.getExtraText());
        this.setIcon(command.getIconFactory() != null ? command.getIconFactory().createNewIcon() : null);
        this.setDisabledIcon(command.getDisabledIconFactory() != null ? command.getDisabledIconFactory().createNewIcon() : null);
        boolean bl = hasAction = command.getAction() != null;
        if (hasAction) {
            this.addCommandListener(command.getAction());
            this.setActionRichTooltip(command.getActionRichTooltip());
            this.setActionKeyTip(commandPresentation.getActionKeyTip());
        }
        if (!commandPresentation.isToDismissPopupsOnActivation()) {
            this.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        }
        this.setPresentationState(commandPresentation.getPresentationState());
        this.setHorizontalAlignment(commandPresentation.getHorizontalAlignment());
        this.setHGapScaleFactor(commandPresentation.getHorizontalGapScaleFactor());
        this.setVGapScaleFactor(commandPresentation.getVerticalGapScaleFactor());
        this.setFlat(commandPresentation.isFlat());
        this.setFocusable(commandPresentation.isFocusable());
        if (commandPresentation.getIconDimension() != null) {
            this.setIconDimension(commandPresentation.getIconDimension());
        }
        this.actionHandler = new ActionHandler();
        this.setOpaque(false);
    }

    public void setUI(CommandButtonUI ui) {
        super.setUI(ui);
    }

    @Override
    public CommandButtonUI getUI() {
        return (CommandButtonUI)this.ui;
    }

    public CommandButtonProjection<? extends Command> getProjection() {
        return (CommandButtonProjection)this.projection;
    }

    public void setPresentationState(CommandButtonPresentationState state) {
        CommandButtonPresentationState old = this.presentationState;
        this.presentationState = state;
        this.firePropertyChange("presentationState", old, this.presentationState);
    }

    public ResizableIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ResizableIcon defaultIcon) {
        ResizableIcon oldValue = this.icon;
        this.icon = defaultIcon;
        this.firePropertyChange("icon", oldValue, defaultIcon);
        if (defaultIcon != oldValue) {
            if (defaultIcon == null || oldValue == null || defaultIcon.getIconWidth() != oldValue.getIconWidth() || defaultIcon.getIconHeight() != oldValue.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public void setDisabledIcon(ResizableIcon disabledIcon) {
        this.disabledIcon = disabledIcon;
    }

    public ResizableIcon getDisabledIcon() {
        return this.disabledIcon;
    }

    public CommandButtonPresentationState getPresentationState() {
        return this.presentationState;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public void setExtraText(String extraText) {
        String oldValue = this.extraText;
        this.extraText = extraText;
        this.firePropertyChange("extraText", oldValue, extraText);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, extraText);
        }
        if (extraText == null || oldValue == null || !extraText.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChange("text", oldValue, text);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", oldValue, text);
        }
        if (text == null || oldValue == null || !text.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setIconDimension(int dimension) {
        if (this.iconDimension != dimension) {
            int old = this.iconDimension;
            this.iconDimension = dimension;
            this.firePropertyChange("iconDimension", old, this.iconDimension);
        }
    }

    public int getIconDimension() {
        return this.iconDimension;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public void setFlat(boolean isFlat) {
        boolean old = this.isFlat;
        this.isFlat = isFlat;
        if (old != this.isFlat) {
            this.firePropertyChange("flat", old, this.isFlat);
        }
        if (old != isFlat) {
            this.repaint();
        }
    }

    public ActionButtonModel getActionModel() {
        return this.actionModel;
    }

    public void setActionModel(ActionButtonModel newModel) {
        ActionButtonModel oldModel = this.getActionModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.actionHandler);
            oldModel.removeActionListener(this.actionHandler);
        }
        this.actionModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.actionHandler);
            newModel.addActionListener(this.actionHandler);
        }
        this.firePropertyChange("actionModel", oldModel, newModel);
        if (newModel != oldModel) {
            this.revalidate();
            this.repaint();
        }
    }

    public void addCommandListener(CommandAction l) {
        this.listenerList.add(CommandAction.class, l);
    }

    public void removeCommandListener(CommandAction l) {
        this.listenerList.remove(CommandAction.class, l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.actionModel != null && !b && this.actionModel.isRollover()) {
            this.actionModel.setRollover(false);
        }
        super.setEnabled(b);
        if (this.actionModel != null) {
            this.actionModel.setEnabled(b);
        }
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(ce);
        }
    }

    protected void fireActionPerformed(ActionEvent event) {
        String actionCommand;
        int i;
        Object[] listeners = this.listenerList.getListenerList();
        CommandActionEvent e = null;
        for (i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandAction.class) continue;
            if (e == null) {
                actionCommand = event.getActionCommand();
                e = new CommandActionEvent(this, 1001, this.command, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((CommandAction)listeners[i + 1]).commandActivated(e);
        }
        for (i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                actionCommand = event.getActionCommand();
                e = new CommandActionEvent(this, 1001, this.command, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == this.horizontalAlignment) {
            return;
        }
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = alignment;
        this.firePropertyChange("horizontalAlignment", oldValue, this.horizontalAlignment);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHGapScaleFactor(double hgapScaleFactor) {
        if (hgapScaleFactor == this.hgapScaleFactor) {
            return;
        }
        double oldValue = this.hgapScaleFactor;
        this.hgapScaleFactor = hgapScaleFactor;
        this.firePropertyChange("hgapScaleFactor", oldValue, this.hgapScaleFactor);
        if (this.hgapScaleFactor != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setVGapScaleFactor(double vgapScaleFactor) {
        if (vgapScaleFactor == this.vgapScaleFactor) {
            return;
        }
        double oldValue = this.vgapScaleFactor;
        this.vgapScaleFactor = vgapScaleFactor;
        this.firePropertyChange("vgapScaleFactor", oldValue, this.vgapScaleFactor);
        if (this.vgapScaleFactor != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setGapScaleFactor(double gapScaleFactor) {
        this.setHGapScaleFactor(gapScaleFactor);
        this.setVGapScaleFactor(gapScaleFactor);
    }

    public double getHGapScaleFactor() {
        return this.hgapScaleFactor;
    }

    public double getVGapScaleFactor() {
        return this.vgapScaleFactor;
    }

    public void doActionClick() {
        Dimension size = this.getSize();
        ActionButtonModel actionModel = this.getActionModel();
        actionModel.setArmed(true);
        actionModel.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        actionModel.setPressed(false);
        actionModel.setArmed(false);
    }

    boolean hasRichTooltips() {
        return this.actionRichTooltip != null;
    }

    public void setActionRichTooltip(RichTooltip richTooltip) {
        this.actionRichTooltip = richTooltip;
        RichTooltipManager richToolTipManager = RichTooltipManager.sharedInstance();
        if (this.hasRichTooltips()) {
            richToolTipManager.registerComponent(this);
        } else {
            richToolTipManager.unregisterComponent(this);
        }
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent mouseEvent) {
        return this.actionRichTooltip;
    }

    @Override
    public void setToolTipText(String text) {
        throw new UnsupportedOperationException("Use rich tooltip APIs");
    }

    public CommandButtonLocationOrderKind getLocationOrderKind() {
        return this.locationOrderKind;
    }

    public void setLocationOrderKind(CommandButtonLocationOrderKind locationOrderKind) {
        CommandButtonLocationOrderKind old = this.locationOrderKind;
        if (old != locationOrderKind) {
            this.locationOrderKind = locationOrderKind;
            this.firePropertyChange("locationOrderKind", (Object)old, (Object)this.locationOrderKind);
        }
    }

    public String getActionKeyTip() {
        return this.actionKeyTip;
    }

    public void setActionKeyTip(String actionKeyTip) {
        String old = this.actionKeyTip;
        this.actionKeyTip = actionKeyTip;
        this.firePropertyChange("actionKeyTip", old, this.actionKeyTip);
    }

    class ActionHandler
    implements ActionListener,
    ChangeListener {
        ActionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractCommandButton.this.fireStateChanged();
            AbstractCommandButton.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractCommandButton.this.fireActionPerformed(event);
        }
    }

    public static enum CommandButtonLocationOrderKind {
        ONLY,
        FIRST,
        MIDDLE,
        LAST;

    }
}

